/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.common.container.menu.WeaponsBlockContainerMenu;
import com.onewhohears.dscombat.common.network.toserver.ToServerCraftWeapon;
import com.onewhohears.dscombat.crafting.WeaponRecipe;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class WeaponsBlockScreen
extends AbstractContainerScreen<WeaponsBlockContainerMenu> {
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("dscombat", "textures/ui/aircraft_screen.png");
    private static final int buttonNum = 7;
    private List<Integer> fails = new ArrayList<Integer>();
    private final int maxTab;
    private int tabIndex = 0;
    private int weaponIndex = 0;

    public WeaponsBlockScreen(WeaponsBlockContainerMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 256;
        this.f_97727_ = 256;
        this.maxTab = (int)((float)WeaponPresets.get().getWeaponRecipes(Minecraft.m_91087_().f_91073_.m_7465_()).length / 7.0f);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int index;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        Minecraft m = Minecraft.m_91087_();
        RenderSystem.m_69478_();
        if (WeaponPresets.get().getWeaponRecipeNum() == 0) {
            return;
        }
        int startX = this.f_97735_ + this.f_97728_;
        int startY = this.f_97736_ + this.f_97729_;
        int wx = startX + 51;
        int wy = startY + 12;
        for (int i = 0; i < 7 && (index = this.tabIndex * 7 + i) < WeaponPresets.get().getWeaponRecipeNum(); ++i) {
            ItemStack stack = WeaponPresets.get().getWeaponRecipes(m.f_91073_.m_7465_())[index].m_8043_();
            m.m_91291_().m_115203_(stack, wx, wy);
            m.m_91291_().m_115169_(this.f_96547_, stack, wx, wy);
            wx += 20;
        }
        WeaponRecipe recipe = WeaponPresets.get().getWeaponRecipes(m.f_91073_.m_7465_())[this.weaponIndex];
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        for (int i = 0; i < ((WeaponsBlockContainerMenu)this.m_6262_()).recipeSlots.m_6643_(); ++i) {
            if (i < ingredients.size()) {
                ItemStack[] items = ((Ingredient)ingredients.get(i)).m_43908_();
                ItemStack stack = items.length == 0 ? Items.f_42127_.m_7968_() : items[m.f_91074_.f_19797_ / 20 % items.length];
                ((WeaponsBlockContainerMenu)this.m_6262_()).recipeSlots.m_6836_(i, stack);
                if (!this.fails.contains(i)) continue;
                Slot slot = ((WeaponsBlockContainerMenu)this.m_6262_()).m_38853_(i);
                int left = this.f_97735_ + slot.f_40220_;
                int top = this.f_97736_ + slot.f_40221_;
                WeaponsBlockScreen.m_93172_((PoseStack)poseStack, (int)left, (int)top, (int)(left + 17), (int)(top + 17), (int)0x77FF0000);
                continue;
            }
            ((WeaponsBlockContainerMenu)this.m_6262_()).recipeSlots.m_6836_(i, ItemStack.f_41583_);
        }
    }

    protected void m_7286_(PoseStack stack, float pTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG_TEXTURE);
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(stack, this.f_96539_, (float)(this.f_97728_ + 38), (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(stack, this.f_169604_, (float)(this.f_97730_ + 38), (float)(this.f_97731_ + 56), 0x404040);
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"ui.dscombat.ingredients"), (float)(this.f_97728_ + 123), (float)(this.f_97729_ + 32), 43520);
        if (WeaponPresets.get().getWeaponRecipeNum() == 0) {
            return;
        }
        WeaponRecipe wr = WeaponPresets.get().getWeaponRecipes(Minecraft.m_91087_().f_91073_.m_7465_())[this.weaponIndex];
        WeaponStats data = wr.getWeaponData();
        if (data == null) {
            return;
        }
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)data.getDisplayNameComponent());
        data.addToolTips(list, true);
        this.f_96547_.m_92889_(stack, (Component)list.get(0), (float)(this.f_97728_ + 38), (float)(this.f_97729_ + 34), 263172);
        float scale = 0.5f;
        stack.m_85841_(scale, scale, scale);
        float invScale = 1.0f / scale;
        int startX = (int)((float)(this.f_97728_ + 38) * invScale);
        int startY = (int)((float)(this.f_97729_ + 43) * invScale);
        for (int i = 1; i < list.size(); ++i) {
            this.f_96547_.m_92889_(stack, (Component)list.get(i), (float)startX, (float)startY, ((Component)list.get(i)).m_7383_().m_131135_().m_131265_());
            Objects.requireNonNull(this.f_96547_);
            startY += 9;
        }
        stack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
    }

    protected void m_7856_() {
        super.m_7856_();
        int startX = this.f_97735_ + this.f_97728_;
        int startY = this.f_97736_ + this.f_97729_;
        int wx = startX + 39;
        int wy = startY + 10;
        Button prevButton = new Button(0, 0, 10, 20, (Component)UtilMCText.literal((String)"<"), onPress -> this.prevButton());
        prevButton.f_93620_ = wx;
        prevButton.f_93621_ = wy;
        this.m_142416_((GuiEventListener)prevButton);
        wx += 10;
        int b = 0;
        while (b < 7) {
            int c = b++;
            Button acb = new Button(0, 0, 20, 20, (Component)UtilMCText.empty(), onPress -> this.weaponButton(c));
            acb.f_93620_ = wx;
            acb.f_93621_ = wy;
            this.m_142416_((GuiEventListener)acb);
            wx += 20;
        }
        Button nextButton = new Button(0, 0, 10, 20, (Component)UtilMCText.literal((String)">"), onPress -> this.nextButton());
        nextButton.f_93620_ = wx;
        nextButton.f_93621_ = wy;
        this.m_142416_((GuiEventListener)nextButton);
        Button craftButton = new Button(0, 0, 80, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.craft_button"), onPress -> this.craftButton());
        craftButton.f_93620_ = startX + 122;
        craftButton.f_93621_ = startY + 110;
        this.m_142416_((GuiEventListener)craftButton);
    }

    public void m_181908_() {
        super.m_181908_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void prevButton() {
        --this.tabIndex;
        if (this.tabIndex < 0) {
            this.tabIndex = this.maxTab;
        }
    }

    private void nextButton() {
        ++this.tabIndex;
        if (this.tabIndex > this.maxTab) {
            this.tabIndex = 0;
        }
    }

    private void weaponButton(int num) {
        this.resetFails();
        int max = WeaponPresets.get().getWeaponRecipeNum();
        int a = this.tabIndex * 7 + num;
        this.weaponIndex = a >= max ? max - 1 : a;
    }

    private void craftButton() {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer player = m.f_91074_;
        if (player == null) {
            return;
        }
        WeaponRecipe recipe = WeaponPresets.get().getWeaponRecipes(m.f_91073_.m_7465_())[this.weaponIndex];
        if (recipe.matches(player.m_150109_(), (Level)m.f_91073_)) {
            new ToServerCraftWeapon(recipe.m_6423_(), ((WeaponsBlockContainerMenu)this.f_97732_).getPos()).sendToServer();
        } else {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.cant_craft"), true);
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12507_, (float)1.0f));
            this.setFails(UtilItem.testRecipeFails(recipe.m_7527_(), (Container)player.m_150109_()));
        }
    }

    public void setFails(List<Integer> fails) {
        if (fails == null) {
            return;
        }
        this.fails = fails;
    }

    public void resetFails() {
        this.fails.clear();
    }
}

