/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientDebugHitboxPos;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitbox;
import com.onewhohears.onewholibs.util.UtilMCText;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class DebugHitboxPosCommand {
    public DebugHitboxPosCommand(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debughitboxpos").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"hitbox_name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"size", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"rel_pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            String hitbox_name = StringArgumentType.getString((CommandContext)context, (String)"hitbox_name");
            Vec3 rel_pos = Vec3Argument.m_120844_((CommandContext)context, (String)"rel_pos");
            Vec3 size = Vec3Argument.m_120844_((CommandContext)context, (String)"size");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)UtilMCText.translatable((String)"error.dscombat.command_players_only"));
                return 0;
            }
            Entity patt0$temp = player.m_20201_();
            if (!(patt0$temp instanceof EntityVehicle)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)UtilMCText.translatable((String)"error.dscombat.command_must_ride_vehicle"));
                return 0;
            }
            EntityVehicle vehicle = (EntityVehicle)patt0$temp;
            RotableHitbox hitbox = vehicle.getHitboxByName(hitbox_name);
            if (hitbox == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)UtilMCText.translatable((String)"error.dscombat.hitbox_name_not_exist", (Object[])new Object[]{hitbox_name}));
                return 0;
            }
            hitbox.setTestPos(rel_pos);
            hitbox.setTestSize(size);
            PacketHandler.sendToTrackers(new ToClientDebugHitboxPos(vehicle, hitbox_name, rel_pos, size), (Entity)vehicle);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)UtilMCText.translatable((String)"success.dscombat.changed_hitbox_position"), false);
            return 1;
        })))));
    }
}

