/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.util.UtilClientPacket;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;

public class ToClientDelayedSound
extends BaseS2CMessage {
    public final String soundId;
    public final Vec3 pos;
    public final float range;
    public final float volume;
    public final float pitch;

    public ToClientDelayedSound(SoundEvent sound, Vec3 pos, float range, float volume, float pitch) {
        this.soundId = sound.m_11660_().toString();
        this.pos = pos;
        this.range = range;
        this.volume = volume;
        this.pitch = pitch;
    }

    public ToClientDelayedSound(FriendlyByteBuf buffer) {
        this.soundId = buffer.m_130277_();
        this.pos = (Vec3)DataSerializers.VEC3.m_6709_(buffer);
        this.range = buffer.readFloat();
        this.volume = buffer.readFloat();
        this.pitch = buffer.readFloat();
    }

    public MessageType getType() {
        return PacketHandler.S2C_DELAYED_SOUND;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.soundId);
        DataSerializers.VEC3.m_6856_(buffer, (Object)this.pos);
        buffer.writeFloat(this.range);
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> UtilClientPacket.delayedSound(this.soundId, this.pos, this.range, this.volume, this.pitch));
    }
}

