/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toserver;

import com.mojang.datafixers.util.Pair;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.crafting.WeaponPartRecipe;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilItem;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ToServerCraftWeaponPart
extends BaseC2SMessage {
    public final String recipeId;
    public final BlockPos pos;

    public ToServerCraftWeaponPart(ResourceLocation recipeId, BlockPos pos) {
        this.recipeId = recipeId.toString();
        this.pos = pos;
    }

    public ToServerCraftWeaponPart(FriendlyByteBuf buffer) {
        this.recipeId = buffer.m_130277_();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.pos = new BlockPos(x, y, z);
    }

    public MessageType getType() {
        return PacketHandler.C2S_CRAFT_WEAPON_PART;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.recipeId);
        buffer.writeDouble((double)this.pos.m_123341_());
        buffer.writeDouble((double)this.pos.m_123342_());
        buffer.writeDouble((double)this.pos.m_123343_());
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            Player player = context.getPlayer();
            Level level = UtilEntity.getLevel((Entity)player);
            Optional option = level.m_7465_().m_220248_((RecipeType)WeaponPartRecipe.Type.INSTANCE, (Container)player.m_150109_(), level, new ResourceLocation(this.recipeId));
            if (option.isEmpty()) {
                return;
            }
            WeaponPartRecipe recipe = (WeaponPartRecipe)((Pair)option.get()).getSecond();
            UtilItem.handleInventoryRecipe((Player)player, (Recipe)recipe, (BlockPos)this.pos);
        });
    }
}

