/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import com.onewhohears.dscombat.crafting.VehicleRecipe;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class VehiclePresets
extends JsonPresetReloadListener<VehicleStats> {
    private static VehiclePresets instance;
    private VehicleRecipe[] tanks;
    private VehicleRecipe[] helis;
    private VehicleRecipe[] planes;
    private VehicleRecipe[] boats;

    public static VehiclePresets get() {
        if (instance == null) {
            instance = new VehiclePresets();
        }
        return instance;
    }

    public VehiclePresets() {
        super("vehicle");
    }

    public void registerDefaultPresetTypes() {
        this.addPresetType(VehicleType.PLANE);
        this.addPresetType(VehicleType.HELICOPTER);
        this.addPresetType(VehicleType.CAR);
        this.addPresetType(VehicleType.BOAT);
        this.addPresetType(VehicleType.SUBMARINE);
        this.addPresetType(VehicleType.STATIONARY);
    }

    public VehicleRecipe[] getTankRecipes(RecipeManager recipeManager) {
        if (this.tanks == null) {
            ArrayList<VehicleRecipe> list = new ArrayList<VehicleRecipe>();
            List aircraftRecipes = recipeManager.m_44013_((RecipeType)VehicleRecipe.Type.INSTANCE);
            for (VehicleRecipe recipe : aircraftRecipes) {
                if (!recipe.getVehicleStats().isTank()) continue;
                list.add(recipe);
            }
            this.tanks = list.toArray(new VehicleRecipe[list.size()]);
            this.sort(this.tanks);
        }
        return this.tanks;
    }

    public VehicleRecipe[] getHeliRecipes(RecipeManager recipeManager) {
        if (this.helis == null) {
            ArrayList<VehicleRecipe> list = new ArrayList<VehicleRecipe>();
            List aircraftRecipes = recipeManager.m_44013_((RecipeType)VehicleRecipe.Type.INSTANCE);
            for (VehicleRecipe recipe : aircraftRecipes) {
                if (!recipe.getVehicleStats().isHeli()) continue;
                list.add(recipe);
            }
            this.helis = list.toArray(new VehicleRecipe[list.size()]);
            this.sort(this.helis);
        }
        return this.helis;
    }

    public VehicleRecipe[] getPlaneRecipes(RecipeManager recipeManager) {
        if (this.planes == null) {
            ArrayList<VehicleRecipe> list = new ArrayList<VehicleRecipe>();
            List aircraftRecipes = recipeManager.m_44013_((RecipeType)VehicleRecipe.Type.INSTANCE);
            for (VehicleRecipe recipe : aircraftRecipes) {
                if (!recipe.getVehicleStats().isPlane()) continue;
                list.add(recipe);
            }
            this.planes = list.toArray(new VehicleRecipe[list.size()]);
            this.sort(this.planes);
        }
        return this.planes;
    }

    public VehicleRecipe[] getBoatRecipes(RecipeManager recipeManager) {
        if (this.boats == null) {
            ArrayList<VehicleRecipe> list = new ArrayList<VehicleRecipe>();
            List aircraftRecipes = recipeManager.m_44013_((RecipeType)VehicleRecipe.Type.INSTANCE);
            for (VehicleRecipe recipe : aircraftRecipes) {
                if (!recipe.getVehicleStats().isBoat()) continue;
                list.add(recipe);
            }
            this.boats = list.toArray(new VehicleRecipe[list.size()]);
            this.sort(this.boats);
        }
        return this.boats;
    }

    public void sort(VehicleRecipe[] recipes) {
        Arrays.sort(recipes, VehicleRecipe::compare);
    }

    public VehicleStats[] getNewArray(int i) {
        return new VehicleStats[i];
    }

    protected void resetCache() {
        this.tanks = null;
        this.helis = null;
        this.planes = null;
        this.boats = null;
    }
}

