/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle.physics;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.data.vehicle.physics.LiftSurfaceData;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.dscombat.entity.PhysicsBody;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class LiftSurfaceInstance
extends PhysicsComponentInstance<LiftSurfaceData> {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private float aoa = 0.0f;
    private Vec3 dragForce = Vec3.f_82478_;
    private Vec3 liftForce = Vec3.f_82478_;

    public LiftSurfaceInstance(LiftSurfaceData data) {
        super(data);
    }

    @Override
    protected void calcPhysics(PhysicsBody body) {
        float rotate;
        QuaternionF vehicleQ;
        if (((LiftSurfaceData)this.getData()).isIgnoreRoll()) {
            vehicleQ = QuaternionF.ONE.copy();
            vehicleQ.mul(Vec3f.XP.rotationDegrees(body.m_146909_()));
            vehicleQ.mul(Vec3f.YP.rotationDegrees(body.m_146908_()));
        } else {
            vehicleQ = body.getQBySide().copy();
        }
        QuaternionF surfaceQ = vehicleQ.copy();
        Vec3f rotation = ((LiftSurfaceData)this.getData()).getRotation();
        if (rotation.x() != 0.0f) {
            surfaceQ.mul(Vec3f.XN.rotationDegrees(rotation.x()));
        }
        if (rotation.y() != 0.0f) {
            surfaceQ.mul(Vec3f.YP.rotationDegrees(rotation.y()));
        }
        if (rotation.z() != 0.0f) {
            surfaceQ.mul(Vec3f.ZP.rotationDegrees(rotation.z()));
        }
        if ((rotate = ((LiftSurfaceData)this.getData()).getInputType().getRotationFromInput((LiftSurfaceData)this.getData(), body)) != 0.0f) {
            surfaceQ.mul(Vec3f.XN.rotationDegrees(rotate));
        }
        Vec3 u = body.m_20184_();
        Vec3 pitchAxis = UtilAngles.getPitchAxis((QuaternionF)surfaceQ);
        Vec3 liftDir = u.m_82537_(pitchAxis).m_82541_();
        Vec3 airFoilAxes = UtilAngles.getRollAxis((QuaternionF)surfaceQ);
        float airFoilSpeedSqr = (float)UtilGeometry.vecCompByNormAxis((Vec3)u, (Vec3)airFoilAxes).m_82556_() * 400.0f;
        Vec3 wingNormal = UtilAngles.getYawAxis((QuaternionF)surfaceQ).m_82490_(-1.0);
        float goalAOA = UtilGeometry.isZero((Vec3)u) ? 0.0f : LiftSurfaceInstance.calcAOA(u, wingNormal);
        this.aoa = Mth.m_14179_((float)LiftSurfaceInstance.getAOAChangeRate(body), (float)this.aoa, (float)goalAOA);
        float speedScaleSqr = (float)(1.0 / body.getHorizontalSpeedScale() / body.getHorizontalSpeedScale());
        float liftK = this.getLiftK(this.aoa) * speedScaleSqr;
        double P = this.getAirDensity(body);
        double wingLiftMag = 0.5 * (double)liftK * P * (double)airFoilSpeedSqr * ((LiftSurfaceData)this.getData()).getArea();
        this.liftForce = liftDir.m_82490_(wingLiftMag);
        body.addForce(this.liftForce);
        QuaternionF vehicleQI = vehicleQ.copy();
        vehicleQI.conj();
        Vec3 liftMoment = ((LiftSurfaceData)this.getData()).getPos().m_82537_(UtilAngles.rotateVector((Vec3)this.liftForce, (QuaternionF)vehicleQI)).m_82542_(-1.0, 1.0, 1.0);
        body.addMoment(liftMoment, true, true);
        Vec3 windDir = u.m_82541_();
        float dragK = this.getDragK(this.aoa) * speedScaleSqr;
        if (dragK < 0.0f) {
            LOGGER.warn("Drag Coefficient is somehow negative. Should not happen! Is the drag graph setup correctly? graph_id = {} aoa = {}", (Object)((LiftSurfaceData)this.getData()).getDragGraph().getId(), (Object)Float.valueOf(this.aoa));
        }
        double dragMag = 0.5 * (double)dragK * P * (double)airFoilSpeedSqr * ((LiftSurfaceData)this.getData()).getArea() * ((LiftSurfaceData)this.getData()).getZeroLiftDrag();
        this.dragForce = windDir.m_82490_(-dragMag);
        body.addDragForce(this.dragForce);
        Vec3 dragMoment = ((LiftSurfaceData)this.getData()).getPos().m_82537_(UtilAngles.rotateVector((Vec3)this.dragForce, (QuaternionF)vehicleQI)).m_82542_(-1.0, 1.0, 1.0);
        body.addMoment(dragMoment, false, true);
    }

    @Override
    protected boolean canCalcPhysics(PhysicsBody body) {
        if (!super.canCalcPhysics(body)) {
            return false;
        }
        return !body.isArcadeMode();
    }

    @Override
    public Vec3 getDragForce() {
        return this.dragForce;
    }

    @Override
    public Vec3 getLiftForce() {
        return this.liftForce;
    }

    @Override
    public float getAOA() {
        return this.aoa;
    }

    protected float getLiftK(float aoa) {
        CompoundTag value;
        if (this.getWindTunnel() != null && (value = this.getWindTunnel().getOverrideValue("lift_coefficient")) != null) {
            double AOA = value.m_128459_("aoa");
            double liftC = value.m_128459_("liftC");
            if (Math.abs((double)aoa - AOA) < 0.1) {
                return (float)liftC;
            }
        }
        return ((LiftSurfaceData)this.getData()).getLiftKGraph().getLerpFloat(aoa);
    }

    protected float getDragK(float aoa) {
        CompoundTag value;
        if (this.getWindTunnel() != null && (value = this.getWindTunnel().getOverrideValue("drag_coefficient")) != null) {
            double AOA = value.m_128459_("aoa");
            double dragC = value.m_128459_("dragC");
            if (Math.abs((double)aoa - AOA) < 0.1) {
                return (float)dragC;
            }
        }
        return ((LiftSurfaceData)this.getData()).getDragGraph().getLerpFloat(aoa);
    }

    protected double getAirDensity(PhysicsBody body) {
        return body.getAirDensity();
    }

    public static float calcAOA(Vec3 u, Vec3 wingNormal) {
        return (float)UtilGeometry.angleBetweenVecPlaneDegrees((Vec3)u, (Vec3)wingNormal);
    }

    public static float getAOAChangeRate(PhysicsBody body) {
        if (body.isTestMode()) {
            return 1.0f;
        }
        return 0.5f;
    }
}

