/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon;

import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;

public class NonTickingMissileManager {
    private static final List<EntityMissile<?>> missiles = new ArrayList();

    public static void serverTick(MinecraftServer server) {
        for (int i = 0; i < missiles.size(); ++i) {
            if (NonTickingMissileManager.tickMissile(missiles.get(i), server)) continue;
            missiles.remove(i--);
        }
    }

    private static boolean tickMissile(EntityMissile<?> missile, MinecraftServer server) {
        if (NonTickingMissileManager.isKilled(missile)) {
            return false;
        }
        ChunkPos cp = missile.m_146902_();
        boolean hasChunk = missile.getWorld().m_7232_(cp.f_45578_, cp.f_45579_);
        boolean inTickRange = missile.inEntityTickingRange();
        int repeats = missile.getTickCountRepeats();
        if (hasChunk && inTickRange && repeats < 5) {
            if (NonTickingMissileManager.isUnloaded(missile)) {
                missile.invokeRevive();
                missile.m_20084_(UUID.randomUUID());
                missile.getWorld().m_7967_(missile);
            }
        } else {
            if (!missile.m_213877_()) {
                missile.discardButTick();
            }
            missile.tickOutRange();
            DependencySafety.addExtraEntityToRDP(server, missile, new ServerPlayer[0]);
        }
        return true;
    }

    private static boolean isKilled(EntityMissile<?> missile) {
        if (missile.isDiscardedButTicking()) {
            return false;
        }
        Entity.RemovalReason rr = missile.m_146911_();
        if (rr == null) {
            return false;
        }
        return rr == Entity.RemovalReason.KILLED || rr == Entity.RemovalReason.DISCARDED;
    }

    private static boolean isUnloaded(EntityMissile<?> missile) {
        if (missile.isDiscardedButTicking()) {
            return true;
        }
        Entity.RemovalReason rr = missile.m_146911_();
        if (rr == null) {
            return false;
        }
        return rr == Entity.RemovalReason.CHANGED_DIMENSION || rr == Entity.RemovalReason.UNLOADED_TO_CHUNK || rr == Entity.RemovalReason.UNLOADED_WITH_PLAYER;
    }

    public static void addMissile(EntityMissile<?> missile) {
        missiles.add(missile);
    }

    public static List<EntityMissile<?>> getMissiles() {
        return missiles;
    }
}

