/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.instance;

import com.onewhohears.dscombat.data.weapon.WeaponShootParameters;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.BulletStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityBullet;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.Random;
import net.minecraft.world.phys.Vec3;

public class BulletInstance<T extends BulletStats>
extends WeaponInstance<T> {
    public BulletInstance(T stats) {
        super(stats);
    }

    @Override
    public EntityWeapon<?> getShootEntity(WeaponShootParameters params) {
        EntityBullet bullet = (EntityBullet)super.getShootEntity(params);
        if (bullet == null) {
            return null;
        }
        bullet.m_20256_(bullet.m_20154_().m_82490_(((BulletStats)this.getStats()).getSpeed()));
        return bullet;
    }

    @Override
    public void setDirection(EntityWeapon<?> weapon, Vec3 direction) {
        float pitch = UtilAngles.getPitch((Vec3)direction);
        float yaw = UtilAngles.getYaw((Vec3)direction);
        Random r = new Random();
        weapon.m_146926_((pitch += (r.nextFloat() - 0.5f) * 2.0f * ((BulletStats)this.getStats()).getInaccuracy()) - this.changeLaunchPitch);
        weapon.m_146922_(yaw += (r.nextFloat() - 0.5f) * 2.0f * ((BulletStats)this.getStats()).getInaccuracy());
    }

    @Override
    protected Vec3 getStartMove(EntityVehicle vehicle) {
        Vec3 move = vehicle.m_20154_().m_82490_(((BulletStats)this.getStats()).getSpeed());
        if (vehicle.isWeaponAngledDown() && ((BulletStats)this.getStats()).canAngleDown()) {
            move = UtilAngles.rotateVector((Vec3)move, (QuaternionF)Vec3f.XN.rotationDegrees(25.0f));
        }
        return move;
    }
}

