/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.AntiRadarMissileStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class AntiRadarMissile<T extends AntiRadarMissileStats>
extends EntityMissile<T> {
    protected List<ARTarget> targets = new ArrayList<ARTarget>();

    public AntiRadarMissile(EntityType<? extends AntiRadarMissile<?>> type, Level level, String defaultWeaponId) {
        super((EntityType<? extends EntityMissile<?>>)type, level, defaultWeaponId);
    }

    @Override
    public WeaponType getWeaponType() {
        return WeaponType.ANTI_RADAR_MISSILE;
    }

    @Override
    public void tickGuide() {
        if (this.f_19797_ % 10 == 0) {
            this.findARTarget();
        }
        if (this.target != null) {
            this.guideToTarget();
        }
    }

    @Override
    public boolean dieIfNoTargetOutsideTickRange() {
        return false;
    }

    protected void findARTarget() {
        this.targets.clear();
        MinecraftServer server = this.getWorld().m_7654_();
        if (server == null) {
            return;
        }
        double rangeSqr = ((AntiRadarMissileStats)((Object)this.getWeaponStats())).getScanRange() * ((AntiRadarMissileStats)((Object)this.getWeaponStats())).getScanRange();
        List players = server.m_6846_().m_11314_();
        for (Object player : players) {
            this.checkEntity((Entity)player, rangeSqr);
        }
        Collection<Entity> entities = TrackableEntitiesManager.getTrackableEntities();
        for (Entity entity : entities) {
            this.checkEntity(entity, rangeSqr);
        }
        if (this.targets.isEmpty()) {
            this.target = null;
            this.targetPos = null;
            return;
        }
        ARTarget max = this.targets.get(0);
        for (int i = 1; i < this.targets.size(); ++i) {
            if (!(this.targets.get((int)i).radiation > max.radiation)) continue;
            max = this.targets.get(i);
        }
        this.target = max.entity;
        this.targetPos = max.entity.m_20182_();
    }

    protected void checkEntity(Entity entity, double rangeSqr) {
        EntityVehicle vehicle;
        if (entity.m_5833_()) {
            return;
        }
        if (this.m_20280_(entity) > rangeSqr) {
            return;
        }
        if (!UtilEntity.getLevel((Entity)entity).m_46472_().equals(this.getWorld().m_46472_())) {
            return;
        }
        if (entity instanceof EntityVehicle) {
            EntityVehicle ev;
            vehicle = ev = (EntityVehicle)entity;
        } else {
            Entity entity2 = entity.m_20201_();
            if (entity2 instanceof EntityVehicle) {
                EntityVehicle ev;
                vehicle = ev = (EntityVehicle)entity2;
            } else {
                return;
            }
        }
        if (!vehicle.radarSystem.hasRadar()) {
            return;
        }
        if (vehicle.getRadarMode().isOff()) {
            return;
        }
        if (!vehicle.radarSystem.canServerTick()) {
            return;
        }
        if (!this.basicCheck((Entity)vehicle)) {
            return;
        }
        float distSqr = (float)this.m_20280_((Entity)vehicle);
        this.targets.add(new ARTarget((Entity)vehicle, (float)vehicle.radarSystem.getMaxAirRange() / distSqr));
    }

    protected boolean basicCheck(Entity ping) {
        if (!ping.m_20096_()) {
            return false;
        }
        if (this.m_7307_(ping)) {
            return false;
        }
        if (!this.checkTargetRange(ping, ((AntiRadarMissileStats)((Object)this.getWeaponStats())).getScanRange())) {
            return false;
        }
        return this.checkCanSee(ping);
    }

    public static class ARTarget {
        public final Entity entity;
        public final float radiation;

        public ARTarget(Entity entity, float radiation) {
            this.entity = entity;
            this.radiation = radiation;
        }
    }
}

