/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.forge;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.DSCombatMod;
import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.client.event.ClientEventHandlers;
import com.onewhohears.dscombat.client.event.DSCEntityRenderers;
import com.onewhohears.dscombat.data.forge.BlockTagGen;
import com.onewhohears.dscombat.data.forge.DSCRecipeGenerator;
import com.onewhohears.dscombat.data.forge.EntityTypeTagGen;
import com.onewhohears.dscombat.data.forge.FluidTagGen;
import com.onewhohears.dscombat.data.forge.ItemTagGen;
import com.onewhohears.dscombat.data.parts.PartPresetGenerator;
import com.onewhohears.dscombat.data.parts.client.PartClientPresetGenerator;
import com.onewhohears.dscombat.data.radar.RadarPresetGenerator;
import com.onewhohears.dscombat.data.sound.forge.DSCSoundDefinitionGenImpl;
import com.onewhohears.dscombat.data.vehicle.VehiclePresetGenerator;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientPresetGenerator;
import com.onewhohears.dscombat.data.weapon.WeaponPresetGenerator;
import com.onewhohears.dscombat.data.weapon.client.WeaponClientPresetGenerator;
import com.onewhohears.dscombat.init.forge.DataSerializersImpl;
import com.onewhohears.dscombat.init.forge.ModArgumentTypesForge;
import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.utils.Env;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="dscombat")
public class DSCombatModForge {
    public DSCombatModForge(FMLJavaModLoadingContext loadingContext) {
        IEventBus modEventBus = loadingContext.getModEventBus();
        EventBuses.registerModEventBus((String)"dscombat", (IEventBus)modEventBus);
        loadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        loadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        loadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        modEventBus.addListener(this::onGatherData);
        DSCombatMod.init();
        if (Platform.getEnvironment() == Env.CLIENT && !DatagenModLoader.isRunningDataGen()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> DSCombatMod::clientInit);
            DSCEntityRenderers.register();
        }
        DataSerializersImpl.register(modEventBus);
        ModArgumentTypesForge.register(modEventBus);
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_236039_(true, (DataProvider)new VehiclePresetGenerator(generator));
            generator.m_236039_(true, (DataProvider)new WeaponPresetGenerator(generator));
            generator.m_236039_(true, (DataProvider)new RadarPresetGenerator(generator));
            generator.m_236039_(true, (DataProvider)new PartPresetGenerator(generator));
            DependencySafety.serverDataGen(generator);
            generator.m_236039_(true, (DataProvider)new DSCRecipeGenerator(generator));
            generator.m_236039_(true, (DataProvider)new EntityTypeTagGen(generator, event.getExistingFileHelper()));
            BlockTagGen blockGen = new BlockTagGen(generator, event.getExistingFileHelper());
            generator.m_236039_(true, (DataProvider)blockGen);
            generator.m_236039_(true, (DataProvider)new ItemTagGen(generator, blockGen, event.getExistingFileHelper()));
            generator.m_236039_(true, (DataProvider)new FluidTagGen(generator, event.getExistingFileHelper()));
        }
        if (event.includeClient()) {
            generator.m_236039_(true, (DataProvider)new DSCSoundDefinitionGenImpl(generator, event.getExistingFileHelper()));
            generator.m_236039_(true, (DataProvider)new VehicleClientPresetGenerator(generator));
            generator.m_236039_(true, (DataProvider)new PartClientPresetGenerator(generator));
            generator.m_236039_(true, (DataProvider)new WeaponClientPresetGenerator(generator));
        }
    }

    @Mod.EventBusSubscriber(modid="dscombat", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        }

        @SubscribeEvent
        public static void registerParticleFactory(RegisterParticleProvidersEvent event) {
            ClientEventHandlers.registerParticleProvider();
        }
    }
}

