/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.init;

import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.forge.DataSerializersImpl;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DataSerializers {
    public static final EntityDataSerializer<QuaternionF> QUATERNION = DataSerializers.register("quaternion", new EntityDataSerializer<QuaternionF>(){

        public void write(FriendlyByteBuf buffer, QuaternionF q) {
            buffer.writeFloat(q.i());
            buffer.writeFloat(q.j());
            buffer.writeFloat(q.k());
            buffer.writeFloat(q.r());
        }

        @NotNull
        public QuaternionF read(FriendlyByteBuf buffer) {
            return new QuaternionF(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }

        @NotNull
        public QuaternionF copy(QuaternionF q) {
            return new QuaternionF(q);
        }
    });
    public static final EntityDataSerializer<Vec3> VEC3 = DataSerializers.register("vec3", new EntityDataSerializer<Vec3>(){

        public void write(FriendlyByteBuf buffer, Vec3 v) {
            buffer.writeFloat((float)v.f_82479_);
            buffer.writeFloat((float)v.f_82480_);
            buffer.writeFloat((float)v.f_82481_);
        }

        @NotNull
        public Vec3 read(FriendlyByteBuf buffer) {
            return new Vec3((double)buffer.readFloat(), (double)buffer.readFloat(), (double)buffer.readFloat());
        }

        @NotNull
        public Vec3 copy(Vec3 v) {
            return new Vec3(v.f_82479_, v.f_82480_, v.f_82481_);
        }
    });
    public static final EntityDataSerializer<PartInstance<?>> PART_DATA = DataSerializers.register("partdata", new EntityDataSerializer<PartInstance<?>>(){

        public void write(FriendlyByteBuf buffer, PartInstance<?> p) {
            p.writeBuffer(buffer);
        }

        @NotNull
        public PartInstance<?> read(FriendlyByteBuf buffer) {
            String presetId = buffer.m_130277_();
            PartStats stats = (PartStats)PartPresets.get().get(presetId);
            PartInstance<?> data = stats.createPartInstance();
            data.readBuffer(buffer);
            return data;
        }

        @NotNull
        public PartInstance<?> copy(PartInstance<?> p) {
            return p;
        }
    });
    public static final EntityDataSerializer<RadarStats.RadarMode> RADAR_MODE = DataSerializers.register("radarmode", DataSerializers.getEnumSerializer(RadarStats.RadarMode.class));
    public static final EntityDataSerializer<EntityVehicle.PermMode> PERM_MODE = DataSerializers.register("permmode", DataSerializers.getEnumSerializer(EntityVehicle.PermMode.class));

    private static <E extends Enum<E>> EntityDataSerializer<E> getEnumSerializer(final Class<E> enumClass) {
        return new EntityDataSerializer<E>(){

            public void write(FriendlyByteBuf buffer, E e) {
                buffer.m_130068_(e);
            }

            @NotNull
            public E read(FriendlyByteBuf buffer) {
                return buffer.m_130066_(enumClass);
            }

            @NotNull
            public E copy(E e) {
                return e;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> EntityDataSerializer<T> register(String id, EntityDataSerializer<T> serializer) {
        void var1_1;
        return DataSerializersImpl.register(id, var1_1);
    }

    public static void init() {
    }
}

