/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.integration.distant_players;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.distant_players.common.core.extra_render_info.ExtraRenderTargetInfo;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DSCVehicleRenderInfo
implements ExtraRenderTargetInfo {
    private String preset = "wooden_plane";
    private QuaternionF q = QuaternionF.ONE;
    private boolean landingGear = false;
    private float throttle = 0.0f;
    private int baseTextureIndex = 0;

    public void tickFakeEntity(@NotNull Entity entity) {
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        vehicle.clientTick();
    }

    public void updateFakeEntity(@NotNull Entity entity) {
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        vehicle.setPreset(this.preset);
        vehicle.updateClientStatsHolder();
        vehicle.setPrevQ(this.q);
        vehicle.setClientQ(this.q);
        vehicle.setLandingGear(this.landingGear);
        vehicle.setCurrentThrottle(this.throttle);
        vehicle.textureManager.setBaseTexture(this.baseTextureIndex);
    }

    public void setupEntityOnCreate(@NotNull Entity entity) {
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        vehicle.setPreset(this.preset);
        vehicle.updateClientStatsHolder();
        vehicle.textureManager.setupTextureLocations();
        vehicle.textureManager.setupDynamicTexture();
    }

    public void getInfoServerSide(@NotNull Entity entity) {
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        this.preset = vehicle.getStatsId();
        this.q = vehicle.getQBySide();
        this.landingGear = vehicle.isLandingGear();
        this.throttle = vehicle.getCurrentThrottle();
        this.baseTextureIndex = vehicle.textureManager.getBaseTextureIndex();
    }

    public void getInfoClientSide(FriendlyByteBuf buffer) {
        this.preset = buffer.m_130277_();
        this.q = (QuaternionF)DataSerializers.QUATERNION.m_6709_(buffer);
        this.landingGear = buffer.readBoolean();
        this.throttle = buffer.readFloat();
        this.baseTextureIndex = buffer.readInt();
    }

    public void encodeInfoServerSide(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.preset);
        DataSerializers.QUATERNION.m_6856_(buffer, (Object)this.q);
        buffer.writeBoolean(this.landingGear);
        buffer.writeFloat(this.throttle);
        buffer.writeInt(this.baseTextureIndex);
    }

    public Vec3 onRender(@NotNull Entity entity, PoseStack poseStack, Camera camera, float yaw, Vec3 renderDisplacement, float partialTick, MultiBufferSource buffer, int packedLight) {
        return renderDisplacement;
    }
}

