/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.integration.jei;

import com.onewhohears.dscombat.crafting.VehicleRecipe;
import com.onewhohears.dscombat.crafting.WeaponPartRecipe;
import com.onewhohears.dscombat.crafting.WeaponRecipe;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.integration.jei.DSCSubTypes;
import com.onewhohears.dscombat.integration.jei.VehicleRecipeCategory;
import com.onewhohears.dscombat.integration.jei.WeaponPartRecipeCategory;
import com.onewhohears.dscombat.integration.jei.WeaponRecipeCategory;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = new ResourceLocation("dscombat", "jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new VehicleRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeaponRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeaponPartRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Minecraft.m_91087_().f_91073_.m_7465_();
        List vehicleRecipes = rm.m_44013_((RecipeType)VehicleRecipe.Type.INSTANCE);
        registration.addRecipes(VehicleRecipeCategory.TYPE, vehicleRecipes);
        List weaponRecipes = rm.m_44013_((RecipeType)WeaponRecipe.Type.INSTANCE);
        registration.addRecipes(WeaponRecipeCategory.TYPE, weaponRecipes);
        List weaponPartRecipes = rm.m_44013_((RecipeType)WeaponPartRecipe.Type.INSTANCE);
        registration.addRecipes(WeaponPartRecipeCategory.TYPE, weaponPartRecipes);
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.VEHICLE.get()), DSCSubTypes.getVehicleSubType());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.TURRET.get()), DSCSubTypes.getPartSubType());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.EXTERNAL_WEAPON_PART.get()), DSCSubTypes.getPartSubType());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.AMMO.get()), DSCSubTypes.getAmmoSubType());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.BULLET.get()), DSCSubTypes.getAmmoSubType());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.BOMB.get()), DSCSubTypes.getAmmoSubType());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.MISSILE.get()), DSCSubTypes.getAmmoSubType());
    }
}

