/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.event;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.event.CameraAngles;
import com.onewhohears.dscombat.client.input.ClientInputManager;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityGimbal;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.mixin.CameraAccess;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;

public class ClientCameraEventHandlers {
    private static class_1297 prevGimbal;
    @Nullable
    private static QuaternionF prevQ;
    private static boolean wasTrackingTarget;
    public static final CameraAngles CAMERA_ANGLES;
    public static final GLFWCursorPosCallbackI customMouseCallback;

    public static void onSetupCameraAngles(class_4184 camera, float pt, CameraAngles angles) {
        class_310 m = class_310.method_1551();
        class_746 player = m.field_1724;
        if (player == null) {
            return;
        }
        if (!player.method_5765()) {
            if (ClientCameraEventHandlers.isCameraEntityEqual(m, prevGimbal)) {
                m.method_1504((class_1297)player);
            }
            prevGimbal = null;
            return;
        }
        class_1297 class_12972 = player.method_5668();
        if (!(class_12972 instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)class_12972;
        boolean detached = !m.field_1690.method_31044().method_31034();
        boolean mirrored = m.field_1690.method_31044().method_31035();
        float camYOffset = 0.0f;
        boolean isPilot = false;
        boolean isCopilot = false;
        class_1297 class_12973 = player.method_5854();
        if (class_12973 instanceof EntityRidablePart) {
            EntityRidablePart seat = (EntityRidablePart)class_12973;
            isPilot = seat.isPilotSeat();
            isCopilot = seat.isCoPilotSeat();
            if (DSCClientInputs.isGimbalMode()) {
                camYOffset = seat.getCameraYOffset();
            }
        }
        if (prevGimbal != null && prevGimbal.method_31481() || !DSCClientInputs.isGimbalMode() && !ClientCameraEventHandlers.isCameraEntityEqual(m, (class_1297)player)) {
            m.method_1504((class_1297)player);
            prevGimbal = null;
        }
        if (DSCClientInputs.isGimbalMode() && (isPilot || isCopilot || camYOffset == 0.0f) && vehicle.getGimbalForPilotCamera() != null) {
            EntityGimbal gimbal = vehicle.getGimbalForPilotCamera();
            if (!ClientCameraEventHandlers.isCameraEntityEqual(m, (class_1297)gimbal)) {
                m.method_1504((class_1297)gimbal);
            }
            gimbal.method_36457(player.method_5695(pt));
            gimbal.method_36456(player.method_5705(pt));
            prevGimbal = gimbal;
            camYOffset = -0.2f;
        }
        if (isPilot) {
            boolean resetMousePressed = ClientInputManager.RESET_MOUSE.isPressed();
            RadarStats.RadarPing target = vehicle.radarSystem.getClientSelectedPing();
            class_1297 camEntity = m.method_1560();
            if (DSCClientInputs.isCameraTrackTarget() && target != null && !resetMousePressed && camEntity != null) {
                class_243 diff = target.pos.method_1020(camEntity.method_5836(pt));
                float x = UtilAngles.getPitch((class_243)diff);
                float y = UtilAngles.getYaw((class_243)diff);
                ClientCameraEventHandlers.setAngles(angles, (class_1657)player, x, y, mirrored);
                wasTrackingTarget = true;
            } else if (DSCClientInputs.isCameraLockedForward()) {
                ClientCameraEventHandlers.lookForward(angles, (class_1657)player, mirrored, pt, vehicle);
                wasTrackingTarget = false;
            } else if (DSCClientInputs.isCameraFreeRelative()) {
                QuaternionF qPT = vehicle.getClientQ(pt);
                if (resetMousePressed) {
                    ClientCameraEventHandlers.lookForward(angles, (class_1657)player, mirrored, pt, vehicle);
                } else if (prevQ != null) {
                    float[] relativeAngles = wasTrackingTarget ? new float[]{DSCClientInputs.xRotPreTrack, DSCClientInputs.yRotPreTrack} : UtilAngles.globalToRelativeDegrees((float)player.method_36455(), (float)player.method_36454(), (QuaternionF)prevQ);
                    float[] globalAngles = UtilAngles.relativeToGlobalDegrees((float)relativeAngles[0], (float)relativeAngles[1], (QuaternionF)qPT);
                    float x = globalAngles[0];
                    float y = globalAngles[1];
                    ClientCameraEventHandlers.setAngles(angles, (class_1657)player, x, y, mirrored);
                    DSCClientInputs.xRotPreTrack = relativeAngles[0];
                    DSCClientInputs.yRotPreTrack = relativeAngles[1];
                }
                prevQ = qPT;
                wasTrackingTarget = false;
            }
        }
        float zi = UtilAngles.lerpAngle((float)pt, (float)vehicle.zRotO, (float)vehicle.zRot);
        if (detached && mirrored) {
            zi *= -1.0f;
        }
        angles.setRoll(zi);
        double camDist = ((VehicleStats)vehicle.getStats()).cameraDistance;
        if (detached && isPilot && camDist > 4.0) {
            double vehicleCamDist = Math.min(0.0, 4.0 - ClientCameraEventHandlers.getMaxDist(camera, (class_1657)player, camDist));
            ((CameraAccess)camera).invokeSetRotation(angles.getYaw(), angles.getPitch());
            camera.method_19324(vehicleCamDist, 0.0, 0.0);
        }
        QuaternionF q = null;
        if (camYOffset != 0.0f) {
            q = UtilAngles.lerpQ((float)pt, (QuaternionF)vehicle.getPrevQ(), (QuaternionF)vehicle.getClientQ());
            class_243 yawAxis = UtilAngles.getYawAxis((QuaternionF)q);
            camera.method_19322(camera.method_19326().method_1019(yawAxis.method_1021((double)camYOffset)));
        }
        if (DSCClientInputs.getLeanAmount() != 0.0) {
            if (q == null) {
                q = UtilAngles.lerpQ((float)pt, (QuaternionF)vehicle.getPrevQ(), (QuaternionF)vehicle.getClientQ());
            }
            class_243 pitchAxis = UtilAngles.getPitchAxis((QuaternionF)q);
            camera.method_19322(camera.method_19326().method_1019(pitchAxis.method_1021(-DSCClientInputs.getLeanAmount())));
        }
    }

    private static boolean isCameraEntityEqual(class_310 m, @Nullable class_1297 e) {
        if (e == null || m.method_1560() == null) {
            return false;
        }
        return m.method_1560().equals((Object)e);
    }

    private static void lookForward(CameraAngles angles, class_1657 player, boolean mirrored, float pt, EntityVehicle vehicle) {
        float x = UtilAngles.lerpAngle((float)pt, (float)vehicle.field_6004, (float)vehicle.method_36455());
        float y = UtilAngles.lerpAngle180((float)pt, (float)vehicle.field_5982, (float)vehicle.method_36454());
        ClientCameraEventHandlers.setAngles(angles, player, x, y, mirrored);
        DSCClientInputs.xRotPreTrack = x;
        DSCClientInputs.yRotPreTrack = y;
    }

    private static void setAngles(CameraAngles angles, class_1657 player, float x, float y, boolean mirrored) {
        player.method_36457(x);
        player.field_6004 = x;
        player.method_36456(y);
        player.field_5982 = y;
        if (mirrored) {
            x *= -1.0f;
            y += 180.0f;
        }
        angles.setPitch(x);
        angles.setYaw(y);
    }

    public static double getMaxDist(class_4184 cam, class_1657 player, double dist) {
        double d0;
        class_243 from = cam.method_19326();
        Vec3f d = Vec3f.from((class_1160)cam.method_19335());
        d.mul((float)(-dist));
        class_243 to = from.method_1031((double)d.x(), (double)d.y(), (double)d.z());
        class_3965 hitresult = UtilEntity.getLevel((class_1297)player).method_17742(new class_3959(from, to, class_3959.class_3960.field_23142, class_3959.class_242.field_1348, (class_1297)player));
        if (hitresult.method_17783() != class_239.class_240.field_1333 && (d0 = hitresult.method_17784().method_1022(from)) < dist) {
            dist = d0;
        }
        return dist;
    }

    public static void clientTickSetMouseCallback(class_310 m) {
        if (m.field_1724 == null || m.field_1724.field_6012 != 1) {
            return;
        }
        if (!((Boolean)Config.CLIENT.cameraTurnRelativeToVehicle.get()).booleanValue()) {
            return;
        }
        GLFW.glfwSetCursorPosCallback((long)m.method_22683().method_4490(), (GLFWCursorPosCallbackI)customMouseCallback);
    }

    static {
        wasTrackingTarget = false;
        CAMERA_ANGLES = new CameraAngles();
        customMouseCallback = (window, x, y) -> {
            class_310 m = class_310.method_1551();
            m.execute(() -> {
                class_1297 patt0$temp;
                double xn = x;
                double yn = y;
                if (window != m.method_22683().method_4490()) {
                    return;
                }
                if (DSCClientInputs.isCameraFree() && m.field_1724 != null && m.field_1755 == null && (patt0$temp = m.field_1724.method_5668()) instanceof EntityVehicle) {
                    EntityVehicle craft = (EntityVehicle)patt0$temp;
                    double r = Math.toRadians(craft.zRot);
                    double dx = x - m.field_1729.method_1603();
                    double dy = y - m.field_1729.method_1604();
                    double cosR = Math.cos(r);
                    double sinR = Math.sin(r);
                    xn = dx * cosR - dy * sinR + m.field_1729.method_1603();
                    yn = dy * cosR + dx * sinR + m.field_1729.method_1604();
                    GLFW.glfwSetCursorPos((long)window, (double)xn, (double)yn);
                }
                m.field_1729.method_1600(window, xn, yn);
            });
        };
    }
}

