/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.input;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public interface ActionInput {
    @NotNull
    public static Button getButtonByJson(JsonObject json) {
        ButtonType type = (ButtonType)UtilParse.getEnumSafe((JsonObject)json, (String)"type", ButtonType.class);
        return type.gen.apply(json);
    }

    @NotNull
    public static Axis getAxisByJson(JsonObject json) {
        AxisType type = (AxisType)UtilParse.getEnumSafe((JsonObject)json, (String)"type", AxisType.class);
        return type.gen.apply(json);
    }

    public static boolean isWindowActive() {
        class_310 m = class_310.method_1551();
        return m.method_1569() && m.field_1755 == null;
    }

    @NotNull
    public String getId();

    @NotNull
    public String getType();

    public void tick();

    public boolean isActive();

    @NotNull
    public JsonObject write();

    default public boolean isUnbound() {
        return false;
    }

    default public boolean isKeyBind() {
        return false;
    }

    public static enum ButtonType {
        UNBOUND_BUTTON("unbound_button", json -> new UnboundButton()),
        DSC_KEY_BUTTON("dsc_key_button", DSCKeyButton::read),
        CONTROLLER_BUTTON("controller_button", ControllerButton::read),
        CONTROLLER_AXIS_BUTTON("controller_axis_button", ControllerAxisButton::read);

        public final String id;
        public final Function<JsonObject, Button> gen;

        private ButtonType(String id, Function<JsonObject, Button> gen) {
            this.id = id;
            this.gen = gen;
        }

        public String getTypeNameString() {
            return "action_type.dscombat." + this.id;
        }

        public class_2561 getTypeName() {
            return UtilMCText.translatable((String)this.getTypeNameString());
        }
    }

    public static abstract class Button
    implements ActionInput {
        private boolean isPressed;
        private boolean wasPressed;

        @Override
        public void tick() {
            this.wasPressed = this.isPressed;
            this.isPressed = this.checkIsPressed();
        }

        public boolean isPressed() {
            return this.isPressed;
        }

        public boolean wasPressed() {
            return this.wasPressed;
        }

        protected abstract boolean checkIsPressed();

        public boolean isInitPressed() {
            return this.isPressed() && !this.wasPressed();
        }

        public boolean isInitReleased() {
            return !this.isPressed() && this.wasPressed();
        }

        @Override
        public boolean isActive() {
            return this.isPressed() || this.wasPressed();
        }

        public abstract ButtonType getButtonType();

        @Override
        @NotNull
        public String getType() {
            return this.getButtonType().id;
        }
    }

    public static enum AxisType {
        UNBOUND_AXIS("unbound_axis", json -> new UnboundAxis()),
        DSC_KEY_AXIS("dsc_key_axis", DSCKeyAxis::read),
        CONTROLLER_AXIS("controller_axis", ControllerAxis::read),
        CONTROLLER_BUTTON_AXIS("controller_button_axis", ControllerButtonAxis::read);

        public final String id;
        public final Function<JsonObject, Axis> gen;

        private AxisType(String id, Function<JsonObject, Axis> gen) {
            this.id = id;
            this.gen = gen;
        }

        public String getTypeNameString() {
            return "action_type.dscombat." + this.id;
        }

        public class_2561 getTypeName() {
            return UtilMCText.translatable((String)this.getTypeNameString());
        }
    }

    public static interface Axis
    extends ActionInput {
        public float getValue();

        public boolean isNegAndPos();

        @Override
        default public boolean isActive() {
            return this.getValue() != 0.0f || this.isNegAndPos();
        }

        public AxisType getAxisType();

        @Override
        @NotNull
        default public String getType() {
            return this.getAxisType().id;
        }

        public boolean isControllerJoystick();
    }

    public static class UnboundAxis
    implements Axis {
        @Override
        public boolean isUnbound() {
            return true;
        }

        @Override
        public float getValue() {
            return 0.0f;
        }

        @Override
        public boolean isNegAndPos() {
            return false;
        }

        @Override
        public AxisType getAxisType() {
            return AxisType.UNBOUND_AXIS;
        }

        @Override
        public boolean isControllerJoystick() {
            return false;
        }

        @Override
        @NotNull
        public String getId() {
            return "none";
        }

        @Override
        public void tick() {
        }

        @Override
        @NotNull
        public JsonObject write() {
            JsonObject json = new JsonObject();
            UtilParse.writeEnum((JsonObject)json, (String)"type", (Enum)this.getAxisType());
            return json;
        }
    }

    public static class UnboundButton
    extends Button {
        @Override
        public boolean isUnbound() {
            return true;
        }

        @Override
        protected boolean checkIsPressed() {
            return false;
        }

        @Override
        @NotNull
        public String getId() {
            return "none";
        }

        @Override
        public ButtonType getButtonType() {
            return ButtonType.UNBOUND_BUTTON;
        }

        @Override
        @NotNull
        public JsonObject write() {
            JsonObject json = new JsonObject();
            UtilParse.writeEnum((JsonObject)json, (String)"type", (Enum)this.getButtonType());
            return json;
        }
    }

    public static class ControllerButtonAxis
    implements Axis {
        @NotNull
        private final String id;
        public final int joystick_id;
        public final int positive_button_id;
        public final int negative_button_id;
        private boolean negativePressed;
        private boolean positivePressed;

        public ControllerButtonAxis(int joystickId, int positiveButtonId, int negativeButtonId) {
            this.id = joystickId + ":" + positiveButtonId + ":" + negativeButtonId;
            this.joystick_id = joystickId;
            this.positive_button_id = positiveButtonId;
            this.negative_button_id = negativeButtonId;
        }

        @Override
        public void tick() {
            this.negativePressed = this.checkIsPressed(this.negative_button_id);
            this.positivePressed = this.checkIsPressed(this.positive_button_id);
        }

        protected boolean checkIsPressed(int button_id) {
            if (!ActionInput.isWindowActive()) {
                return false;
            }
            if (!GLFW.glfwJoystickPresent((int)this.joystick_id)) {
                return false;
            }
            ByteBuffer buttons = GLFW.glfwGetJoystickButtons((int)this.joystick_id);
            if (buttons == null) {
                return false;
            }
            if (button_id > buttons.limit() - 1 && button_id >= 0) {
                return false;
            }
            return buttons.get(button_id) == 1;
        }

        @Override
        public float getValue() {
            if (this.negativePressed && this.positivePressed) {
                return 0.0f;
            }
            if (this.negativePressed) {
                return -1.0f;
            }
            if (this.positivePressed) {
                return 1.0f;
            }
            return 0.0f;
        }

        @Override
        public boolean isNegAndPos() {
            return this.negativePressed && this.positivePressed;
        }

        @Override
        public AxisType getAxisType() {
            return AxisType.CONTROLLER_BUTTON_AXIS;
        }

        @Override
        public boolean isControllerJoystick() {
            return false;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public JsonObject write() {
            JsonObject json = new JsonObject();
            UtilParse.writeEnum((JsonObject)json, (String)"type", (Enum)this.getAxisType());
            json.addProperty("joystick_id", (Number)this.joystick_id);
            json.addProperty("positive_button_id", (Number)this.positive_button_id);
            json.addProperty("negative_button_id", (Number)this.negative_button_id);
            return json;
        }

        public static ControllerButtonAxis read(JsonObject json) {
            return new ControllerButtonAxis(UtilParse.getIntSafe((JsonObject)json, (String)"joystick_id", (int)0), UtilParse.getIntSafe((JsonObject)json, (String)"positive_button_id", (int)0), UtilParse.getIntSafe((JsonObject)json, (String)"negative_button_id", (int)0));
        }
    }

    public static class ControllerAxisButton
    extends Button {
        @NotNull
        private final String id;
        public final int joystick_id;
        public final int axis_id;
        public final float dead_zone;
        public final boolean positive;

        public ControllerAxisButton(int joystick_id, int axis_id, float dead_zone, boolean positive) {
            this.joystick_id = joystick_id;
            this.axis_id = axis_id;
            this.positive = positive;
            this.dead_zone = dead_zone;
            this.id = joystick_id + ":" + axis_id + ":" + positive;
        }

        @Override
        protected boolean checkIsPressed() {
            if (!ActionInput.isWindowActive()) {
                return false;
            }
            if (!GLFW.glfwJoystickPresent((int)this.joystick_id)) {
                return false;
            }
            FloatBuffer axes = GLFW.glfwGetJoystickAxes((int)this.joystick_id);
            if (axes == null) {
                return false;
            }
            if (this.axis_id > axes.limit() - 1 && this.axis_id >= 0) {
                return false;
            }
            float axis = axes.get(this.axis_id);
            if (class_3532.method_15379((float)axis) < this.dead_zone) {
                return false;
            }
            return this.positive && axis > 0.0f || !this.positive && axis < 0.0f;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public ButtonType getButtonType() {
            return ButtonType.CONTROLLER_AXIS_BUTTON;
        }

        @Override
        @NotNull
        public JsonObject write() {
            JsonObject json = new JsonObject();
            UtilParse.writeEnum((JsonObject)json, (String)"type", (Enum)this.getButtonType());
            json.addProperty("joystick_id", (Number)this.joystick_id);
            json.addProperty("axis_id", (Number)this.axis_id);
            json.addProperty("dead_zone", (Number)Float.valueOf(this.dead_zone));
            json.addProperty("positive", Boolean.valueOf(this.positive));
            return json;
        }

        public static ControllerAxisButton read(JsonObject json) {
            return new ControllerAxisButton(UtilParse.getIntSafe((JsonObject)json, (String)"joystick_id", (int)0), UtilParse.getIntSafe((JsonObject)json, (String)"axis_id", (int)0), UtilParse.getFloatSafe((JsonObject)json, (String)"dead_zone", (float)0.0f), UtilParse.getBooleanSafe((JsonObject)json, (String)"positive", (boolean)false));
        }
    }

    public static class ControllerAxis
    implements Axis {
        @NotNull
        private final String id;
        public final int joystick_id;
        public final int axis_id;
        public final float dead_zone;
        public final boolean invert;
        public float value;

        public ControllerAxis(int joystick_id, int axis_id, float dead_zone, boolean invert) {
            this.joystick_id = joystick_id;
            this.axis_id = axis_id;
            this.id = joystick_id + ":" + axis_id;
            this.dead_zone = dead_zone;
            this.invert = invert;
        }

        @Override
        public void tick() {
            this.value = this.checkValue();
        }

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public boolean isNegAndPos() {
            return false;
        }

        private float checkValue() {
            if (!ActionInput.isWindowActive()) {
                return this.value;
            }
            if (!GLFW.glfwJoystickPresent((int)this.joystick_id)) {
                return 0.0f;
            }
            FloatBuffer axes = GLFW.glfwGetJoystickAxes((int)this.joystick_id);
            if (axes == null) {
                return 0.0f;
            }
            if (this.axis_id > axes.limit() - 1 && this.axis_id >= 0) {
                return 0.0f;
            }
            float axis = axes.get(this.axis_id);
            if (class_3532.method_15379((float)axis) < this.dead_zone) {
                return 0.0f;
            }
            if (this.invert) {
                axis *= -1.0f;
            }
            return axis;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public AxisType getAxisType() {
            return AxisType.CONTROLLER_AXIS;
        }

        @Override
        public boolean isControllerJoystick() {
            return true;
        }

        @Override
        @NotNull
        public JsonObject write() {
            JsonObject json = new JsonObject();
            UtilParse.writeEnum((JsonObject)json, (String)"type", (Enum)this.getAxisType());
            json.addProperty("joystick_id", (Number)this.joystick_id);
            json.addProperty("axis_id", (Number)this.axis_id);
            json.addProperty("dead_zone", (Number)Float.valueOf(this.dead_zone));
            json.addProperty("invert", Boolean.valueOf(this.invert));
            return json;
        }

        public static ControllerAxis read(JsonObject json) {
            return new ControllerAxis(UtilParse.getIntSafe((JsonObject)json, (String)"joystick_id", (int)0), UtilParse.getIntSafe((JsonObject)json, (String)"axis_id", (int)0), UtilParse.getFloatSafe((JsonObject)json, (String)"dead_zone", (float)0.0f), UtilParse.getBooleanSafe((JsonObject)json, (String)"invert", (boolean)false));
        }
    }

    public static class ControllerButton
    extends Button {
        @NotNull
        private final String id;
        public final int joystick_id;
        public final int button_id;

        public ControllerButton(int joystick_id, int button_id) {
            this.joystick_id = joystick_id;
            this.button_id = button_id;
            this.id = joystick_id + ":" + button_id;
        }

        @Override
        protected boolean checkIsPressed() {
            if (!ActionInput.isWindowActive()) {
                return false;
            }
            if (!GLFW.glfwJoystickPresent((int)this.joystick_id)) {
                return false;
            }
            ByteBuffer buttons = GLFW.glfwGetJoystickButtons((int)this.joystick_id);
            if (buttons == null) {
                return false;
            }
            if (this.button_id > buttons.limit() - 1 && this.button_id >= 0) {
                return false;
            }
            return buttons.get(this.button_id) == 1;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public ButtonType getButtonType() {
            return ButtonType.CONTROLLER_BUTTON;
        }

        @Override
        @NotNull
        public JsonObject write() {
            JsonObject json = new JsonObject();
            UtilParse.writeEnum((JsonObject)json, (String)"type", (Enum)this.getButtonType());
            json.addProperty("joystick_id", (Number)this.joystick_id);
            json.addProperty("button_id", (Number)this.button_id);
            return json;
        }

        public static ControllerButton read(JsonObject json) {
            return new ControllerButton(UtilParse.getIntSafe((JsonObject)json, (String)"joystick_id", (int)0), UtilParse.getIntSafe((JsonObject)json, (String)"button_id", (int)0));
        }
    }

    public static class DSCKeyAxis
    implements Axis {
        @NotNull
        public final String key_mapping_id_negative;
        @NotNull
        public final String key_mapping_id_positive;
        @NotNull
        private final String id;
        private boolean negativePressed;
        private boolean positivePressed;

        public DSCKeyAxis(@NotNull String key_mapping_id_negative, @NotNull String key_mapping_id_positive) {
            this.id = key_mapping_id_negative + ":" + key_mapping_id_positive;
            this.key_mapping_id_negative = key_mapping_id_negative;
            this.key_mapping_id_positive = key_mapping_id_positive;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public AxisType getAxisType() {
            return AxisType.DSC_KEY_AXIS;
        }

        @Override
        public boolean isControllerJoystick() {
            return false;
        }

        @Override
        public void tick() {
            this.negativePressed = DSCKeys.isKeyPressed(this.key_mapping_id_negative);
            this.positivePressed = DSCKeys.isKeyPressed(this.key_mapping_id_positive);
        }

        @Override
        public float getValue() {
            if (this.negativePressed && this.positivePressed) {
                return 0.0f;
            }
            if (this.negativePressed) {
                return -1.0f;
            }
            if (this.positivePressed) {
                return 1.0f;
            }
            return 0.0f;
        }

        @Override
        public boolean isNegAndPos() {
            return this.negativePressed && this.positivePressed;
        }

        @Override
        @NotNull
        public JsonObject write() {
            JsonObject json = new JsonObject();
            UtilParse.writeEnum((JsonObject)json, (String)"type", (Enum)this.getAxisType());
            json.addProperty("key_mapping_id_negative", this.key_mapping_id_negative);
            json.addProperty("key_mapping_id_positive", this.key_mapping_id_positive);
            return json;
        }

        public static DSCKeyAxis read(JsonObject json) {
            return new DSCKeyAxis(UtilParse.getStringSafe((JsonObject)json, (String)"key_mapping_id_negative", (String)""), UtilParse.getStringSafe((JsonObject)json, (String)"key_mapping_id_positive", (String)""));
        }
    }

    public static class DSCKeyButton
    extends Button {
        public final String key_mapping_id;

        public DSCKeyButton(@NotNull String key_mapping_id) {
            this.key_mapping_id = key_mapping_id;
        }

        @Override
        @NotNull
        public String getId() {
            return this.key_mapping_id;
        }

        @Override
        @NotNull
        public JsonObject write() {
            JsonObject json = new JsonObject();
            UtilParse.writeEnum((JsonObject)json, (String)"type", (Enum)this.getButtonType());
            json.addProperty("key_mapping_id", this.key_mapping_id);
            return json;
        }

        @Override
        protected boolean checkIsPressed() {
            return DSCKeys.isKeyPressed(this.getId());
        }

        @Override
        public ButtonType getButtonType() {
            return ButtonType.DSC_KEY_BUTTON;
        }

        public static DSCKeyButton read(JsonObject json) {
            return new DSCKeyButton(UtilParse.getStringSafe((JsonObject)json, (String)"key_mapping_id", (String)""));
        }

        @Override
        public boolean isKeyBind() {
            return true;
        }
    }
}

