/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.input;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.client.input.ActionInput;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public abstract class ActionInputHolder<A extends ActionInput> {
    @NotNull
    private final String id;
    @NotNull
    private A primaryAction;
    @NotNull
    private A secondaryAction;

    public ActionInputHolder(@NotNull String id, @NotNull A defaultAction, @NotNull A secondaryAction) {
        this.id = id;
        this.primaryAction = defaultAction;
        this.secondaryAction = secondaryAction;
    }

    public void setPrimaryAction(@NotNull A primaryAction) {
        this.primaryAction = primaryAction;
    }

    @NotNull
    public A getPrimaryAction() {
        return this.primaryAction;
    }

    public void setSecondaryAction(@NotNull A secondaryAction) {
        this.secondaryAction = secondaryAction;
    }

    @NotNull
    public A getSecondaryAction() {
        return this.secondaryAction;
    }

    @NotNull
    public A getActiveAction() {
        if (this.getPrimaryAction().isActive() || !this.getSecondaryAction().isActive()) {
            return this.getPrimaryAction();
        }
        return this.getSecondaryAction();
    }

    public void tick() {
        this.getPrimaryAction().tick();
        this.getSecondaryAction().tick();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getNameString() {
        return "action.dscombat." + this.getId();
    }

    @NotNull
    public class_2561 getName() {
        return UtilMCText.translatable((String)this.getNameString());
    }

    public abstract String getType();

    public JsonObject write() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        json.add("primary", (JsonElement)this.getPrimaryAction().write());
        json.add("secondary", (JsonElement)this.getSecondaryAction().write());
        return json;
    }

    public abstract void read(JsonObject var1);

    public static class Axis
    extends ActionInputHolder<ActionInput.Axis> {
        public Axis(@NotNull String id, @NotNull ActionInput.Axis defaultAction) {
            super(id, defaultAction, new ActionInput.UnboundAxis());
        }

        public float getValue() {
            return ((ActionInput.Axis)this.getActiveAction()).getValue();
        }

        public boolean isNegAndPos() {
            return ((ActionInput.Axis)this.getActiveAction()).isNegAndPos();
        }

        public boolean isJoystickController() {
            return ((ActionInput.Axis)this.getActiveAction()).isControllerJoystick();
        }

        @Override
        public String getType() {
            return "axis";
        }

        @Override
        public void read(JsonObject json) {
            JsonObject data;
            if (json.has("primary")) {
                data = UtilParse.getJsonSafe((JsonObject)json, (String)"primary");
                this.setPrimaryAction(ActionInput.getAxisByJson(data));
            }
            if (json.has("secondary")) {
                data = UtilParse.getJsonSafe((JsonObject)json, (String)"secondary");
                this.setSecondaryAction(ActionInput.getAxisByJson(data));
            }
        }
    }

    public static class Button
    extends ActionInputHolder<ActionInput.Button> {
        public Button(@NotNull String id, @NotNull ActionInput.Button defaultAction) {
            super(id, defaultAction, new ActionInput.UnboundButton());
        }

        @Override
        public String getType() {
            return "button";
        }

        @Override
        public void read(JsonObject json) {
            JsonObject data;
            if (json.has("primary")) {
                data = UtilParse.getJsonSafe((JsonObject)json, (String)"primary");
                this.setPrimaryAction(ActionInput.getButtonByJson(data));
            }
            if (json.has("secondary")) {
                data = UtilParse.getJsonSafe((JsonObject)json, (String)"secondary");
                this.setSecondaryAction(ActionInput.getButtonByJson(data));
            }
        }

        public boolean isPressed() {
            return ((ActionInput.Button)this.getActiveAction()).isPressed();
        }

        public boolean wasPressed() {
            return ((ActionInput.Button)this.getActiveAction()).wasPressed();
        }

        public boolean isInitPressed() {
            return ((ActionInput.Button)this.getActiveAction()).isInitPressed();
        }

        public boolean isInitReleased() {
            return ((ActionInput.Button)this.getActiveAction()).isInitReleased();
        }
    }
}

