/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj.custom;

import com.onewhohears.dscombat.client.model.obj.ObjVehicleModel;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.Map;

public class JasonPlaneModel
extends ObjVehicleModel<EntityVehicle> {
    private static final Vec3f PIVOT = new Vec3f(0.0f, -2.0f, 0.0f);

    public JasonPlaneModel() {
        super("jason_plane");
    }

    protected void addComponentTransforms(Map<String, Mat4f> transforms, EntityVehicle entity, float partialTicks) {
        Mat4f right_flap;
        Mat4f left_flap;
        Mat4f lg0_mat;
        Mat4f lg1_mat;
        Mat4f lg2_mat;
        float bladerot = entity.getMotorRotation(partialTicks, 20.0f);
        Mat4f blade0_mat = UtilAngles.pivotPixelsRotZ((float)-0.0426f, (float)42.0581f, (float)82.8989f, (float)bladerot);
        float gearpos = entity.getLandingGearPos(partialTicks);
        if (gearpos >= 1.0f) {
            lg1_mat = lg2_mat = INVISIBLE;
            lg0_mat = lg2_mat;
        } else {
            float degrees = gearpos * 90.0f;
            lg0_mat = UtilAngles.pivotPixelsRotZ((float)39.5712f, (float)28.6068f, (float)25.0786f, (float)(-degrees));
            lg1_mat = UtilAngles.pivotPixelsRotZ((float)-39.5712f, (float)28.6068f, (float)25.0786f, (float)degrees);
            lg2_mat = UtilAngles.pivotPixelsRotX((float)0.0f, (float)34.8817f, (float)-71.9732f, (float)degrees);
        }
        Mat4f rudder = UtilAngles.pivotPixelsRotY((float)0.0f, (float)55.8305f, (float)-107.139f, (float)(entity.inputs.yaw * 15.0f));
        Mat4f left_elevator = UtilAngles.pivotPixelsRotX((float)20.9161f, (float)50.9701f, (float)-99.3629f, (float)(entity.inputs.pitch * 22.0f));
        Mat4f right_elevator = UtilAngles.pivotPixelsRotX((float)-20.9161f, (float)50.9701f, (float)-99.3629f, (float)(entity.inputs.pitch * 22.0f));
        if (entity.isFlapsDown()) {
            left_flap = UtilAngles.pivotPixelsRotX((float)94.4596f, (float)36.7061f, (float)-0.8385f, (float)-22.0f);
            right_flap = UtilAngles.pivotPixelsRotX((float)-94.4596f, (float)36.7061f, (float)-0.8385f, (float)-22.0f);
        } else {
            left_flap = UtilAngles.pivotPixelsRotX((float)94.4596f, (float)36.7061f, (float)-0.8385f, (float)(entity.inputs.roll * -22.0f));
            right_flap = UtilAngles.pivotPixelsRotX((float)-94.4596f, (float)36.7061f, (float)-0.8385f, (float)(entity.inputs.roll * 22.0f));
        }
        QuaternionF stickRot = Vec3f.XP.rotationDegrees(entity.inputs.pitch * -25.0f);
        stickRot.mul(Vec3f.ZP.rotationDegrees(entity.inputs.roll * 25.0f));
        Mat4f stick = UtilAngles.pivotPixelsRot((float)0.0f, (float)33.8882f, (float)4.717f, (QuaternionF)stickRot);
        Mat4f throttle = Mat4f.createTranslateMatrix((float)0.0f, (float)0.0f, (float)(entity.getCurrentThrottle() * 0.125f));
        Mat4f left_pedal = Mat4f.createTranslateMatrix((float)0.0f, (float)0.0f, (float)(entity.inputs.yaw * -0.0625f));
        Mat4f right_pedal = Mat4f.createTranslateMatrix((float)0.0f, (float)0.0f, (float)(entity.inputs.yaw * 0.0625f));
        transforms.put("lg0", lg0_mat);
        transforms.put("lg1", lg1_mat);
        transforms.put("lg2", lg2_mat);
        transforms.put("blade0", blade0_mat);
        transforms.put("surface0", rudder);
        transforms.put("surface1", left_flap);
        transforms.put("surface2", right_flap);
        transforms.put("surface3", left_elevator);
        transforms.put("surface4", right_elevator);
        transforms.put("stick", stick);
        transforms.put("throttle", throttle);
        transforms.put("pedal0", left_pedal);
        transforms.put("pedal1", right_pedal);
    }

    public Vec3f getGlobalPivot() {
        return PIVOT;
    }
}

