/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay;

import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.util.UtilPrint;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class WindTunnelOverlay
extends class_332 {
    static final long CHECK_TUNNEL_RATE = 2000L;
    static long prevTunnelCheckTime = System.currentTimeMillis();
    static final int VALUE_OFFSET = 50;
    static final int LABEL_PADDING = 2;
    @Nullable
    static EntityWindTunnel tunnel;

    static void render(class_329 gui, class_4587 stack, float partialTick, int screenWidth, int screenHeight) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (!player.method_5687(2)) {
            return;
        }
        if (System.currentTimeMillis() - prevTunnelCheckTime >= 2000L) {
            WindTunnelOverlay.findTunnel(player.method_19538(), UtilEntity.getLevel((class_1297)player));
        }
        if (tunnel == null) {
            return;
        }
        int index = 0;
        gui.method_1756().method_1729(stack, tunnel.getStatsId(), 2.0f, 2.0f, 65280);
        gui.method_1756().method_1729(stack, "Speed", 2.0f, (float)(2 + 10 * ++index), 65535);
        gui.method_1756().method_1729(stack, UtilPrint.printVec3SigFig(tunnel.getSpeed()), 50.0f, (float)(2 + 10 * index), 65535);
        gui.method_1756().method_1729(stack, "Total", 2.0f, (float)(2 + 10 * ++index), 0xFFFFFF);
        gui.method_1756().method_1729(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.totalAcc), 50.0f, (float)(2 + 10 * index), 0xFFFFFF);
        gui.method_1756().method_1729(stack, "Thrust", 2.0f, (float)(2 + 10 * ++index), 255);
        gui.method_1756().method_1729(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.thrustAcc), 50.0f, (float)(2 + 10 * index), 255);
        gui.method_1756().method_1729(stack, "Drag", 2.0f, (float)(2 + 10 * ++index), 0xFF0000);
        gui.method_1756().method_1729(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.dragAcc), 50.0f, (float)(2 + 10 * index), 0xFF0000);
        gui.method_1756().method_1729(stack, "Lift", 2.0f, (float)(2 + 10 * ++index), 65280);
        gui.method_1756().method_1729(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.liftAcc), 50.0f, (float)(2 + 10 * index), 65280);
        gui.method_1756().method_1729(stack, "Weight", 2.0f, (float)(2 + 10 * ++index), 0);
        gui.method_1756().method_1729(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.weightAcc), 50.0f, (float)(2 + 10 * index), 0);
        gui.method_1756().method_1729(stack, "RotAcc", 2.0f, (float)(2 + 10 * ++index), 255);
        gui.method_1756().method_1729(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.rotAcc), 50.0f, (float)(2 + 10 * index), 255);
        gui.method_1756().method_1729(stack, "AOA", 2.0f, (float)(2 + 10 * ++index), 0xFF00FF);
        StringBuilder aoaStr = new StringBuilder();
        for (Float aoa : WindTunnelOverlay.tunnel.aoas) {
            aoaStr.append(UtilPrint.printDec(aoa.floatValue())).append(" ");
        }
        gui.method_1756().method_1729(stack, aoaStr.toString(), 50.0f, (float)(2 + 10 * index), 0xFF00FF);
        int color = 65280;
        if (WindTunnelOverlay.tunnel.windCompAcc < 0.0) {
            color = 0xFF0000;
        }
        gui.method_1756().method_1729(stack, "WCA", 2.0f, (float)(2 + 10 * ++index), color);
        gui.method_1756().method_1729(stack, UtilPrint.printSigFig(WindTunnelOverlay.tunnel.windCompAcc), 50.0f, (float)(2 + 10 * index), color);
        double Ny = WindTunnelOverlay.tunnel.centripetalAcc / 0.024525;
        gui.method_1756().method_1729(stack, "Ny", 2.0f, (float)(2 + 10 * ++index), 0xFFFF00);
        gui.method_1756().method_1729(stack, UtilPrint.printSigFig(Ny), 50.0f, (float)(2 + 10 * index), 0xFFFF00);
        gui.method_1756().method_1729(stack, "YawRate", 2.0f, (float)(2 + 10 * ++index), 0xFF00FF);
        gui.method_1756().method_1729(stack, UtilPrint.printDec(WindTunnelOverlay.tunnel.yawRate * 20.0), 50.0f, (float)(2 + 10 * index), 0xFF00FF);
        gui.method_1756().method_1729(stack, "TurnRad", 2.0f, (float)(2 + 10 * ++index), 65535);
        gui.method_1756().method_1729(stack, UtilPrint.printDec(WindTunnelOverlay.tunnel.turnRadius), 50.0f, (float)(2 + 10 * index), 65535);
    }

    static void findTunnel(class_243 pos, class_1937 level) {
        Optional<EntityWindTunnel> opt = UtilVehicleEntity.findWindTunnel(pos, level);
        tunnel = opt.orElse(null);
        prevTunnelCheckTime = System.currentTimeMillis();
    }
}

