/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.ActionInput;
import com.onewhohears.dscombat.client.input.ActionInputHolder;
import com.onewhohears.dscombat.client.input.ClientInputManager;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilMCText;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class KeyBindsOverlay
extends VehicleOverlayComponent {
    private static final int DEFAULT_KEY_COLOR = 65280;
    private static final int USE_KEY_COLOR = 0xFFFF00;
    private static final int MAPPING_NAME_WIDTH = 80;
    private static final int KEY_NAME_WIDTH = 40;

    public static class_2561 fixKeyName(ActionInputHolder.Button key) {
        if (((ActionInput.Button)key.getPrimaryAction()).isKeyBind()) {
            class_304 map = DSCKeys.getKey(((ActionInput.Button)key.getPrimaryAction()).getId());
            if (map == null) {
                return UtilMCText.literal((String)((ActionInput.Button)key.getPrimaryAction()).getId());
            }
            return switch (map.field_1655.method_1444()) {
                case 345 -> UtilMCText.literal((String)"R-CTRL");
                case 341 -> UtilMCText.literal((String)"L-CTRL");
                case 342 -> UtilMCText.literal((String)"L-ALT");
                case 346 -> UtilMCText.literal((String)"R-ALT");
                case 340 -> UtilMCText.literal((String)"LSHIFT");
                case 344 -> UtilMCText.literal((String)"RSHIFT");
                default -> map.field_1655.method_27445();
            };
        }
        return key.getName();
    }

    protected void displayMapping(class_4587 poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, class_2561 mapName, boolean isUsed, String setting) {
        int pY = 2 + 10 * index;
        int pX = 3;
        int pColor = 65280;
        if (isUsed) {
            pColor = 0xFFFF00;
        }
        KeyBindsOverlay.method_27535((class_4587)poseStack, (class_327)FONT, (class_2561)mapName, (int)pX, (int)pY, (int)pColor);
        KeyBindsOverlay.method_27535((class_4587)poseStack, (class_327)FONT, (class_2561)KeyBindsOverlay.fixKeyName(key), (int)(pX += 80), (int)pY, (int)pColor);
        if (setting == null || setting.isEmpty()) {
            return;
        }
        KeyBindsOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)setting, (int)(pX += 40), (int)pY, (int)pColor);
    }

    protected void displayMapping(class_4587 poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, boolean isUsed, String setting) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, key.getName(), isUsed, setting);
    }

    protected void displayMapping(class_4587 poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, boolean isUsed) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, key.getName(), isUsed, null);
    }

    protected void displayMapping(class_4587 poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, key.isPressed(), null);
    }

    protected void displayMapping(class_4587 poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, String setting) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, key.isPressed(), setting);
    }

    protected void displayMapping(class_4587 poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, class_2561 mapName, boolean isUsed) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, mapName, isUsed, null);
    }

    protected void displayMapping(class_4587 poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, class_2561 mapName) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, mapName, key.isPressed(), null);
    }

    @Override
    protected boolean shouldRender(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (KeyBindsOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        class_1297 class_12972 = KeyBindsOverlay.getPlayerVehicle();
        if (!(class_12972 instanceof EntityRidablePart)) {
            return false;
        }
        EntityRidablePart seat = (EntityRidablePart)class_12972;
        EntityVehicle vehicle = seat.getParentVehicle();
        return vehicle != null;
    }

    @Override
    protected void render(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityRidablePart seat = (EntityRidablePart)KeyBindsOverlay.getPlayerVehicle();
        assert (seat != null);
        EntityVehicle vehicle = seat.getParentVehicle();
        assert (vehicle != null);
        boolean isPilot = seat.isPilotSeat();
        boolean isCoPilot = seat.isCoPilotSeat();
        int index = 0;
        if (isPilot) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.MOUSE_MODE, !DSCClientInputs.getMouseMode().isLockedForward(), DSCClientInputs.getMouseMode().name());
        }
        this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.VEHICLE_MENU);
        if (((Boolean)Config.CLIENT.customDismount.get()).booleanValue()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.DISMOUNT);
        }
        if (seat.canEject()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.EJECT);
        }
        this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.CHANGE_SEAT);
        if (isPilot && vehicle.canToggleLandingGear()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.LANDING_GEAR, vehicle.isLandingGear(), vehicle.isLandingGear() ? "OUT" : "IN");
        }
        if (isPilot && vehicle.canGroundBrake()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ((VehicleStats)vehicle.getStats()).isPlane() ? ClientInputManager.SPECIAL2 : ClientInputManager.SPECIAL1, (class_2561)UtilMCText.translatable((String)"info.dscombat.breaks"), vehicle.isGroundBraking());
        }
        if (isPilot && vehicle.canAirBrake()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ((VehicleStats)vehicle.getStats()).isPlane() ? ClientInputManager.SPECIAL2 : ClientInputManager.SPECIAL1, (class_2561)UtilMCText.translatable((String)"info.dscombat.breaks"), vehicle.isAirBreaking());
        }
        if (isPilot && vehicle.canFlapsDown()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.SPECIAL1, (class_2561)UtilMCText.translatable((String)"info.dscombat.flaps_down"));
        }
        if (isPilot && vehicle.canAngleWeaponDown()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.SPECIAL2, (class_2561)UtilMCText.translatable((String)"info.dscombat.nose_down"));
        }
        if (isPilot && vehicle.canHover()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.SPECIAL1, (class_2561)UtilMCText.translatable((String)"info.dscombat.hover"));
        }
        if (isPilot && vehicle.hasFlares()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.FLARE, "" + vehicle.getFlareNum());
        }
        if (isPilot || isCoPilot) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.WEAPON_CYCLE);
        }
        if (vehicle.radarSystem.hasRadar()) {
            boolean warning = DSCClientInputs.getPreferredRadarMode() != vehicle.getRadarMode();
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.RADAR_MODE, warning, DSCClientInputs.getPreferredRadarMode().name());
        }
        if (vehicle.radarSystem.hasRadar()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.PING_CYCLE);
        }
        if (vehicle.getGimbalForPilotCamera() != null || seat.getCameraYOffset() != 0.0f) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.GIMBAL, DSCClientInputs.isGimbalMode(), DSCClientInputs.isGimbalMode() ? "ON" : "OFF");
        }
        if (vehicle.canUseAfterburner()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.AFTERBURNER, DSCClientInputs.isAfterBurner(), DSCClientInputs.isAfterBurner() ? "ON" : "OFF");
        }
        if (vehicle.canUseTurnAssist()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.TURN_ASSIST, DSCClientInputs.isTurnAssist(), DSCClientInputs.isTurnAssist() ? "ON" : "OFF");
        }
        if (vehicle.radarSystem.hasRadar()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.CAMERA_TRACK_TARGET, DSCClientInputs.isCameraTrackTarget(), DSCClientInputs.isCameraTrackTarget() ? "ON" : "OFF");
        }
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_key_binds";
    }
}

