/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.dscombat.client.overlay.HudLayoutManager;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.client.screen.HudLayoutEditScreen;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityHelicopter;
import com.onewhohears.dscombat.entity.vehicle.EntityPlane;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import java.awt.Color;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class ModernHudOverlay
extends VehicleOverlayComponent {
    private static boolean lastF7 = false;
    private static boolean lastF8 = false;
    private static int hudMode = 0;
    private static int hintsMode = 1;
    private static boolean lastF6 = false;
    private static boolean editMode = false;
    private static String draggingId = null;
    private static boolean resizing = false;
    private static double dragDX = 0.0;
    private static double dragDY = 0.0;
    private static final double RESIZE_HANDLE = 14.0;

    private int argb(float a, int r, int g, int b) {
        int ai = (int)(a * 255.0f) & 0xFF;
        return ai << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    private String vehicleTypeId(EntityVehicle v) {
        if (v instanceof EntityHelicopter) {
            return "HELICOPTER";
        }
        if (v instanceof EntityPlane) {
            return "PLANE";
        }
        if (((VehicleStats)v.getStats()).isBoat()) {
            return "BOAT";
        }
        if (((VehicleStats)v.getStats()).getType() == VehicleType.CAR) {
            if (((VehicleStats)v.getStats()).asCar().isTank()) {
                return "TANK";
            }
            return "CAR";
        }
        return "GENERIC";
    }

    private HudLayoutManager.Rect getRect(EntityVehicle v, String id, int px, int py, int pw, int ph, int sw, int sh) {
        String vt = this.vehicleTypeId(v);
        HudLayoutManager.Rect fb = new HudLayoutManager.Rect((double)px / (double)sw, (double)py / (double)sh, (double)pw / (double)sw, (double)ph / (double)sh);
        return HudLayoutManager.get(vt, id, fb);
    }

    private void setRect(EntityVehicle v, String id, HudLayoutManager.Rect r) {
        HudLayoutManager.set(this.vehicleTypeId(v), id, r);
    }

    private void drawEditHandle(class_4587 ps, int x, int y, int w, int h, String label, int text) {
        int border = 1;
        ModernHudOverlay.method_25294((class_4587)ps, (int)(x - border), (int)(y - border), (int)(x + w + border), (int)(y + h + border), (int)this.withAlpha(new Color(255, 255, 255).getRGB(), 0.12f));
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)label, (int)(x + 2), (int)(y - 10), (int)text);
        ModernHudOverlay.method_25294((class_4587)ps, (int)(x + w - 8), (int)(y + h - 2), (int)(x + w + 2), (int)(y + h + 2), (int)this.withAlpha(new Color(255, 255, 255).getRGB(), 0.3f));
    }

    private void handleDragging(EntityVehicle v, int sw, int sh) {
        class_310 mc = class_310.method_1551();
        double mxWin = mc.field_1729.method_1603();
        double myWin = mc.field_1729.method_1604();
        double mxGui = mxWin * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
        double myGui = myWin * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
        float scale = ((Double)Config.CLIENT.modernHudScale.get()).floatValue();
        double mx = mxGui / (double)scale;
        double my = myGui / (double)scale;
        boolean left = mc.field_1729.method_1608();
        if (draggingId == null && left) {
            this.selectIfInside(v, "att", mx, my, sw, sh);
            this.selectIfInside(v, "head", mx, my, sw, sh);
            this.selectIfInside(v, "br", mx, my, sw, sh);
            this.selectIfInside(v, "bl", mx, my, sw, sh);
        }
        if (draggingId != null && left) {
            HudLayoutManager.Rect r = HudLayoutManager.get(this.vehicleTypeId(v), draggingId, new HudLayoutManager.Rect(0.0, 0.0, 0.3, 0.2));
            if (resizing) {
                r.w = this.clamp01(mx / (double)sw - r.x);
                r.h = this.clamp01(my / (double)sh - r.y);
            } else {
                r.x = this.clamp01(mx / (double)sw - dragDX);
                r.y = this.clamp01(my / (double)sh - dragDY);
            }
            this.setRect(v, draggingId, r);
        }
        if (!left) {
            draggingId = null;
        }
    }

    private void selectIfInside(EntityVehicle v, String id, double mx, double my, int sw, int sh) {
        HudLayoutManager.Rect r = HudLayoutManager.get(this.vehicleTypeId(v), id, new HudLayoutManager.Rect(0.4, 0.4, 0.2, 0.1));
        double x = r.x * (double)sw;
        double y = r.y * (double)sh;
        double w = r.w * (double)sw;
        double h = r.h * (double)sh;
        if (mx >= x && mx <= x + w && my >= y && my <= y + h) {
            draggingId = id;
            resizing = mx >= x + w - 14.0 && my >= y + h - 14.0;
            dragDX = (mx - x) / (double)sw;
            dragDY = (my - y) / (double)sh;
        }
    }

    private double clamp01(double v) {
        return v < 0.0 ? 0.0 : (v > 1.0 ? 1.0 : v);
    }

    private void drawHintsCompact(class_4587 ps, int sw, int sh, int text) {
        String s = "[Space] Hover  [K] Gear  [V] Flares  [O] Radar  [F8] Hints  [F7] HUD";
        int y = sh - 14;
        ModernHudOverlay.method_25300((class_4587)ps, (class_327)FONT, (String)s, (int)(sw / 2), (int)y, (int)text);
    }

    private void drawHintsFull(class_4587 ps, int sw, int sh, int text) {
        int x = 8;
        int y = 8;
        int w = 220;
        int h = sh - 16;
        ModernHudOverlay.method_25294((class_4587)ps, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)this.withAlpha(new Color(20, 20, 20).getRGB(), 0.85f));
        int yy = y + 8;
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Controls (F8 to hide)", (int)(x + 8), (int)yy, (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Hover: Space", (int)(x + 8), (int)(yy += 12), (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Gear: K", (int)(x + 8), (int)(yy += 10), (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Flares: V", (int)(x + 8), (int)(yy += 10), (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Radar Mode: O", (int)(x + 8), (int)(yy += 10), (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Track Target: RSHIFT", (int)(x + 8), (int)(yy += 10), (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Gimbal: ;", (int)(x + 8), (int)(yy += 10), (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Throttle: Up/Down", (int)(x + 8), (int)(yy += 10), (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Yaw: A/D", (int)(x + 8), (int)(yy += 10), (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Roll: Left/Right", (int)(x + 8), (int)(yy += 10), (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"Pitch: W/S", (int)(x + 8), (int)(yy += 10), (int)text);
        ModernHudOverlay.method_25303((class_4587)ps, (class_327)FONT, (String)"HUD Mode: F7", (int)(x + 8), (int)(yy += 10), (int)text);
        yy += 10;
    }

    private int withAlpha(int rgb, float a) {
        int ai = (int)(a * 255.0f) & 0xFF;
        return ai << 24 | rgb & 0xFFFFFF;
    }

    private static String speedUnitLabel() {
        String u;
        return switch (u = (String)Config.CLIENT.hudSpeedUnit.get()) {
            case "kph" -> "km/h";
            case "knots" -> "kt";
            default -> "m/s";
        };
    }

    private static double speedConverted(double mps) {
        String u;
        return switch (u = (String)Config.CLIENT.hudSpeedUnit.get()) {
            case "kph" -> mps * 3.6;
            case "knots" -> mps * 1.943844492;
            default -> mps;
        };
    }

    private static String altUnitLabel() {
        String u = (String)Config.CLIENT.hudAltUnit.get();
        return u.equals("ft") ? "ft" : "m";
    }

    private static double altConverted(double meters) {
        String u = (String)Config.CLIENT.hudAltUnit.get();
        return u.equals("ft") ? meters * 3.280839895 : meters;
    }

    @Override
    protected boolean shouldRender(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (ModernHudOverlay.defaultRenderConditions()) {
            return false;
        }
        if (!((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        return ModernHudOverlay.getPlayerRootVehicle() instanceof EntityVehicle;
    }

    @Override
    protected void render(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        this.updateToggles();
        float scale = ((Double)Config.CLIENT.modernHudScale.get()).floatValue();
        float alpha = ((Double)Config.CLIENT.modernHudOpacity.get()).floatValue();
        poseStack.method_22903();
        poseStack.method_22905(scale, scale, 1.0f);
        int sw = (int)((float)screenWidth / scale);
        int sh = (int)((float)screenHeight / scale);
        EntityVehicle v = (EntityVehicle)ModernHudOverlay.getPlayerRootVehicle();
        assert (v != null);
        boolean isHeli = v instanceof EntityHelicopter;
        boolean isPlane = v instanceof EntityPlane;
        boolean showAllHold = DSCKeys.hudShowAllKey != null && DSCKeys.hudShowAllKey.method_1434();
        int localHudMode = showAllHold ? 1 : hudMode;
        int localHintsMode = showAllHold ? 2 : hintsMode;
        int panel = this.withAlpha(new Color(24, 24, 24).getRGB(), alpha);
        int text = new Color(220, 255, 220).getRGB();
        int accent = new Color(88, 220, 88).getRGB();
        int warn = new Color(255, 170, 0).getRGB();
        int danger = new Color(255, 80, 80).getRGB();
        int defAttW = localHudMode == 0 ? 150 : 180;
        int defAttH = localHudMode == 0 ? 90 : 110;
        int defAttX = sw / 2 - defAttW / 2;
        int defAttY = sh / 2 - defAttH / 2 + 12;
        HudLayoutManager.Rect attR = this.getRect(v, "att", defAttX, defAttY, defAttW, defAttH, sw, sh);
        int attX = (int)Math.round(attR.x * (double)sw);
        int attY = (int)Math.round(attR.y * (double)sh);
        int attW = (int)Math.round(attR.w * (double)sw);
        int attH = (int)Math.round(attR.h * (double)sh);
        if (localHudMode == 1) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)attX, (int)attY, (int)(attX + attW), (int)(attY + attH), (int)this.withAlpha(new Color(16, 16, 16).getRGB(), alpha * 0.6f));
        }
        int defHrW = localHudMode == 0 ? 180 : 220;
        int hrH = 18;
        int defHrX = sw / 2 - defHrW / 2;
        int defHrY = attY - hrH - 4;
        HudLayoutManager.Rect headR = this.getRect(v, "head", defHrX, defHrY, defHrW, hrH, sw, sh);
        int hrX = (int)Math.round(headR.x * (double)sw);
        int hrY = (int)Math.round(headR.y * (double)sh);
        int hrW = (int)Math.round(headR.w * (double)sw);
        if (localHudMode == 1) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)hrX, (int)hrY, (int)(hrX + hrW), (int)(hrY + hrH), (int)this.withAlpha(new Color(16, 16, 16).getRGB(), alpha * 0.6f));
        }
        this.drawHeadingRibbon(poseStack, v, hrX, hrY, hrW, hrH, text, accent);
        this.drawAttitude(poseStack, v, attX, attY, attW, attH, text, accent);
        if (isPlane) {
            try {
                double aoa = ((EntityPlane)v).getAOA();
                ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("AOA %3.1f", aoa), (int)(attX + attW + 6), (int)(attY + attH / 2 - 4), (int)text);
            }
            catch (Throwable aoa) {
                // empty catch block
            }
        }
        int defPrW = 190;
        int defPrH = 96;
        int defPrX = sw - defPrW - 1 - 6;
        int defPrY = sh - defPrH - 1 - 4;
        HudLayoutManager.Rect brR = this.getRect(v, "br", defPrX, defPrY, defPrW, defPrH, sw, sh);
        int prX = (int)Math.round(brR.x * (double)sw);
        int prY = (int)Math.round(brR.y * (double)sh);
        int prW = (int)Math.round(brR.w * (double)sw);
        int prH = (int)Math.round(brR.h * (double)sh);
        if (localHudMode == 1) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)prX, (int)prY, (int)(prX + prW), (int)(prY + prH), (int)panel);
        }
        float throttleGoal = v.inputs.getGoalThrottle(v);
        float throttlePct = ((VehicleStats)v.getStats()).negativeThrottle ? (throttleGoal + 1.0f) / 2.0f : throttleGoal;
        int barX = prX + 10;
        int barY = prY + 10;
        int barW = 14;
        int barH = prH - 20;
        if (localHudMode == 1) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)barX, (int)barY, (int)(barX + barW), (int)(barY + barH), (int)this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
        }
        int fillH = (int)((float)barH * Math.max(0.0f, Math.min(1.0f, throttlePct)));
        if (localHudMode == 1) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)barX, (int)(barY + (barH - fillH)), (int)(barX + barW), (int)(barY + barH), (int)this.withAlpha(accent, alpha));
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)"THR", (int)(barX - 2), (int)(prY + prH - 12), (int)text);
        }
        double rpmPct = 0.0;
        if (isHeli) {
            EntityHelicopter heli = (EntityHelicopter)v;
            rpmPct = Math.max(0.0, Math.min(1.0, heli.getRotorPower()));
        }
        int rbX = barX + barW + 16;
        int rbY = barY;
        int rbW = barW;
        int rbH = barH;
        if (localHudMode == 1 && isHeli) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)rbX, (int)rbY, (int)(rbX + rbW), (int)(rbY + rbH), (int)this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
        }
        int rpmFill = (int)((double)rbH * rpmPct);
        if (localHudMode == 1 && isHeli) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)rbX, (int)(rbY + (rbH - rpmFill)), (int)(rbX + rbW), (int)(rbY + rbH), (int)this.withAlpha(warn, alpha));
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)"RPM", (int)(rbX - 2), (int)(prY + prH - 12), (int)text);
        }
        double speed = ModernHudOverlay.speedConverted(v.method_18798().method_1033() * 20.0);
        double climb = ModernHudOverlay.speedConverted(v.method_18798().field_1351 * 20.0);
        int metricsX = rbX + rbW + 12;
        int metricsY = barY + (localHudMode == 0 ? -8 : 0);
        ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("spd  %4.1f %s", speed, ModernHudOverlay.speedUnitLabel()), (int)metricsX, (int)metricsY, (int)text);
        if (localHudMode == 1) {
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("clb  %4.1f %s", climb, ModernHudOverlay.speedUnitLabel()), (int)metricsX, (int)(metricsY + 10), (int)(climb >= 0.0 ? text : warn));
        }
        ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("hdg  %3.0f\u00b0", Float.valueOf((v.method_36454() + 360.0f) % 360.0f)), (int)metricsX, (int)(metricsY + (localHudMode == 1 ? 20 : 10)), (int)text);
        float fuelPct = 0.0f;
        try {
            fuelPct = Math.max(0.0f, Math.min(1.0f, v.getCurrentFuel() / Math.max(1.0f, v.getMaxFuel())));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int barsX = metricsX;
        int barsY = metricsY + (hudMode == 1 ? 36 : 22);
        int bw = 120;
        int bh = 6;
        if (localHudMode == 1) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)barsX, (int)barsY, (int)(barsX + bw), (int)(barsY + bh), (int)this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)barsX, (int)barsY, (int)(barsX + (int)((float)bw * fuelPct)), (int)(barsY + bh), (int)this.withAlpha(new Color(0, 180, 255).getRGB(), alpha));
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("fuel %3.0f%%", Float.valueOf(fuelPct * 100.0f)), (int)(barsX + bw + 6), (int)(barsY - 1), (int)text);
        }
        barsY += bh + 4;
        float hp = v.getHealth();
        float hpMax = v.getMaxHealth();
        float hpPct = Math.max(0.0f, Math.min(1.0f, hpMax <= 0.0f ? 0.0f : hp / hpMax));
        if (localHudMode == 1) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)barsX, (int)barsY, (int)(barsX + bw), (int)(barsY + bh), (int)this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)barsX, (int)barsY, (int)(barsX + (int)((float)bw * hpPct)), (int)(barsY + bh), (int)this.withAlpha(new Color(80, 220, 80).getRGB(), alpha));
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("hp %3.0f%%", Float.valueOf(hpPct * 100.0f)), (int)(barsX + bw + 6), (int)(barsY - 1), (int)text);
        }
        barsY += bh + 4;
        float ar = v.getArmor();
        float arMax = v.getMaxTotalArmor();
        float arPct = Math.max(0.0f, Math.min(1.0f, arMax <= 0.0f ? 0.0f : ar / arMax));
        if (localHudMode == 1) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)barsX, (int)barsY, (int)(barsX + bw), (int)(barsY + bh), (int)this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)barsX, (int)barsY, (int)(barsX + (int)((float)bw * arPct)), (int)(barsY + bh), (int)this.withAlpha(new Color(180, 180, 60).getRGB(), alpha));
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("arm %3.0f%%", Float.valueOf(arPct * 100.0f)), (int)(barsX + bw + 6), (int)(barsY - 1), (int)text);
        }
        int plX = 7;
        int defPlW = localHudMode == 0 ? 180 : 220;
        int defPlH = localHudMode == 0 ? 82 : 110;
        int defPlY = sh - defPlH - 1;
        HudLayoutManager.Rect blR = this.getRect(v, "bl", plX, defPlY, defPlW, defPlH, sw, sh);
        int plY = (int)Math.round(blR.y * (double)sh);
        int plW = (int)Math.round(blR.w * (double)sw);
        int plH = (int)Math.round(blR.h * (double)sh);
        plX = (int)Math.round(blR.x * (double)sw);
        ModernHudOverlay.method_25294((class_4587)poseStack, (int)plX, (int)plY, (int)(plX + plW), (int)(plY + plH), (int)this.withAlpha(new Color(24, 24, 24).getRGB(), alpha * (localHudMode == 0 ? 0.5f : 0.85f)));
        int tapeX = plX + 10;
        int tapeY = plY + 10;
        int tapeW = 14;
        int tapeH = plH - 20;
        ModernHudOverlay.method_25294((class_4587)poseStack, (int)tapeX, (int)tapeY, (int)(tapeX + tapeW), (int)(tapeY + tapeH), (int)this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
        double alt = ModernHudOverlay.altConverted(v.getAltitude());
        ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("alt %4.0f %s", alt, ModernHudOverlay.altUnitLabel()), (int)(tapeX + tapeW + 8), (int)tapeY, (int)text);
        int pty = tapeY + tapeH / 2;
        ModernHudOverlay.method_25294((class_4587)poseStack, (int)(tapeX + tapeW + 2), (int)(pty - 1), (int)(tapeX + tapeW + 10), (int)(pty + 1), (int)this.withAlpha(accent, alpha));
        int chipY = plY + (hudMode == 0 ? 28 : 34);
        int chipH = 14;
        int chipW = 50;
        float chipAlpha = alpha;
        if (isHeli) {
            boolean ige = false;
            double hMax = (Double)Config.SERVER.groundEffectMaxHeight.get();
            if (((Boolean)Config.SERVER.enableGroundEffect.get()).booleanValue() && hMax > 0.0) {
                int limit = (int)Math.ceil(hMax) + 1;
                int aglBlocks = UtilVehicleEntity.getDistFromGround((class_1297)v, limit, true);
                ige = (double)aglBlocks < hMax;
            }
            int c1 = this.withAlpha(new Color(ige ? 88 : 60, ige ? 220 : 60, 88).getRGB(), chipAlpha);
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)(plX + 10), (int)chipY, (int)(plX + 10 + chipW), (int)(chipY + chipH), (int)c1);
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)"IGE", (int)(plX + 12), (int)(chipY + 3), (int)Color.BLACK.getRGB());
            double speedXZ = v.method_18798().method_37267();
            double full = Math.max(1.0E-6, (Double)Config.SERVER.translationalLiftFullSpeed.get());
            double etlFactor = Math.min(1.0, speedXZ / full);
            boolean etl = (Boolean)Config.SERVER.enableTranslationalLift.get() != false && etlFactor > 0.05;
            int c2 = this.withAlpha(new Color(etl ? 220 : 60, etl ? 180 : 60, 88).getRGB(), chipAlpha);
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)(plX + 10 + chipW + 6), (int)chipY, (int)(plX + 10 + chipW * 2 + 6), (int)(chipY + chipH), (int)c2);
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)"ETL", (int)(plX + 12 + chipW + 6), (int)(chipY + 3), (int)Color.BLACK.getRGB());
            double vy = v.method_18798().field_1351;
            double descent = vy < 0.0 ? -vy : 0.0;
            double trig = (Double)Config.SERVER.vrsDescentTrigger.get();
            double cap = (Double)Config.SERVER.vrsHorizMaxSpeed.get();
            boolean vrs = (Boolean)Config.SERVER.enableVRS.get() != false && descent > trig && speedXZ < cap;
            int c3 = this.withAlpha(new Color(vrs ? 220 : 60, 88, 88).getRGB(), chipAlpha);
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)(plX + 10 + (chipW + 6) * 2), (int)chipY, (int)(plX + 10 + (chipW + 6) * 3), (int)(chipY + chipH), (int)c3);
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)"VRS", (int)(plX + 12 + (chipW + 6) * 2), (int)(chipY + 3), (int)Color.BLACK.getRGB());
        } else if (isPlane) {
            boolean gearOut = v.canToggleLandingGear() && v.isLandingGear();
            int cg = this.withAlpha(new Color(gearOut ? 88 : 60, gearOut ? 220 : 60, 88).getRGB(), chipAlpha);
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)(plX + 10), (int)chipY, (int)(plX + 10 + chipW), (int)(chipY + chipH), (int)cg);
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)"GEAR", (int)(plX + 12), (int)(chipY + 3), (int)Color.BLACK.getRGB());
            boolean flaps = v.isFlapsDown();
            int cf = this.withAlpha(new Color(flaps ? 220 : 60, flaps ? 180 : 60, 88).getRGB(), chipAlpha);
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)(plX + 10 + chipW + 6), (int)chipY, (int)(plX + 10 + chipW * 2 + 6), (int)(chipY + chipH), (int)cf);
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)"FLAPS", (int)(plX + 12 + chipW + 6), (int)(chipY + 3), (int)Color.BLACK.getRGB());
        }
        int stW = 54;
        int stH = 90;
        int stX = attX - stW - 8;
        int stY = attY + (attH - stH) / 2;
        if (localHudMode == 1) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)stX, (int)stY, (int)(stX + stW), (int)(stY + stH), (int)this.withAlpha(new Color(16, 16, 16).getRGB(), alpha * 0.6f));
        }
        double spd = ModernHudOverlay.speedConverted(v.method_18798().method_1033() * 20.0);
        if (localHudMode == 1) {
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("%4.1f %s", spd, ModernHudOverlay.speedUnitLabel()), (int)(stX + 4), (int)(stY + stH / 2 - 4), (int)text);
        }
        int atW = 54;
        int atH = 90;
        int atX = attX + attW + 8;
        int atY = attY + (attH - atH) / 2;
        if (localHudMode == 1) {
            ModernHudOverlay.method_25294((class_4587)poseStack, (int)atX, (int)atY, (int)(atX + atW), (int)(atY + atH), (int)this.withAlpha(new Color(16, 16, 16).getRGB(), alpha * 0.6f));
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("%4.0f %s", alt, ModernHudOverlay.altUnitLabel()), (int)(atX + 4), (int)(atY + atH / 2 - 4), (int)text);
        }
        if (localHudMode == 0) {
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("%4.1f %s", speed, ModernHudOverlay.speedUnitLabel()), (int)12, (int)12, (int)text);
            ModernHudOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)String.format("%4.0f %s", alt, ModernHudOverlay.altUnitLabel()), (int)(sw - 90), (int)12, (int)text);
        }
        if (localHintsMode == 2) {
            this.drawHintsFull(poseStack, sw, sh, text);
        } else if (localHintsMode == 1) {
            this.drawHintsCompact(poseStack, sw, sh, text);
        }
        if (editMode) {
            this.drawEditHandle(poseStack, attX, attY, attW, attH, "att", text);
            this.drawEditHandle(poseStack, hrX, hrY, hrW, hrH, "head", text);
            this.drawEditHandle(poseStack, prX, prY, prW, prH, "br", text);
            this.drawEditHandle(poseStack, plX, plY, plW, plH, "bl", text);
            this.handleDragging(v, sw, sh);
        }
        poseStack.method_22909();
    }

    private void updateToggles() {
        class_310 mc;
        boolean f6;
        boolean f7 = DSCKeys.hudModeToggleKey != null && DSCKeys.hudModeToggleKey.method_1434();
        boolean f8 = DSCKeys.hudHintsToggleKey != null && DSCKeys.hudHintsToggleKey.method_1434();
        boolean bl = f6 = DSCKeys.hudLayoutEditKey != null && DSCKeys.hudLayoutEditKey.method_1434();
        if (f7 && !lastF7) {
            hudMode = (hudMode + 1) % 2;
        }
        if (f8 && !lastF8) {
            hintsMode = (hintsMode + 1) % 3;
        }
        if (f6 && !lastF6) {
            mc = class_310.method_1551();
            class_437 class_4372 = mc.field_1755;
            if (class_4372 instanceof HudLayoutEditScreen) {
                HudLayoutEditScreen s = (HudLayoutEditScreen)class_4372;
                s.closeAndSave();
            } else {
                mc.method_1507((class_437)new HudLayoutEditScreen(() -> HudLayoutManager.save()));
            }
        }
        lastF7 = f7;
        lastF8 = f8;
        lastF6 = f6;
        mc = class_310.method_1551();
        editMode = mc.field_1755 instanceof HudLayoutEditScreen;
    }

    private void drawHeadingRibbon(class_4587 ps, EntityVehicle v, int x, int y, int w, int h, int text, int accent) {
        double hdg = ((double)v.method_36454() + 360.0) % 360.0;
        ModernHudOverlay.method_25294((class_4587)ps, (int)(x + w / 2 - 1), (int)y, (int)(x + w / 2 + 1), (int)(y + h), (int)accent);
        double pxPerDeg = 4.0;
        int spanDeg = (int)((double)w / pxPerDeg);
        int start = (int)(hdg - (double)(spanDeg / 2));
        for (int deg = start - start % 10; deg <= start + spanDeg; deg += 10) {
            int d = (int)Math.floor(((double)deg - hdg) * pxPerDeg) + w / 2;
            if (d < 0 || d > w) continue;
            int vlen = deg % 30 == 0 ? h - 4 : h - 8;
            ModernHudOverlay.method_25294((class_4587)ps, (int)(x + d), (int)(y + 2), (int)(x + d + 1), (int)(y + vlen), (int)this.withAlpha(text, 0.5f));
            if (deg % 30 != 0) continue;
            int label = (deg % 360 + 360) % 360;
            String s = Integer.toString(label);
            ModernHudOverlay.method_25300((class_4587)ps, (class_327)FONT, (String)s, (int)(x + d), (int)(y + h - 12), (int)text);
        }
    }

    private void drawAttitude(class_4587 ps, EntityVehicle v, int x, int y, int w, int h, int text, int accent) {
        float pitch = v.method_36455();
        float roll = v.zRot;
        float pxPerDeg = 2.0f;
        ps.method_22903();
        ps.method_22904((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 0.0);
        ps.method_22907(class_1160.field_20707.method_23214(-roll));
        int bandW = w - 10;
        int cy = (int)(pitch * pxPerDeg);
        ModernHudOverlay.method_25294((class_4587)ps, (int)(-bandW / 2), (int)(cy - 1), (int)(bandW / 2), (int)(cy + 1), (int)text);
        for (int pd = -45; pd <= 45; pd += 15) {
            int yy = (int)((float)pd * pxPerDeg) + cy;
            int len = pd % 30 == 0 ? 12 : 8;
            ModernHudOverlay.method_25294((class_4587)ps, (int)(-len), (int)yy, (int)-2, (int)(yy + 1), (int)this.withAlpha(text, 0.6f));
            ModernHudOverlay.method_25294((class_4587)ps, (int)2, (int)yy, (int)len, (int)(yy + 1), (int)this.withAlpha(text, 0.6f));
        }
        ModernHudOverlay.method_25294((class_4587)ps, (int)-6, (int)-1, (int)6, (int)1, (int)accent);
        ModernHudOverlay.method_25294((class_4587)ps, (int)-1, (int)-6, (int)1, (int)6, (int)accent);
        ps.method_22909();
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_modern_hud";
    }
}

