/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class VehicleControlOverlay
extends VehicleOverlayComponent {
    public static final class_2960 RUDDER_PEDAL = new class_2960("dscombat", "textures/ui/rudder_pedal.png");
    public static final class_2960 RUDDER_PEDAL_PUSHED = new class_2960("dscombat", "textures/ui/rudder_pedal_pushed.png");
    public static final class_2960 STICK_BASE = new class_2960("dscombat", "textures/ui/stick_base.png");
    public static final class_2960 STICK_KNOB = new class_2960("dscombat", "textures/ui/stick_knob.png");
    public static final int STICK_BASE_SIZE = 60;
    public static final int STICK_KNOB_SIZE = 10;
    protected static int PEDAL_HEIGHT = 25;
    protected static int PEDAL_WIDTH = 20;

    @Override
    protected boolean shouldRender(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleControlOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue() && !((Boolean)Config.CLIENT.showControlsInModernHUD.get()).booleanValue()) {
            return false;
        }
        return VehicleControlOverlay.getPlayerRootVehicle() instanceof EntityVehicle;
    }

    @Override
    protected void render(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)VehicleControlOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int xOrigin = screenWidth - 60 - 1;
        int yOrigin = screenHeight - 1;
        if (vehicle.isAircraft()) {
            yOrigin -= PEDAL_HEIGHT;
            if (vehicle.inputs.yaw < 0.0f) {
                RenderSystem.setShaderTexture((int)0, (class_2960)RUDDER_PEDAL_PUSHED);
            } else {
                RenderSystem.setShaderTexture((int)0, (class_2960)RUDDER_PEDAL);
            }
            VehicleControlOverlay.method_25290((class_4587)poseStack, (int)xOrigin, (int)yOrigin, (float)0.0f, (float)0.0f, (int)PEDAL_WIDTH, (int)PEDAL_HEIGHT, (int)PEDAL_WIDTH, (int)PEDAL_HEIGHT);
            if (vehicle.inputs.yaw > 0.0f) {
                RenderSystem.setShaderTexture((int)0, (class_2960)RUDDER_PEDAL_PUSHED);
            } else {
                RenderSystem.setShaderTexture((int)0, (class_2960)RUDDER_PEDAL);
            }
            VehicleControlOverlay.method_25290((class_4587)poseStack, (int)(xOrigin + 60 - PEDAL_WIDTH), (int)yOrigin, (float)0.0f, (float)0.0f, (int)PEDAL_WIDTH, (int)PEDAL_HEIGHT, (int)PEDAL_WIDTH, (int)PEDAL_HEIGHT);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)STICK_BASE);
        VehicleControlOverlay.method_25290((class_4587)poseStack, (int)xOrigin, (int)(yOrigin -= 60), (float)0.0f, (float)0.0f, (int)60, (int)60, (int)60, (int)60);
        RenderSystem.setShaderTexture((int)0, (class_2960)STICK_KNOB);
        int baseSizeHalf = 30;
        int knobSizeHalf = 5;
        float yinput = vehicle.inputs.pitch;
        float xinput = vehicle.isAircraft() ? vehicle.inputs.roll : vehicle.inputs.yaw;
        float inputLength = class_3532.method_15355((float)(xinput * xinput + yinput * yinput));
        if (inputLength > 1.0f) {
            xinput /= inputLength;
            yinput /= inputLength;
        }
        VehicleControlOverlay.method_25290((class_4587)poseStack, (int)(xOrigin + baseSizeHalf - knobSizeHalf + (int)(xinput * (float)baseSizeHalf)), (int)(yOrigin + baseSizeHalf - knobSizeHalf + (int)(yinput * (float)baseSizeHalf)), (float)0.0f, (float)0.0f, (int)10, (int)10, (int)10, (int)10);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_controls";
    }
}

