/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;

public class VehicleWeaponsOverlay
extends VehicleOverlayComponent {
    public static final class_2960 WEAPON_TABS = new class_2960("dscombat", "textures/ui/weapon_icons/weapon_tab.png");
    public static final class_2960 SELECTOR = new class_2960("dscombat", "textures/ui/weapon_icons/selection_box.png");
    public static final byte TAB_WIDTH = 93;
    public static final byte TAB_HEIGHT = 24;
    public static final float[] FRAMES = new float[]{0.0f, 5.0f, 10.0f, 13.0f, 16.0f, 18.0f, 20.0f, 22.0f, 23.0f};
    public static final int[] SPACINGS = new int[]{24, 21, 18, 12, 0};
    public static final class_2561 SAFETY = UtilMCText.translatable((String)"ui.dscombat.no_weapon");
    protected boolean weaponChangeState;
    protected boolean weaponChangeQueued;
    protected int weaponChangeCountdown;
    protected int selectedWeapon;
    protected float frame;
    protected int superFrame;

    @Override
    protected boolean shouldRender(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleWeaponsOverlay.defaultRenderConditions()) {
            return false;
        }
        return VehicleWeaponsOverlay.getPlayerVehicle() instanceof EntityRidablePart;
    }

    @Override
    protected void render(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityRidablePart seat = (EntityRidablePart)VehicleWeaponsOverlay.getPlayerVehicle();
        assert (seat != null);
        double yPlacement = screenHeight - 24 - 13;
        int blitPosition = 1;
        if (seat.isTurret()) {
            VehicleWeaponsOverlay.drawFinishedTab(poseStack, ((EntityTurret)seat).getWeaponData(), yPlacement, blitPosition);
            return;
        }
        if (!seat.canPassengerShootParentWeapon()) {
            return;
        }
        EntityVehicle vehicle = seat.getParentVehicle();
        if (vehicle == null) {
            return;
        }
        List<WeaponInstance<?>> weapons = vehicle.weaponSystem.getWeapons();
        WeaponInstance<?> selectedWeapon = vehicle.weaponSystem.getSelected();
        int selectedIndex = vehicle.weaponSystem.getSelectedIndex();
        if (weapons == null || weapons.isEmpty()) {
            return;
        }
        if (selectedWeapon == null) {
            return;
        }
        if (selectedIndex != this.selectedWeapon) {
            this.enableWeaponChangeState();
        }
        this.selectedWeapon = selectedIndex;
        if (this.weaponChangeCountdown <= 0) {
            this.weaponChangeState = false;
        }
        if (!this.weaponChangeState) {
            VehicleWeaponsOverlay.drawFinishedTab(poseStack, selectedWeapon, yPlacement, blitPosition);
        } else {
            int weaponTabsToRender = Math.min(weapons.size(), 5);
            for (int i = 0; i < weaponTabsToRender; ++i) {
                int shiftedIndex = selectedIndex - i;
                if (shiftedIndex < 0) {
                    shiftedIndex = (shiftedIndex % weapons.size() + weapons.size()) % weapons.size();
                }
                int newYPos = (int)(yPlacement - (double)(24 * i));
                WeaponInstance<?> weaponAt = weapons.get(shiftedIndex);
                VehicleWeaponsOverlay.drawTab(poseStack, 13.0, newYPos, blitPosition, 0, false);
                VehicleWeaponsOverlay.drawWeapon(poseStack, weaponAt, 13.0, newYPos, blitPosition + 1, 0, false, false, false);
                poseStack.method_22903();
                poseStack.method_22904(0.0, 0.0, (double)(blitPosition + 3));
                if (!((WeaponStats)weaponAt.getStats()).isNoWeapon()) {
                    VehicleWeaponsOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)(weaponAt.getCurrentAmmo() + "/" + weaponAt.getMaxAmmo()), (int)16, (int)(newYPos + 14), (int)0xE6E600);
                } else {
                    VehicleWeaponsOverlay.method_27535((class_4587)poseStack, (class_327)FONT, (class_2561)SAFETY, (int)16, (int)(newYPos + 14), (int)0xFF5555);
                }
                VehicleWeaponsOverlay.method_27535((class_4587)poseStack, (class_327)FONT, (class_2561)((WeaponStats)weaponAt.getStats()).getDisplayNameComponent(), (int)16, (int)(newYPos + 4), (int)0xFFFFFF);
                poseStack.method_22909();
            }
            VehicleWeaponsOverlay.renderSelectionBox(poseStack, 13.0, yPlacement, blitPosition + 2);
            --this.weaponChangeCountdown;
        }
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_weapons";
    }

    public void queueWeaponChange() {
        this.weaponChangeQueued = true;
    }

    public void enableWeaponChangeState() {
        this.weaponChangeCountdown = 200;
        this.weaponChangeState = true;
        VehicleWeaponsOverlay.getPlayer().method_43077(class_3417.field_15015);
    }

    protected static void drawFinishedTab(class_4587 poseStack, WeaponInstance<?> selectedWeapon, double yPlacement, int blitPosition) {
        if (selectedWeapon == null) {
            return;
        }
        VehicleWeaponsOverlay.drawWeaponName(poseStack, (class_2561)((WeaponStats)selectedWeapon.getStats()).getDisplayNameComponent(), 13.0, yPlacement, blitPosition - 2);
        VehicleWeaponsOverlay.drawTab(poseStack, 13.0, yPlacement, blitPosition, 0, false);
        VehicleWeaponsOverlay.drawWeapon(poseStack, selectedWeapon, 13.0, yPlacement, blitPosition + 1, 0, false, false, false);
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, (double)(blitPosition + 2));
        if (!((WeaponStats)selectedWeapon.getStats()).isNoWeapon()) {
            VehicleWeaponsOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)(selectedWeapon.getCurrentAmmo() + "/" + selectedWeapon.getMaxAmmo()), (int)16, (int)((int)(yPlacement + 14.0)), (int)0xE6E600);
        }
        VehicleWeaponsOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)((WeaponStats)selectedWeapon.getStats()).getWeaponTypeCode(), (int)16, (int)((int)yPlacement + 4), (int)0xE6E600);
        poseStack.method_22909();
    }

    protected static void drawTab(class_4587 stack, double x, double y, int blitOffset, int frame, boolean scrollsUpward) {
        if (frame < 0 || frame > VehicleWeaponsOverlay.getMaxFrames() - 1) {
            throw new IllegalArgumentException("There are only " + VehicleWeaponsOverlay.getMaxFrames() + " frames!");
        }
        float sign = scrollsUpward ? -1.0f : 1.0f;
        stack.method_22903();
        stack.method_22904(x, y, (double)blitOffset);
        RenderSystem.setShaderTexture((int)0, (class_2960)WEAPON_TABS);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        VehicleWeaponsOverlay.method_25290((class_4587)stack, (int)0, (int)0, (float)0.0f, (float)(sign * FRAMES[frame]), (int)93, (int)24, (int)93, (int)24);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        stack.method_22909();
    }

    protected static void drawWeapon(class_4587 stack, WeaponInstance<?> weapon, double x, double y, int blitOffset, int frame, boolean scrollsUpward, boolean scrollsToBlank, boolean scrollsFromBlank) {
        if (frame < 0 || frame > VehicleWeaponsOverlay.getMaxFrames() - 1) {
            throw new IllegalArgumentException("There are only " + VehicleWeaponsOverlay.getMaxFrames() + " frames!");
        }
        if (scrollsToBlank && scrollsFromBlank) {
            throw new IllegalArgumentException("Tabs may not scroll to and from blank!");
        }
        if (weapon == null) {
            throw new NullPointerException("Passed weapon is null!");
        }
        int frameValue = (int)FRAMES[frame];
        RenderSystem.setShaderTexture((int)0, (class_2960)((WeaponStats)weapon.getStats()).getWeaponIcon());
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        stack.method_22903();
        if (scrollsUpward) {
            stack.method_22904(x, y + (double)frameValue, (double)blitOffset);
            if (scrollsFromBlank) {
                VehicleWeaponsOverlay.blitWithoutTop(stack, 24 - frameValue);
            }
            if (scrollsToBlank) {
                VehicleWeaponsOverlay.blitWithoutBottom(stack, frameValue);
            }
        } else {
            stack.method_22904(x, y - (double)frameValue, (double)blitOffset);
            if (scrollsFromBlank) {
                VehicleWeaponsOverlay.blitWithoutBottom(stack, 24 - frameValue);
            }
            if (scrollsToBlank) {
                VehicleWeaponsOverlay.blitWithoutTop(stack, frameValue);
            }
        }
        if (!scrollsFromBlank && !scrollsToBlank) {
            VehicleWeaponsOverlay.blitNormal(stack);
        }
        stack.method_22909();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    protected static void drawWeaponName(class_4587 stack, class_2561 name, double x, double y, int blitOffset) {
        stack.method_22903();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_1159 matrix4f = stack.method_23760().method_23761();
        int nameWidth = FONT.method_27525((class_5348)name);
        Objects.requireNonNull(FONT);
        int nameHeight = 9;
        int blitOffsetUnder = blitOffset - 1;
        int xPosInitial = (int)x + 1;
        int xPosFinal = xPosInitial + nameWidth + 6;
        int yPosInitial = (int)y - 12;
        int yPosFinal = yPosInitial + nameHeight + 5;
        VehicleWeaponsOverlay.method_27533((class_1159)matrix4f, (class_287)bufferbuilder, (int)(xPosInitial - 1), (int)yPosInitial, (int)xPosInitial, (int)(yPosFinal + 1), (int)blitOffsetUnder, (int)-267386864, (int)-267386864);
        VehicleWeaponsOverlay.method_27533((class_1159)matrix4f, (class_287)bufferbuilder, (int)xPosInitial, (int)yPosInitial, (int)xPosFinal, (int)yPosFinal, (int)blitOffsetUnder, (int)-267386864, (int)-267386864);
        VehicleWeaponsOverlay.method_27533((class_1159)matrix4f, (class_287)bufferbuilder, (int)xPosInitial, (int)(yPosInitial - 1), (int)xPosFinal, (int)yPosInitial, (int)blitOffsetUnder, (int)-267386864, (int)-267386864);
        VehicleWeaponsOverlay.method_27533((class_1159)matrix4f, (class_287)bufferbuilder, (int)xPosInitial, (int)yPosFinal, (int)xPosFinal, (int)(yPosFinal + 1), (int)blitOffsetUnder, (int)-267386864, (int)-267386864);
        VehicleWeaponsOverlay.method_27533((class_1159)matrix4f, (class_287)bufferbuilder, (int)xPosFinal, (int)yPosInitial, (int)(xPosFinal + 1), (int)yPosFinal, (int)blitOffsetUnder, (int)-267386864, (int)-267386864);
        VehicleWeaponsOverlay.method_27533((class_1159)matrix4f, (class_287)bufferbuilder, (int)xPosInitial, (int)(yPosInitial + 1), (int)(xPosInitial + 1), (int)(yPosFinal - 1), (int)blitOffsetUnder, (int)0x505000FF, (int)1344798847);
        VehicleWeaponsOverlay.method_27533((class_1159)matrix4f, (class_287)bufferbuilder, (int)(xPosFinal - 1), (int)(yPosInitial + 1), (int)xPosFinal, (int)(yPosFinal - 1), (int)blitOffsetUnder, (int)0x505000FF, (int)1344798847);
        VehicleWeaponsOverlay.method_27533((class_1159)matrix4f, (class_287)bufferbuilder, (int)xPosInitial, (int)yPosInitial, (int)xPosFinal, (int)(yPosInitial + 1), (int)blitOffsetUnder, (int)0x505000FF, (int)0x505000FF);
        VehicleWeaponsOverlay.method_27533((class_1159)matrix4f, (class_287)bufferbuilder, (int)xPosInitial, (int)(yPosFinal - 1), (int)xPosFinal, (int)yPosFinal, (int)blitOffsetUnder, (int)1344798847, (int)1344798847);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        stack.method_22904(x, y - 11.0, (double)blitOffset);
        FONT.method_30882(name, 4.0f, 2.0f, -1, true, matrix4f, (class_4597)bufferSource, false, 0, 0xF000F0);
        bufferSource.method_22993();
        stack.method_22909();
    }

    protected static void renderSelectionBox(class_4587 stack, double x, double y, int blitOffset) {
        RenderSystem.setShaderTexture((int)0, (class_2960)SELECTOR);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        stack.method_22903();
        stack.method_22904(x, y, (double)blitOffset);
        VehicleWeaponsOverlay.method_25290((class_4587)stack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)93, (int)24, (int)93, (int)24);
        stack.method_22909();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    protected static void blitNormal(class_4587 stack) {
        VehicleWeaponsOverlay.method_25290((class_4587)stack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)93, (int)24, (int)93, (int)24);
    }

    protected static void blitWithoutTop(class_4587 stack, int trimPixels) {
        VehicleWeaponsOverlay.method_25290((class_4587)stack, (int)0, (int)trimPixels, (float)0.0f, (float)trimPixels, (int)93, (int)(24 - trimPixels), (int)93, (int)24);
    }

    protected static void blitWithoutBottom(class_4587 stack, int trimPixels) {
        VehicleWeaponsOverlay.method_25290((class_4587)stack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)93, (int)(24 - trimPixels), (int)93, (int)24);
    }

    protected static int getMaxFrames() {
        return FRAMES.length;
    }
}

