/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.renderer;

import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitbox;
import com.onewhohears.dscombat.util.UtilRender;
import com.onewhohears.onewholibs.util.math.Mat3f;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.class_1159;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public interface RotableHitboxRenderer {
    public static final int[] DEFAULT_COLOR = new int[]{188, 85, 41, 255};
    public static final int[] DESTROYED_COLOR = new int[]{120, 0, 0, 255};

    default public boolean shouldDrawRotableHitboxes(EntityVehicle entity) {
        if (entity.method_5767() || entity.getHitboxes().isEmpty()) {
            return false;
        }
        class_310 m = class_310.method_1551();
        return !m.method_1555() && m.method_1561().method_3958();
    }

    default public void drawRotableHitboxeOutlines(EntityVehicle entity, float partialTicks, class_4587 poseStack, class_4597 bufferSource) {
        class_4588 buff = bufferSource.getBuffer(class_1921.method_23594());
        QuaternionF q = UtilAngles.lerpQ((float)partialTicks, (QuaternionF)entity.getPrevQ(), (QuaternionF)entity.getClientQ());
        for (RotableHitbox hitbox : entity.getHitboxes()) {
            this.drawRotableHitboxOutline(hitbox, poseStack, buff, q);
        }
    }

    private void drawRotableHitboxOutline(RotableHitbox hitbox, class_4587 poseStack, class_4588 buff, QuaternionF q) {
        poseStack.method_22903();
        class_243 trans = UtilAngles.rotateVector((class_243)hitbox.getRelPos(), (QuaternionF)q);
        poseStack.method_22904(trans.field_1352, trans.field_1351, trans.field_1350);
        Mat4f m4 = Mat4f.from((class_1159)poseStack.method_23760().method_23761());
        Mat3f m3 = Mat3f.from((class_4581)poseStack.method_23760().method_23762());
        Vec3f ext = UtilGeometry.convertVector((class_243)hitbox.getHitbox().getExtents());
        Vec3f c0 = ext.copy();
        c0.transform(q);
        Vec3f c1 = ext.copy();
        c1.mul(-1.0f, 1.0f, 1.0f);
        c1.transform(q);
        Vec3f c2 = ext.copy();
        c2.mul(1.0f, -1.0f, 1.0f);
        c2.transform(q);
        Vec3f c3 = ext.copy();
        c3.mul(1.0f, 1.0f, -1.0f);
        c3.transform(q);
        Vec3f c4 = c3.copy();
        c4.mul(-1.0f);
        Vec3f c5 = c2.copy();
        c5.mul(-1.0f);
        Vec3f c6 = c1.copy();
        c6.mul(-1.0f);
        Vec3f c7 = c0.copy();
        c7.mul(-1.0f);
        int[] color = hitbox.isDestroyed() ? DESTROYED_COLOR : DEFAULT_COLOR;
        UtilRender.drawLine(c0, c1, buff, m4, m3, color);
        UtilRender.drawLine(c0, c2, buff, m4, m3, color);
        UtilRender.drawLine(c0, c3, buff, m4, m3, color);
        UtilRender.drawLine(c1, c5, buff, m4, m3, color);
        UtilRender.drawLine(c1, c4, buff, m4, m3, color);
        UtilRender.drawLine(c2, c4, buff, m4, m3, color);
        UtilRender.drawLine(c2, c6, buff, m4, m3, color);
        UtilRender.drawLine(c3, c5, buff, m4, m3, color);
        UtilRender.drawLine(c3, c6, buff, m4, m3, color);
        UtilRender.drawLine(c4, c7, buff, m4, m3, color);
        UtilRender.drawLine(c5, c7, buff, m4, m3, color);
        UtilRender.drawLine(c6, c7, buff, m4, m3, color);
        poseStack.method_22909();
    }
}

