/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.dscombat.client.overlay.HudLayoutManager;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityHelicopter;
import com.onewhohears.dscombat.entity.vehicle.EntityPlane;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class HudLayoutEditScreen
extends class_437 {
    private final Runnable onSave;
    private float scale;
    private int sw;
    private int sh;
    private EntityVehicle vehicle;
    private boolean isHeli;
    private boolean isPlane;
    private static final String[] IDS = new String[]{"att", "head", "br", "bl"};
    private final Map<String, HudLayoutManager.Rect> rects = new HashMap<String, HudLayoutManager.Rect>();
    private String draggingId = null;
    private boolean resizing = false;
    private double dragDX = 0.0;
    private double dragDY = 0.0;
    private static final int HANDLE = 12;

    public HudLayoutEditScreen(Runnable onSave) {
        super((class_2561)class_2561.method_43471((String)"screen.dscombat.hud_layout_edit"));
        this.onSave = onSave;
    }

    protected void method_25426() {
        class_1297 class_12972;
        class_310 mc = class_310.method_1551();
        this.scale = ((Double)Config.CLIENT.modernHudScale.get()).floatValue();
        this.sw = (int)((float)this.field_22789 / this.scale);
        this.sh = (int)((float)this.field_22790 / this.scale);
        this.vehicle = null;
        if (mc.field_1724 != null && (class_12972 = mc.field_1724.method_5668()) instanceof EntityVehicle) {
            EntityVehicle v;
            this.vehicle = v = (EntityVehicle)class_12972;
        }
        if (this.vehicle == null) {
            this.method_25419();
            return;
        }
        this.isHeli = this.vehicle instanceof EntityHelicopter;
        this.isPlane = this.vehicle instanceof EntityPlane;
        int defAttW = 180;
        int defAttH = 110;
        int defAttX = this.sw / 2 - defAttW / 2;
        int defAttY = this.sh / 2 - defAttH / 2 + 12;
        int defHrW = 220;
        int defHrH = 18;
        int defHrX = this.sw / 2 - defHrW / 2;
        int defHrY = defAttY - defHrH - 4;
        int defBrW = 190;
        int defBrH = 96;
        int defBrX = this.sw - defBrW - 10;
        int defBrY = this.sh - defBrH - 10;
        int defBlW = 220;
        int defBlH = 110;
        int defBlX = 10;
        int defBlY = this.sh - defBlH - 10;
        this.rects.put("att", HudLayoutManager.get(this.vt(), "att", new HudLayoutManager.Rect((double)defAttX / (double)this.sw, (double)defAttY / (double)this.sh, (double)defAttW / (double)this.sw, (double)defAttH / (double)this.sh)));
        this.rects.put("head", HudLayoutManager.get(this.vt(), "head", new HudLayoutManager.Rect((double)defHrX / (double)this.sw, (double)defHrY / (double)this.sh, (double)defHrW / (double)this.sw, (double)defHrH / (double)this.sh)));
        this.rects.put("br", HudLayoutManager.get(this.vt(), "br", new HudLayoutManager.Rect((double)defBrX / (double)this.sw, (double)defBrY / (double)this.sh, (double)defBrW / (double)this.sw, (double)defBrH / (double)this.sh)));
        this.rects.put("bl", HudLayoutManager.get(this.vt(), "bl", new HudLayoutManager.Rect((double)defBlX / (double)this.sw, (double)defBlY / (double)this.sh, (double)defBlW / (double)this.sw, (double)defBlH / (double)this.sh)));
        this.method_37063((class_364)new class_4185(this.field_22789 - 130, 10, 120, 20, (class_2561)class_2561.method_43470((String)"Save & Close"), b -> this.closeAndSave()));
    }

    private String vt() {
        if (this.vehicle instanceof EntityHelicopter) {
            return "HELICOPTER";
        }
        if (this.vehicle instanceof EntityPlane) {
            return "PLANE";
        }
        if (((VehicleStats)this.vehicle.getStats()).isBoat()) {
            return "BOAT";
        }
        return "GENERIC";
    }

    public void method_25394(class_4587 ps, int mouseX, int mouseY, float partialTick) {
        this.method_25420(ps);
        ps.method_22903();
        ps.method_22905(this.scale, this.scale, 1.0f);
        HudLayoutEditScreen.method_27535((class_4587)ps, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)"HUD Layout Edit"), (int)8, (int)8, (int)Color.WHITE.getRGB());
        HudLayoutEditScreen.method_27535((class_4587)ps, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)"Drag to move, drag corner to resize. F6 or button to save."), (int)8, (int)20, (int)0xCCCCCC);
        this.drawRect(ps, "att", 0x66FFFFFF, -1426063361);
        this.drawRect(ps, "head", 0x66FFFFFF, -1426063361);
        this.drawRect(ps, "br", 0x66FFFFFF, -1426063361);
        this.drawRect(ps, "bl", 0x66FFFFFF, -1426063361);
        ps.method_22909();
        super.method_25394(ps, mouseX, mouseY, partialTick);
    }

    private void drawRect(class_4587 ps, String id, int border, int handle) {
        HudLayoutManager.Rect r = this.rects.get(id);
        int x = (int)Math.round(r.x * (double)this.sw);
        int y = (int)Math.round(r.y * (double)this.sh);
        int w = (int)Math.round(r.w * (double)this.sw);
        int h = (int)Math.round(r.h * (double)this.sh);
        HudLayoutEditScreen.method_25294((class_4587)ps, (int)(x - 1), (int)(y - 1), (int)(x + w + 1), (int)y, (int)border);
        HudLayoutEditScreen.method_25294((class_4587)ps, (int)(x - 1), (int)(y + h), (int)(x + w + 1), (int)(y + h + 1), (int)border);
        HudLayoutEditScreen.method_25294((class_4587)ps, (int)(x - 1), (int)y, (int)x, (int)(y + h), (int)border);
        HudLayoutEditScreen.method_25294((class_4587)ps, (int)(x + w), (int)y, (int)(x + w + 1), (int)(y + h), (int)border);
        HudLayoutEditScreen.method_25303((class_4587)ps, (class_327)this.field_22793, (String)id, (int)(x + 2), (int)(y - 10), (int)Color.WHITE.getRGB());
        HudLayoutEditScreen.method_25294((class_4587)ps, (int)(x + w - 6), (int)(y + h - 6), (int)(x + w + 6), (int)(y + h + 6), (int)handle);
    }

    public boolean method_25402(double mx, double my, int button) {
        double hx = mx / (double)this.scale;
        double hy = my / (double)this.scale;
        for (String id : IDS) {
            boolean onHandle;
            boolean inside;
            HudLayoutManager.Rect r = this.rects.get(id);
            int x = (int)Math.round(r.x * (double)this.sw);
            int y = (int)Math.round(r.y * (double)this.sh);
            int w = (int)Math.round(r.w * (double)this.sw);
            int h = (int)Math.round(r.h * (double)this.sh);
            boolean bl = inside = hx >= (double)x && hx <= (double)(x + w) && hy >= (double)y && hy <= (double)(y + h);
            if (!inside) continue;
            this.draggingId = id;
            this.resizing = onHandle = hx >= (double)(x + w - 12) && hy >= (double)(y + h - 12);
            this.dragDX = (hx - (double)x) / (double)this.sw;
            this.dragDY = (hy - (double)y) / (double)this.sh;
            return true;
        }
        return super.method_25402(mx, my, button);
    }

    public boolean method_25403(double mx, double my, int button, double dx, double dy) {
        if (this.draggingId != null) {
            double hx = mx / (double)this.scale;
            double hy = my / (double)this.scale;
            HudLayoutManager.Rect r = this.rects.get(this.draggingId);
            if (this.resizing) {
                r.w = this.clamp01(hx / (double)this.sw - r.x);
                r.h = this.clamp01(hy / (double)this.sh - r.y);
            } else {
                r.x = this.clamp01(hx / (double)this.sw - this.dragDX);
                r.y = this.clamp01(hy / (double)this.sh - this.dragDY);
            }
            return true;
        }
        return super.method_25403(mx, my, button, dx, dy);
    }

    public boolean method_25406(double mx, double my, int button) {
        if (this.draggingId != null) {
            HudLayoutManager.set(this.vt(), this.draggingId, this.rects.get(this.draggingId));
            this.draggingId = null;
            this.resizing = false;
            return true;
        }
        return super.method_25406(mx, my, button);
    }

    private double clamp01(double v) {
        return v < 0.0 ? 0.0 : (v > 1.0 ? 1.0 : v);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (DSCKeys.hudLayoutEditKey != null && this.DSCCmp(keyCode, DSCKeys.hudLayoutEditKey)) {
            this.closeAndSave();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private boolean DSCCmp(int keyCode, class_304 mapping) {
        return mapping.method_1429().method_1444() == keyCode;
    }

    public void closeAndSave() {
        for (Map.Entry<String, HudLayoutManager.Rect> e : this.rects.entrySet()) {
            HudLayoutManager.set(this.vt(), e.getKey(), e.getValue());
        }
        HudLayoutManager.save();
        this.onSave.run();
        this.method_25419();
    }

    public void method_25419() {
        class_310.method_1551().method_1507(null);
    }
}

