/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.client.overlay.components.VehicleStatsOverlay;
import com.onewhohears.dscombat.client.screen.VehicleSubScreen;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitbox;
import com.onewhohears.dscombat.util.UtilPrint;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class VehicleHealthScreen
extends VehicleSubScreen {
    public static final class_2960 BG_TEXTURE = new class_2960("dscombat", "textures/ui/background/vehicle_health_screen.png");
    public static final class_2960 FUEL_GAUGE = new class_2960("dscombat", "textures/ui/fuel_guage.png");
    public static final class_2960 FUEL_GAUGE_ARROW = new class_2960("dscombat", "textures/ui/fuel_guage_arrow.png");
    public static final int FUEL_GAUGE_HEIGHT = 40;
    public static final int FUEL_GAUGE_WIDTH = 60;
    public static final int FUEL_ARROW_HEIGHT = 7;
    public static final int FUEL_ARROW_WIDTH = 24;
    private static final int imageWidth = 240;
    private static final int imageHeight = 180;
    private static final int textureSize = 256;
    private int maxHitboxNameWidth;
    private class_5250[] hitboxNames;

    protected VehicleHealthScreen() {
        super("screen.dscombat.vehicle_health_screen", BG_TEXTURE, 240, 180, 256, 256);
        this.left_padding = 6;
        this.right_padding = 6;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        EntityVehicle vehicle = this.getVehicle();
        this.hitboxNames = new class_5250[vehicle.getHitboxes().size()];
        this.maxHitboxNameWidth = 0;
        for (int i = 0; i < vehicle.getHitboxes().size(); ++i) {
            this.hitboxNames[i] = UtilMCText.translatable((String)vehicle.getHitboxes().get(i).getHitboxName()).method_10862(class_2583.field_24360.method_36139(43520));
            int width = this.field_22787.field_1772.method_27525((class_5348)this.hitboxNames[i]);
            if (width <= this.maxHitboxNameWidth) continue;
            this.maxHitboxNameWidth = width;
        }
        this.maxHitboxNameWidth += 10;
    }

    @Override
    public void method_25420(@NotNull class_4587 poseStack) {
        super.method_25420(poseStack);
        EntityVehicle vehicle = this.getVehicle();
        this.field_22787.field_1772.method_30883(poseStack, (class_2561)UtilMCText.translatable((String)"ui.dscombat.root_health").method_27693(":" + (int)vehicle.getHealth() + "/" + (int)vehicle.getMaxHealth()), (float)(this.guiX + this.left_padding), (float)(this.guiY + this.top_padding + 40), VehicleHealthScreen.getHealthColor(vehicle.getHealth(), vehicle.getMaxHealth()));
        this.field_22787.field_1772.method_30883(poseStack, (class_2561)UtilMCText.translatable((String)"ui.dscombat.root_armor").method_27693(":" + (int)vehicle.getArmor() + "/" + (int)vehicle.getMaxTotalArmor()), (float)(this.guiX + this.left_padding) + 120.0f, (float)(this.guiY + this.top_padding + 40), VehicleHealthScreen.getHealthColor(vehicle.getArmor(), vehicle.getMaxTotalArmor()));
        if (this.hitboxNames != null && this.hitboxNames.length > 0) {
            this.field_22787.field_1772.method_30883(poseStack, (class_2561)UtilMCText.translatable((String)"ui.dscombat.hitbox_health_armor"), (float)(this.guiX + this.left_padding), (float)(this.guiY + this.top_padding + 54), 170);
            float hitbox_scale = 0.6666667f;
            poseStack.method_22903();
            poseStack.method_22905(hitbox_scale, hitbox_scale, 1.0f);
            int startX = (int)((float)(this.guiX + this.left_padding) / hitbox_scale);
            int startY = (int)((float)(this.guiY + this.top_padding + 66) / hitbox_scale);
            for (int i = 0; i < vehicle.getHitboxes().size(); ++i) {
                RotableHitbox hitbox = vehicle.getHitboxes().get(i);
                float health = hitbox.getHealth();
                float max_health = hitbox.getMaxHealth();
                class_2583 healthStyle = class_2583.field_24360.method_36139(VehicleHealthScreen.getHealthColor(health, max_health));
                float armor = hitbox.getArmor();
                float max_armor = hitbox.getMaxArmor();
                class_2583 armorStyle = class_2583.field_24360.method_36139(VehicleHealthScreen.getHealthColor(armor, max_armor));
                this.field_22787.field_1772.method_30883(poseStack, (class_2561)this.hitboxNames[i], (float)startX, (float)(startY + i * 10), 0xFFFFFF);
                if (i == 0 && ((VehicleStats)vehicle.getStats()).rootHitboxNoCollide) continue;
                this.field_22787.field_1772.method_30883(poseStack, (class_2561)UtilMCText.literal((String)("H: " + (int)health + "/" + (int)max_health)).method_10862(healthStyle), (float)(startX + this.maxHitboxNameWidth), (float)(startY + i * 10), 0xFFFFFF);
                this.field_22787.field_1772.method_30883(poseStack, (class_2561)UtilMCText.literal((String)("A: " + (int)armor + "/" + (int)max_armor)).method_10862(armorStyle), (float)(startX + this.maxHitboxNameWidth + 70), (float)(startY + i * 10), 0xFFFFFF);
            }
            poseStack.method_22909();
        }
        int xOrigin = this.guiX + this.left_padding + 2;
        int yOrigin = this.guiY + this.top_padding + 130;
        RenderSystem.setShaderTexture((int)0, (class_2960)FUEL_GAUGE);
        VehicleHealthScreen.method_25290((class_4587)poseStack, (int)xOrigin, (int)yOrigin, (float)0.0f, (float)0.0f, (int)60, (int)40, (int)60, (int)40);
        float max = vehicle.getMaxFuel();
        float fuelPercent = 0.0f;
        if (max != 0.0f) {
            fuelPercent = vehicle.getCurrentFuel() / max;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)FUEL_GAUGE_ARROW);
        poseStack.method_22903();
        poseStack.method_22904((double)xOrigin + 30.0, (double)(yOrigin + 24), 0.0);
        poseStack.method_22907(Vec3f.ZP.rotationDegrees(160.0f * fuelPercent + 10.0f).convert());
        VehicleHealthScreen.method_25290((class_4587)poseStack, (int)-19, (int)-3, (float)0.0f, (float)0.0f, (int)24, (int)7, (int)24, (int)7);
        poseStack.method_22909();
        double thrustToWeight = (double)vehicle.getAfterburnerMaxPushThrust() / ((double)vehicle.getTotalMass() * vehicle.getAccGravity());
        this.field_22787.field_1772.method_30883(poseStack, (class_2561)UtilMCText.translatable((String)"ui.dscombat.thrust_to_weight_ratio"), (float)(this.guiX + this.left_padding + 100), (float)(this.guiY + this.top_padding + 150), 170);
        this.field_22787.field_1772.method_30883(poseStack, (class_2561)UtilMCText.literal((String)UtilPrint.printDec(thrustToWeight, 4)), (float)(this.guiX + this.left_padding + 100), (float)(this.guiY + this.top_padding + 160), VehicleHealthScreen.getThrustToWeightColor(thrustToWeight));
    }

    public static int getHealthColor(float health, float max) {
        return VehicleStatsOverlay.getHealthColor(health, max);
    }

    public static int getThrustToWeightColor(double thrustToWeight) {
        if (thrustToWeight > 1.0) {
            return VehicleStatsOverlay.GREEN_ME_SAY_ALONE_RAMP.getRGB();
        }
        return VehicleStatsOverlay.RED.getRGB();
    }
}

