/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen.key_bind;

import com.onewhohears.dscombat.client.input.ActionInput;
import com.onewhohears.dscombat.client.input.ActionInputHolder;
import com.onewhohears.dscombat.client.input.ClientInputManager;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.dscombat.client.screen.VehicleSubScreen;
import com.onewhohears.dscombat.client.screen.key_bind.VehicleEditAxisBindScreen;
import com.onewhohears.dscombat.client.screen.key_bind.VehicleEditButtonBindScreen;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public abstract class SelectBindScreen<H extends ActionInputHolder<A>, A extends ActionInput>
extends VehicleSubScreen {
    private static final String[] filteredNames = new String[]{"keyboard", "ducky one"};
    public static final class_2960 BG_TEXTURE = new class_2960("dscombat", "textures/ui/background/vehicle_other_screen.png");
    private static final int imageWidth = 240;
    private static final int imageHeight = 180;
    private static final int textureSize = 256;
    protected final int page;
    protected final H action;
    protected final boolean primary;

    public static boolean filterJoystick(String name) {
        String n = name.toLowerCase();
        for (String f : filteredNames) {
            if (!n.contains(f)) continue;
            return true;
        }
        return false;
    }

    public SelectBindScreen(int page, H action, boolean primary) {
        super(((ActionInputHolder)action).getNameString(), BG_TEXTURE, 240, 180, 256, 256);
        this.page = page;
        this.action = action;
        this.primary = primary;
    }

    @Override
    protected void method_25426() {
        this.vertical_widget_shift = 10;
        super.method_25426();
        this.positionWidgetGrid((class_339)new class_4185(0, 0, 20, 20, (class_2561)UtilMCText.translatable((String)"ui.dscombat.save"), onPress -> {
            this.applyChanges();
            ClientInputManager.saveKeyBinds();
            class_310.method_1551().method_1507(this.getBackScreen());
        }), this.ROWS, this.COLUMNS, 1, this.padding);
    }

    protected abstract A createNewInput();

    protected void applyChanges() {
        A input = this.createNewInput();
        if (this.primary) {
            ((ActionInputHolder)this.action).setPrimaryAction(input);
        } else {
            ((ActionInputHolder)this.action).setSecondaryAction(input);
        }
    }

    protected A getActionInput() {
        if (this.primary) {
            return ((ActionInputHolder)this.action).getPrimaryAction();
        }
        return ((ActionInputHolder)this.action).getSecondaryAction();
    }

    @Override
    public void method_25420(@NotNull class_4587 poseStack) {
        super.method_25420(poseStack);
        class_5250 alt = this.primary ? UtilMCText.translatable((String)"ui.dscombat.primary") : UtilMCText.translatable((String)"ui.dscombat.secondary");
        this.field_22787.field_1772.method_30883(poseStack, (class_2561)alt, (float)(this.guiX + this.image_width - 60), (float)(this.guiY + this.top_padding), this.infoColor);
    }

    public static abstract class ButtonScreen
    extends SelectBindScreen<ActionInputHolder.Button, ActionInput.Button> {
        public ButtonScreen(int page, ActionInputHolder.Button action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected class_437 getBackScreen() {
            return new VehicleEditButtonBindScreen(this.page, (ActionInputHolder.Button)this.action);
        }
    }

    public static abstract class AxisScreen
    extends SelectBindScreen<ActionInputHolder.Axis, ActionInput.Axis> {
        public AxisScreen(int page, ActionInputHolder.Axis action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected class_437 getBackScreen() {
            return new VehicleEditAxisBindScreen(this.page, (ActionInputHolder.Axis)this.action);
        }
    }

    public static class DSCKeyAxis
    extends AxisScreen {
        private final boolean positive;
        private String key_mapping_id_negative = "unbound";
        private String key_mapping_id_positive = "unbound";

        public DSCKeyAxis(int page, ActionInputHolder.Axis action, boolean primary, boolean positive) {
            super(page, action, primary);
            this.positive = positive;
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            ActionInput.Axis input = (ActionInput.Axis)this.getActionInput();
            if (input instanceof ActionInput.DSCKeyAxis) {
                ActionInput.DSCKeyAxis data = (ActionInput.DSCKeyAxis)input;
                this.key_mapping_id_negative = data.key_mapping_id_negative;
                this.key_mapping_id_positive = data.key_mapping_id_positive;
            }
            class_342 keyIDBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)keyIDBox, this.ROWS, this.COLUMNS, 2, 2);
            if (this.positive) {
                keyIDBox.method_1852(this.key_mapping_id_positive);
            } else {
                keyIDBox.method_1852(this.key_mapping_id_negative);
            }
            keyIDBox.method_1868(0xFFFFFF);
            keyIDBox.method_1863(string -> {
                if (DSCKeys.hasKey(string)) {
                    if (this.positive) {
                        this.key_mapping_id_positive = string;
                    } else {
                        this.key_mapping_id_negative = string;
                    }
                    keyIDBox.method_1868(65280);
                } else {
                    keyIDBox.method_1868(0xFF0000);
                }
            });
        }

        @Override
        public void method_25420(@NotNull class_4587 poseStack) {
            super.method_25420(poseStack);
            float scale = 0.7f;
            float startY = (float)(this.guiY + this.top_padding + 60) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            float width2 = (float)this.image_width / 2.0f / scale;
            poseStack.method_22903();
            poseStack.method_22905(scale, scale, scale);
            String test = this.positive ? this.key_mapping_id_positive : this.key_mapping_id_negative;
            int i = 0;
            Set<String> keys = DSCKeys.getKeyIds();
            for (String key : keys) {
                int color = this.infoColor;
                if (key.equals(test)) {
                    color = 65280;
                }
                this.field_22787.field_1772.method_1729(poseStack, key, startX + width2 * (float)(i % 2), startY + (float)(class_3532.method_15375((float)((float)i / 2.0f)) * 10), color);
                ++i;
            }
            poseStack.method_22909();
        }

        @Override
        protected ActionInput.Axis createNewInput() {
            return new ActionInput.DSCKeyAxis(this.key_mapping_id_negative, this.key_mapping_id_positive);
        }
    }

    public static class ControllerJoystickAxis
    extends AxisScreen {
        private int joystick_id;
        private int axis_id;
        private float dead_zone = 0.1f;
        private boolean invert;

        public ControllerJoystickAxis(int page, ActionInputHolder.Axis action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            this.vertical_widget_shift = 18;
            ActionInput.Axis input = (ActionInput.Axis)this.getActionInput();
            if (input instanceof ActionInput.ControllerAxis) {
                ActionInput.ControllerAxis data = (ActionInput.ControllerAxis)input;
                this.joystick_id = data.joystick_id;
                this.axis_id = data.axis_id;
                this.dead_zone = data.dead_zone;
                this.invert = data.invert;
            }
            class_342 joystickIDBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)joystickIDBox, this.ROWS, 4, 4, 2);
            joystickIDBox.method_1852("" + this.joystick_id);
            joystickIDBox.method_1868(0xFFFFFF);
            joystickIDBox.method_1863(string -> {
                try {
                    this.joystick_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            class_342 axisIDBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)axisIDBox, this.ROWS, 4, 5, 2);
            axisIDBox.method_1852("" + this.axis_id);
            axisIDBox.method_1868(0xFFFFFF);
            axisIDBox.method_1863(string -> {
                try {
                    this.axis_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            class_342 deadZoneBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)deadZoneBox, this.ROWS, 4, 6, 2);
            deadZoneBox.method_1852("" + this.dead_zone);
            deadZoneBox.method_1868(0xFFFFFF);
            deadZoneBox.method_1863(string -> {
                try {
                    this.dead_zone = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.positionWidgetGrid((class_339)new class_4286(0, 0, 20, 20, (class_2561)UtilMCText.literal((String)""), this.invert){

                public void method_25306() {
                    super.method_25306();
                    invert = !invert;
                }
            }, this.ROWS, 4, 7, 2);
        }

        @Override
        public void method_25420(@NotNull class_4587 poseStack) {
            super.method_25420(poseStack);
            int ix = this.guiX + this.left_padding;
            int iy = this.guiY + this.top_padding + 36;
            int w4 = 60;
            this.field_22787.field_1772.method_1729(poseStack, "Joystick ID", (float)ix, (float)iy, this.infoColor);
            this.field_22787.field_1772.method_1729(poseStack, "Axis ID", (float)(ix + w4 - 1), (float)iy, this.infoColor);
            this.field_22787.field_1772.method_1729(poseStack, "Dead Zone", (float)(ix + w4 * 2 - 2), (float)iy, this.infoColor);
            this.field_22787.field_1772.method_1729(poseStack, "Invert", (float)(ix + w4 * 3 - 3), (float)iy, this.infoColor);
            float scale = 0.8f;
            float startY = (float)(this.guiY + this.top_padding + 70) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            poseStack.method_22903();
            poseStack.method_22905(scale, scale, scale);
            int k = 0;
            for (int j = 0; j < 16; ++j) {
                FloatBuffer axes;
                if (!GLFW.glfwJoystickPresent((int)j)) continue;
                String name = GLFW.glfwGetJoystickName((int)j);
                if (name == null) {
                    name = "N/A";
                }
                if (ControllerJoystickAxis.filterJoystick(name) || (axes = GLFW.glfwGetJoystickAxes((int)j)) == null) continue;
                for (int a = 0; a < axes.limit(); ++a) {
                    float value = axes.get(a);
                    if (class_3532.method_15379((float)value) < 0.1f) continue;
                    String text = name + " | ID:" + j + " | Axis:" + a + " | " + value;
                    this.field_22787.field_1772.method_1729(poseStack, text, startX, startY + (float)(k * 10), this.infoColor);
                    ++k;
                }
            }
            poseStack.method_22909();
        }

        @Override
        protected ActionInput.Axis createNewInput() {
            return new ActionInput.ControllerAxis(this.joystick_id, this.axis_id, this.dead_zone, this.invert);
        }
    }

    public static class ControllerButtonAxis
    extends AxisScreen {
        private int joystick_id;
        private int positive_button_id;
        private int negative_button_id;

        public ControllerButtonAxis(int page, ActionInputHolder.Axis action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            this.vertical_widget_shift = 18;
            ActionInput.Axis input = (ActionInput.Axis)this.getActionInput();
            if (input instanceof ActionInput.ControllerButtonAxis) {
                ActionInput.ControllerButtonAxis data = (ActionInput.ControllerButtonAxis)input;
                this.joystick_id = data.joystick_id;
                this.positive_button_id = data.positive_button_id;
                this.negative_button_id = data.negative_button_id;
            }
            class_342 joystickIDBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)joystickIDBox, this.ROWS, 3, 3, 2);
            joystickIDBox.method_1852("" + this.joystick_id);
            joystickIDBox.method_1868(0xFFFFFF);
            joystickIDBox.method_1863(string -> {
                try {
                    this.joystick_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            class_342 positiveButtonBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)positiveButtonBox, this.ROWS, 3, 4, 2);
            positiveButtonBox.method_1852("" + this.positive_button_id);
            positiveButtonBox.method_1868(0xFFFFFF);
            positiveButtonBox.method_1863(string -> {
                try {
                    this.positive_button_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            class_342 negativeButtonBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)negativeButtonBox, this.ROWS, 3, 5, 2);
            negativeButtonBox.method_1852("" + this.negative_button_id);
            negativeButtonBox.method_1868(0xFFFFFF);
            negativeButtonBox.method_1863(string -> {
                try {
                    this.negative_button_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }

        @Override
        public void method_25420(@NotNull class_4587 poseStack) {
            super.method_25420(poseStack);
            int ix = this.guiX + this.left_padding;
            int iy = this.guiY + this.top_padding + 36;
            int w3 = 80;
            this.field_22787.field_1772.method_1729(poseStack, "Joystick ID", (float)ix, (float)iy, this.infoColor);
            this.field_22787.field_1772.method_1729(poseStack, "Button +", (float)(ix + w3 - 1), (float)iy, this.infoColor);
            this.field_22787.field_1772.method_1729(poseStack, "Button -", (float)(ix + w3 * 2 - 2), (float)iy, this.infoColor);
            float scale = 0.8f;
            float startY = (float)(this.guiY + this.top_padding + 70) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            poseStack.method_22903();
            poseStack.method_22905(scale, scale, scale);
            int k = 0;
            for (int j = 0; j < 16; ++j) {
                ByteBuffer buttons;
                if (!GLFW.glfwJoystickPresent((int)j)) continue;
                String name = GLFW.glfwGetJoystickName((int)j);
                if (name == null) {
                    name = "N/A";
                }
                if (ControllerButtonAxis.filterJoystick(name) || (buttons = GLFW.glfwGetJoystickButtons((int)j)) == null) continue;
                for (int b = 0; b < buttons.limit(); ++b) {
                    byte value = buttons.get(b);
                    if (value == 0) continue;
                    String text = name + " | ID:" + j + " | Button:" + b + " | ON";
                    this.field_22787.field_1772.method_1729(poseStack, text, startX, startY + (float)(k * 10), this.infoColor);
                    ++k;
                }
            }
            poseStack.method_22909();
        }

        @Override
        protected ActionInput.Axis createNewInput() {
            return new ActionInput.ControllerButtonAxis(this.joystick_id, this.positive_button_id, this.negative_button_id);
        }
    }

    public static class DSCKeyButton
    extends ButtonScreen {
        private String key_mapping_id = "unbound";

        public DSCKeyButton(int page, ActionInputHolder.Button action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            ActionInput.Button input = (ActionInput.Button)this.getActionInput();
            if (input instanceof ActionInput.DSCKeyButton) {
                ActionInput.DSCKeyButton data = (ActionInput.DSCKeyButton)input;
                this.key_mapping_id = data.key_mapping_id;
            }
            class_342 keyIDBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)keyIDBox, this.ROWS, this.COLUMNS, 2, 2);
            keyIDBox.method_1852(this.key_mapping_id);
            keyIDBox.method_1868(0xFFFFFF);
            keyIDBox.method_1863(string -> {
                if (DSCKeys.hasKey(string)) {
                    this.key_mapping_id = string;
                    keyIDBox.method_1868(65280);
                } else {
                    keyIDBox.method_1868(0xFF0000);
                }
            });
        }

        @Override
        public void method_25420(@NotNull class_4587 poseStack) {
            super.method_25420(poseStack);
            float scale = 0.7f;
            float startY = (float)(this.guiY + this.top_padding + 60) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            float width2 = (float)this.image_width / 2.0f / scale;
            poseStack.method_22903();
            poseStack.method_22905(scale, scale, scale);
            int i = 0;
            Set<String> keys = DSCKeys.getKeyIds();
            for (String key : keys) {
                int color = this.infoColor;
                if (key.equals(this.key_mapping_id)) {
                    color = 65280;
                }
                this.field_22787.field_1772.method_1729(poseStack, key, startX + width2 * (float)(i % 2), startY + (float)(class_3532.method_15375((float)((float)i / 2.0f)) * 10), color);
                ++i;
            }
            poseStack.method_22909();
        }

        @Override
        protected ActionInput.Button createNewInput() {
            return new ActionInput.DSCKeyButton(this.key_mapping_id);
        }
    }

    public static class ControllerButton
    extends ButtonScreen {
        private int joystick_id;
        private int button_id;

        public ControllerButton(int page, ActionInputHolder.Button action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            this.vertical_widget_shift = 18;
            ActionInput.Button input = (ActionInput.Button)this.getActionInput();
            if (input instanceof ActionInput.ControllerButton) {
                ActionInput.ControllerButton data = (ActionInput.ControllerButton)input;
                this.joystick_id = data.joystick_id;
                this.button_id = data.button_id;
            }
            class_342 joystickIDBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)joystickIDBox, this.ROWS, 2, 2, 2);
            joystickIDBox.method_1852("" + this.joystick_id);
            joystickIDBox.method_1868(0xFFFFFF);
            joystickIDBox.method_1863(string -> {
                try {
                    this.joystick_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            class_342 buttonBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)buttonBox, this.ROWS, 2, 3, 2);
            buttonBox.method_1852("" + this.button_id);
            buttonBox.method_1868(0xFFFFFF);
            buttonBox.method_1863(string -> {
                try {
                    this.button_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }

        @Override
        public void method_25420(@NotNull class_4587 poseStack) {
            super.method_25420(poseStack);
            int ix = this.guiX + this.left_padding;
            int iy = this.guiY + this.top_padding + 36;
            int w2 = 120;
            this.field_22787.field_1772.method_1729(poseStack, "Joystick ID", (float)ix, (float)iy, this.infoColor);
            this.field_22787.field_1772.method_1729(poseStack, "Button ID", (float)(ix + w2 - 1), (float)iy, this.infoColor);
            float scale = 0.8f;
            float startY = (float)(this.guiY + this.top_padding + 70) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            poseStack.method_22903();
            poseStack.method_22905(scale, scale, scale);
            int k = 0;
            for (int j = 0; j < 16; ++j) {
                ByteBuffer buttons;
                if (!GLFW.glfwJoystickPresent((int)j)) continue;
                String name = GLFW.glfwGetJoystickName((int)j);
                if (name == null) {
                    name = "N/A";
                }
                if (ControllerButton.filterJoystick(name) || (buttons = GLFW.glfwGetJoystickButtons((int)j)) == null) continue;
                for (int b = 0; b < buttons.limit(); ++b) {
                    byte value = buttons.get(b);
                    if (value == 0) continue;
                    String text = name + " | ID:" + j + " | Button:" + b + " | ON";
                    this.field_22787.field_1772.method_1729(poseStack, text, startX, startY + (float)(k * 10), this.infoColor);
                    ++k;
                }
            }
            poseStack.method_22909();
        }

        @Override
        protected ActionInput.Button createNewInput() {
            return new ActionInput.ControllerButton(this.joystick_id, this.button_id);
        }
    }

    public static class ControllerAxisButton
    extends ButtonScreen {
        private int joystick_id;
        private int axis_id;
        private float dead_zone = 0.1f;
        private boolean positive = true;

        public ControllerAxisButton(int page, ActionInputHolder.Button action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            this.vertical_widget_shift = 18;
            ActionInput.Button input = (ActionInput.Button)this.getActionInput();
            if (input instanceof ActionInput.ControllerAxisButton) {
                ActionInput.ControllerAxisButton data = (ActionInput.ControllerAxisButton)input;
                this.joystick_id = data.joystick_id;
                this.axis_id = data.axis_id;
                this.dead_zone = data.dead_zone;
                this.positive = data.positive;
            }
            class_342 joystickIDBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)joystickIDBox, this.ROWS, 4, 4, 2);
            joystickIDBox.method_1852("" + this.joystick_id);
            joystickIDBox.method_1868(0xFFFFFF);
            joystickIDBox.method_1863(string -> {
                try {
                    this.joystick_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            class_342 axisIDBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)axisIDBox, this.ROWS, 4, 5, 2);
            axisIDBox.method_1852("" + this.axis_id);
            axisIDBox.method_1868(0xFFFFFF);
            axisIDBox.method_1863(string -> {
                try {
                    this.axis_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            class_342 deadZoneBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
            this.positionWidgetGrid((class_339)deadZoneBox, this.ROWS, 4, 6, 2);
            deadZoneBox.method_1852("" + this.dead_zone);
            deadZoneBox.method_1868(0xFFFFFF);
            deadZoneBox.method_1863(string -> {
                try {
                    this.dead_zone = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.positionWidgetGrid((class_339)new class_4286(0, 0, 20, 20, (class_2561)UtilMCText.literal((String)""), this.positive){

                public void method_25306() {
                    super.method_25306();
                    positive = !positive;
                }
            }, this.ROWS, 4, 7, 2);
        }

        @Override
        public void method_25420(@NotNull class_4587 poseStack) {
            super.method_25420(poseStack);
            int ix = this.guiX + this.left_padding;
            int iy = this.guiY + this.top_padding + 36;
            int w4 = 60;
            this.field_22787.field_1772.method_1729(poseStack, "Joystick ID", (float)ix, (float)iy, this.infoColor);
            this.field_22787.field_1772.method_1729(poseStack, "Axis ID", (float)(ix + w4 - 1), (float)iy, this.infoColor);
            this.field_22787.field_1772.method_1729(poseStack, "Dead Zone", (float)(ix + w4 * 2 - 2), (float)iy, this.infoColor);
            this.field_22787.field_1772.method_1729(poseStack, "Positive", (float)(ix + w4 * 3 - 3), (float)iy, this.infoColor);
            float scale = 0.8f;
            float startY = (float)(this.guiY + this.top_padding + 70) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            poseStack.method_22903();
            poseStack.method_22905(scale, scale, scale);
            int k = 0;
            for (int j = 0; j < 16; ++j) {
                FloatBuffer axes;
                if (!GLFW.glfwJoystickPresent((int)j)) continue;
                String name = GLFW.glfwGetJoystickName((int)j);
                if (name == null) {
                    name = "N/A";
                }
                if (ControllerAxisButton.filterJoystick(name) || (axes = GLFW.glfwGetJoystickAxes((int)j)) == null) continue;
                for (int a = 0; a < axes.limit(); ++a) {
                    float value = axes.get(a);
                    if (class_3532.method_15379((float)value) < 0.1f) continue;
                    String text = name + " | ID:" + j + " | Axis:" + a + " | " + value;
                    this.field_22787.field_1772.method_1729(poseStack, text, startX, startY + (float)(k * 10), this.infoColor);
                    ++k;
                }
            }
            poseStack.method_22909();
        }

        @Override
        protected ActionInput.Button createNewInput() {
            return new ActionInput.ControllerAxisButton(this.joystick_id, this.axis_id, this.dead_zone, this.positive);
        }
    }
}

