/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.texture;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.data.vehicle.VehicleTextureManager;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.slf4j.Logger;

public class VehicleDynamicTextures {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static class_2960 createVehicleDynamicTexture(EntityVehicle vehicle) {
        class_1011 baseImage;
        class_2960 baseTexLoc = vehicle.textureManager.getBaseTexture();
        if (vehicle.textureManager.isAllLayersDisabled()) {
            return baseTexLoc;
        }
        class_310 m = class_310.method_1551();
        try {
            InputStream stream = ((class_3298)m.method_1478().method_14486(baseTexLoc).get()).method_14482();
            baseImage = class_1011.method_4309((InputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return baseTexLoc;
        }
        class_1043 dynText = new class_1043(baseImage);
        VehicleTextureManager.TextureLayer[] layers = vehicle.textureManager.getTextureLayers();
        for (int i = 0; i < layers.length; ++i) {
            class_1011 layerImage;
            if (!layers[i].canRender()) continue;
            try {
                InputStream stream = ((class_3298)m.method_1478().method_14486(layers[i].getTexture()).get()).method_14482();
                layerImage = class_1011.method_4309((InputStream)stream);
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            if (dynText.method_4525().method_4307() != layerImage.method_4307() || dynText.method_4525().method_4323() != layerImage.method_4323()) {
                LOGGER.error(String.valueOf(baseTexLoc) + " and " + String.valueOf(layers[i].getTexture()) + " do not have the same dimensions! This layer will not render!");
                continue;
            }
            float blend = VehicleDynamicTextures.calcBlend(layers[i]);
            for (int x = 0; x < layerImage.method_4307(); ++x) {
                for (int y = 0; y < layerImage.method_4323(); ++y) {
                    int textureColor = layerImage.method_4315(x, y);
                    if (class_1011.method_24030((int)textureColor) == 0) continue;
                    dynText.method_4525().method_4305(x, y, VehicleDynamicTextures.blendColors(textureColor, layers[i], blend));
                }
            }
        }
        dynText.method_4524();
        class_2960 textLoc = new class_2960("dscombat", "vehicle_layers_" + vehicle.method_5628());
        m.method_1531().method_4616(textLoc, (class_1044)dynText);
        return textLoc;
    }

    private static int blendColors(int textureColor, VehicleTextureManager.TextureLayer layer, float blend) {
        int red = class_1011.method_24033((int)textureColor);
        int green = class_1011.method_24034((int)textureColor);
        int blue = class_1011.method_24035((int)textureColor);
        if (blend == 0.0f || layer.getBlendMode() == VehicleTextureManager.BlendMode.ON_WHITE && red == 255 && green == 255 && blue == 255) {
            return class_1011.method_24031((int)255, (int)layer.getColor().getBlue(), (int)layer.getColor().getGreen(), (int)layer.getColor().getRed());
        }
        if (blend == 1.0f) {
            return textureColor;
        }
        return class_1011.method_24031((int)255, (int)VehicleDynamicTextures.blendColorChannel(blue, layer.getColor().getBlue(), blend), (int)VehicleDynamicTextures.blendColorChannel(green, layer.getColor().getGreen(), blend), (int)VehicleDynamicTextures.blendColorChannel(red, layer.getColor().getRed(), blend));
    }

    private static int blendColorChannel(int c1, int c2, float blend) {
        return Math.round((float)c1 * blend + (1.0f - blend) * (float)c2);
    }

    private static float calcBlend(VehicleTextureManager.TextureLayer layer) {
        switch (layer.getBlendMode()) {
            case EVEN: {
                return 0.5f;
            }
            case NONE: {
                return 1.0f;
            }
            case ON_ALL: {
                return 0.0f;
            }
            case ON_WHITE: {
                return 1.0f;
            }
            case SCALED: {
                Color color = layer.getColor();
                float f = 0.0013071896f;
                return (float)color.getRed() * f + (float)color.getGreen() * f + (float)color.getBlue() * f;
            }
        }
        return 0.0f;
    }
}

