/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.onewhohears.dscombat.command.argument.VehiclePresetArgument;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class WindTunnelCommand {
    public WindTunnelCommand(CommandDispatcher<class_2168> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"windtunnel").requires(stack -> stack.method_9259(2))).then(class_2170.method_9247((String)"set_all").then(class_2170.method_9244((String)"preset", (ArgumentType)VehiclePresetArgument.vehiclePreset()).then(class_2170.method_9244((String)"speed", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"throttle", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(class_2170.method_9244((String)"afterburner", (ArgumentType)BoolArgumentType.bool()).executes((context, tunnel) -> this.setWindTunnelCommand((CommandContext<class_2168>)context, tunnel, VehiclePresetArgument.getVehiclePreset((CommandContext<class_2168>)context, "preset"), class_2277.method_9736((CommandContext)context, (String)"speed"), class_2277.method_9736((CommandContext)context, (String)"rotation"), FloatArgumentType.getFloat((CommandContext)context, (String)"throttle"), BoolArgumentType.getBool((CommandContext)context, (String)"afterburner")))))))))).then(class_2170.method_9247((String)"set_hidden").then(class_2170.method_9244((String)"hidden", (ArgumentType)BoolArgumentType.bool()).executes((context, tunnel) -> this.setVehicleHidden((CommandContext<class_2168>)context, tunnel, BoolArgumentType.getBool((CommandContext)context, (String)"hidden")))))).then(class_2170.method_9247((String)"set_altitude").then(class_2170.method_9244((String)"altitude", (ArgumentType)FloatArgumentType.floatArg((float)-1000.0f, (float)10000.0f)).executes((context, tunnel) -> this.setVehicleAltitude((CommandContext<class_2168>)context, tunnel, FloatArgumentType.getFloat((CommandContext)context, (String)"altitude")))))).then(class_2170.method_9247((String)"set_inputs").then(class_2170.method_9244((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)-1.0f, (float)1.0f)).then(class_2170.method_9244((String)"yaw", (ArgumentType)FloatArgumentType.floatArg((float)-1.0f, (float)1.0f)).then(class_2170.method_9244((String)"roll", (ArgumentType)FloatArgumentType.floatArg((float)-1.0f, (float)1.0f)).executes((context, tunnel) -> this.setVehicleInputs((CommandContext<class_2168>)context, tunnel, FloatArgumentType.getFloat((CommandContext)context, (String)"pitch"), FloatArgumentType.getFloat((CommandContext)context, (String)"yaw"), FloatArgumentType.getFloat((CommandContext)context, (String)"roll")))))))).then(class_2170.method_9247((String)"find_lift_drag").then(class_2170.method_9244((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1000.0f)).then(class_2170.method_9244((String)"turn_rate", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1000.0f)).then(class_2170.method_9244((String)"aoa", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)90.0f)).then(class_2170.method_9244((String)"altitude", (ArgumentType)FloatArgumentType.floatArg((float)-64.0f, (float)10000.0f)).executes((context, tunnel) -> this.findLiftDrag((CommandContext<class_2168>)context, tunnel, FloatArgumentType.getFloat((CommandContext)context, (String)"speed"), FloatArgumentType.getFloat((CommandContext)context, (String)"turn_rate"), FloatArgumentType.getFloat((CommandContext)context, (String)"aoa"), FloatArgumentType.getFloat((CommandContext)context, (String)"altitude"))))))))).then(class_2170.method_9247((String)"set_preset").then(class_2170.method_9244((String)"preset", (ArgumentType)VehiclePresetArgument.vehiclePreset()).executes((context, tunnel) -> this.setPresetCommand((CommandContext<class_2168>)context, tunnel, VehiclePresetArgument.getVehiclePreset((CommandContext<class_2168>)context, "preset")))))).then(class_2170.method_9247((String)"set_speed_list").then(class_2170.method_9244((String)"speed_list", (ArgumentType)StringArgumentType.string()).executes((context, tunnel) -> this.setSpeedList((CommandContext<class_2168>)context, tunnel, StringArgumentType.getString((CommandContext)context, (String)"speed_list")))))).then(class_2170.method_9247((String)"set_aoa_list").then(class_2170.method_9244((String)"aoa_list", (ArgumentType)StringArgumentType.string()).executes((context, tunnel) -> this.setAOAList((CommandContext<class_2168>)context, tunnel, StringArgumentType.getString((CommandContext)context, (String)"aoa_list")))))).then(class_2170.method_9247((String)"set_turn_rate_list").then(class_2170.method_9244((String)"turn_rate_list", (ArgumentType)StringArgumentType.string()).executes((context, tunnel) -> this.setTurnRateList((CommandContext<class_2168>)context, tunnel, StringArgumentType.getString((CommandContext)context, (String)"turn_rate_list")))))).then(class_2170.method_9247((String)"find_multi_lift_drag").then(class_2170.method_9244((String)"altitude", (ArgumentType)FloatArgumentType.floatArg((float)-64.0f, (float)10000.0f)).executes((context, tunnel) -> this.findMultiLiftDrag((CommandContext<class_2168>)context, tunnel, FloatArgumentType.getFloat((CommandContext)context, (String)"altitude"))))));
    }

    private int findMultiLiftDrag(CommandContext<class_2168> context, EntityWindTunnel tunnel, float altitude) {
        tunnel.startFindMultiLiftDragJob(altitude);
        return 1;
    }

    private int setSpeedList(CommandContext<class_2168> context, EntityWindTunnel tunnel, String list) {
        tunnel.setSpeedList(WindTunnelCommand.parseNumList(list));
        return 1;
    }

    private int setAOAList(CommandContext<class_2168> context, EntityWindTunnel tunnel, String list) {
        tunnel.setAOAList(WindTunnelCommand.parseNumList(list));
        return 1;
    }

    private int setTurnRateList(CommandContext<class_2168> context, EntityWindTunnel tunnel, String list) {
        tunnel.setTurnRateList(WindTunnelCommand.parseNumList(list));
        return 1;
    }

    public static double[] parseNumList(String string_list) {
        String[] split = string_list.split(";");
        double[] num_list = new double[split.length];
        for (int i = 0; i < split.length; ++i) {
            try {
                num_list[i] = Double.parseDouble(split[i]);
                continue;
            }
            catch (NumberFormatException e) {
                num_list[i] = 0.0;
            }
        }
        return num_list;
    }

    private int findLiftDrag(CommandContext<class_2168> context, EntityWindTunnel tunnel, float speed, float turn_rate, float aoa, float altitude) {
        tunnel.startFindLiftDragJob(speed, turn_rate, aoa, altitude);
        return 1;
    }

    private int setWindTunnelCommand(CommandContext<class_2168> context, EntityWindTunnel tunnel, @Nullable VehicleStats preset, @Nullable class_243 speed, @Nullable class_243 rotation, float throttle, boolean afterburner) {
        if (preset != null) {
            tunnel.setPreset(preset.getId());
        }
        if (speed != null) {
            tunnel.setSpeed(speed);
        }
        if (rotation != null) {
            tunnel.setQ(UtilAngles.toQuaternionF((double)rotation.field_1351, (double)rotation.field_1352, (double)rotation.field_1350));
        }
        if (throttle >= 0.0f) {
            tunnel.setThrottle(throttle);
        }
        tunnel.setAfterBurner(afterburner);
        return 1;
    }

    private int setPresetCommand(CommandContext<class_2168> context, EntityWindTunnel tunnel, @Nullable VehicleStats preset) {
        if (preset != null) {
            tunnel.setPreset(preset.getId());
        }
        return 1;
    }

    private int setVehicleHidden(CommandContext<class_2168> context, EntityWindTunnel tunnel, boolean hidden) {
        tunnel.setHideModel(hidden);
        return 1;
    }

    private int setVehicleAltitude(CommandContext<class_2168> context, EntityWindTunnel tunnel, float altitude) {
        tunnel.setAltitude(altitude);
        return 1;
    }

    private int setVehicleInputs(CommandContext<class_2168> context, EntityWindTunnel tunnel, float pitch, float yaw, float roll) {
        tunnel.setInputs(new class_243((double)pitch, (double)yaw, (double)roll));
        return 1;
    }

    private static Optional<EntityWindTunnel> getWindTunnel(CommandContext<class_2168> context) {
        return UtilVehicleEntity.findWindTunnel(((class_2168)context.getSource()).method_9222(), (class_1937)((class_2168)context.getSource()).method_9225());
    }

    public static interface IWindTunnelCommand
    extends Command<class_2168> {
        default public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
            Optional<EntityWindTunnel> opt = WindTunnelCommand.getWindTunnel(context);
            if (opt.isEmpty()) {
                ((class_2168)context.getSource()).method_9213((class_2561)UtilMCText.literal((String)"No Wind Tunnels within 16 blocks found!"));
                return 0;
            }
            return this.run(context, opt.get());
        }

        public int run(CommandContext<class_2168> var1, EntityWindTunnel var2) throws CommandSyntaxException;
    }
}

