/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.util.UtilItem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PartItemLoadRecipe<I extends ReloadablePartInstance>
extends class_1852 {
    protected PartItemLoadRecipe(class_2960 id) {
        super(id);
    }

    public boolean matches(class_1715 container, class_1937 level) {
        if (this.hasOutlier(container)) {
            return false;
        }
        class_1799 part = this.getPartItem(container);
        if (part == null) {
            return false;
        }
        if (part.method_7947() > 1) {
            return false;
        }
        List<class_1799> ammo = this.getAmmoItems(container);
        I lpd = this.getLoadablePartDataFromItem(part);
        return this.canItemsCombine((ReloadablePartInstance)lpd, ammo);
    }

    public class_1799 assemble(class_1715 container) {
        class_1799 part = this.getPartItem(container);
        I lpd = this.getLoadablePartDataFromItem(part);
        if (this.fillPart((class_1263)container, (ReloadablePartInstance)lpd)) {
            return lpd.getNewItemStack();
        }
        return class_1799.field_8037;
    }

    public boolean fillPart(class_1263 container, ReloadablePartInstance lpd) {
        List<class_1799> ammo = this.getAmmoItemsContainer(container, null);
        if (!this.canItemsCombine(lpd, ammo)) {
            return false;
        }
        if (this.checkAmmoContinuity()) {
            String ammoCont = this.getItemAmmoContinuity(ammo.get(0));
            if (!this.isContinuityValid(ammoCont)) {
                return false;
            }
            this.emptyContinuityCheck(lpd, ammoCont);
        }
        float newAmmo = lpd.getCurrentAmmo();
        for (int i = 0; i < ammo.size(); ++i) {
            newAmmo += this.getAmmoNumFromItem(ammo.get(i));
        }
        if (newAmmo > lpd.getMaxAmmo()) {
            newAmmo = lpd.getMaxAmmo();
        }
        lpd.setCurrentAmmo(newAmmo);
        return true;
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(@NotNull class_1715 container) {
        class_1799 part = this.getPartItem(container);
        I lpd = this.getLoadablePartDataFromItem(part);
        return this.getRemainingItems((class_1263)container, lpd);
    }

    public class_2371<class_1799> getRemainingItems(class_1263 container, I lpd) {
        if (!this.consumeAmmoItems(container, (ReloadablePartInstance)lpd)) {
            return this.getRemainingItemsDefault(container);
        }
        class_2371 list = class_2371.method_10213((int)container.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < list.size(); ++i) {
            class_1799 stack = container.method_5438(i);
            list.set(i, (Object)UtilItem.getCraftingRemainingItem((class_1799)stack));
        }
        return list;
    }

    public boolean consumeAmmoItems(class_1263 container, ReloadablePartInstance lpd) {
        List<class_1799> ammo = this.getAmmoItemsContainer(container, null);
        if (!this.canItemsCombine(lpd, ammo)) {
            return false;
        }
        if (this.checkAmmoContinuity()) {
            String ammoCont = this.getItemAmmoContinuity(ammo.get(0));
            if (!this.isContinuityValid(ammoCont)) {
                return false;
            }
            this.emptyContinuityCheck(lpd, ammoCont);
        }
        float ca = lpd.getCurrentAmmo();
        float ma = lpd.getMaxAmmo();
        for (int i = 0; i < ammo.size(); ++i) {
            float c = this.getAmmoNumFromItem(ammo.get(i));
            float t = ca + c;
            if (t <= ma) {
                this.setAmmoNumForItem(ammo.get(i), 0.0f);
                ca += c;
                continue;
            }
            if (t > ma && ca != ma) {
                this.setAmmoNumForItem(ammo.get(i), t - ma);
                ca = ma;
                continue;
            }
            this.setAmmoNumForItem(ammo.get(i), c);
        }
        return true;
    }

    public void reloadFromInventory(class_1661 inventory, ReloadablePartInstance lpd) {
        float newAmmo;
        String continuity = lpd.getContinuity();
        if (lpd.updateContinuityIfEmpty() && lpd.isContinuityEmpty()) {
            continuity = null;
        }
        if ((newAmmo = lpd.getCurrentAmmo()) >= lpd.getMaxAmmo()) {
            return;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            float ammo;
            float remain;
            class_1799 stack = inventory.method_5438(i).method_7972();
            if (stack.method_7960() || !this.isItemAmmo(stack)) continue;
            if (this.checkAmmoContinuity()) {
                String stackCont = this.getItemAmmoContinuity(stack);
                if (continuity == null && this.isContinuityValid(stackCont) && lpd.isCompatibleWithAmmoContinuity(stackCont)) {
                    continuity = stackCont;
                } else if (!stackCont.equals(continuity)) continue;
            }
            if ((remain = (newAmmo += (ammo = this.getAmmoNumFromItem(stack))) - lpd.getMaxAmmo()) <= 0.0f) {
                inventory.method_5447(i, class_1799.field_8037);
            } else {
                this.setAmmoNumForItem(stack, remain, false);
                inventory.method_5447(i, stack);
            }
            if (!(newAmmo >= lpd.getMaxAmmo())) continue;
            newAmmo = lpd.getMaxAmmo();
            break;
        }
        if (continuity != null && !continuity.equals(lpd.getContinuity())) {
            lpd.setContinuity(continuity);
        }
        lpd.setCurrentAmmo(newAmmo);
    }

    public float getAmmoNumFromItem(class_1799 ammo) {
        switch (this.getAmmoLoadType().ordinal()) {
            case 0: {
                return ammo.method_7947();
            }
            case 1: {
                return ammo.method_7936() - ammo.method_7919();
            }
        }
        return 0.0f;
    }

    public void setAmmoNumForItem(class_1799 ammo, float num) {
        this.setAmmoNumForItem(ammo, num, true);
    }

    public void setAmmoNumForItem(class_1799 ammo, float num, boolean add1) {
        switch (this.getAmmoLoadType().ordinal()) {
            case 0: {
                ammo.method_7939((int)num + (add1 ? 1 : 0));
                break;
            }
            case 1: {
                ammo.method_7974(ammo.method_7936() - (int)num);
                if (!add1) break;
                ammo.method_7939(2);
            }
        }
    }

    private void emptyContinuityCheck(ReloadablePartInstance lpd, String ammoCont) {
        if (lpd.updateContinuityIfEmpty() && lpd.isContinuityEmpty()) {
            lpd.setContinuity(ammoCont);
            lpd.setCurrentAmmo(0.0f);
            lpd.setMaxAmmo(this.getContinuityMaxAmmo(lpd, ammoCont));
        }
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public boolean method_8118() {
        return true;
    }

    public boolean hasOutlier(class_1715 container) {
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960() || !this.isOutlier(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutlier(class_1799 stack) {
        return !this.isLoadablePartItem(stack) && !this.isItemAmmo(stack);
    }

    @Nullable
    public class_1799 getPartItem(class_1715 container, AtomicInteger index) {
        class_1799 part = null;
        index.set(-1);
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960() || !this.isLoadablePartItem(stack)) continue;
            if (part != null) {
                return null;
            }
            part = stack;
            index.set(i);
        }
        return part;
    }

    @Nullable
    public class_1799 getPartItem(class_1715 container) {
        return this.getPartItem(container, new AtomicInteger());
    }

    @Nullable
    protected I getLoadablePartDataFromItem(class_1799 part) {
        if (part == null) {
            return null;
        }
        PartInstance<?> pd = UtilPresetParse.parsePartFromItem(part);
        if (pd == null) {
            return null;
        }
        return (I)((ReloadablePartInstance)((Object)pd));
    }

    @Nullable
    public List<class_1799> getAmmoItems(class_1715 container) {
        return this.getAmmoItemsContainer((class_1263)container, null);
    }

    @Nullable
    public List<class_1799> getAmmoItemsContainer(class_1263 container, String continuity) {
        ArrayList<class_1799> ammo = new ArrayList<class_1799>();
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960() || !this.isItemAmmo(stack)) continue;
            if (this.checkAmmoContinuity()) {
                String stackCont = this.getItemAmmoContinuity(stack);
                if (continuity == null) {
                    continuity = stackCont;
                } else if (!stackCont.equals(continuity)) continue;
            }
            ammo.add(stack);
        }
        return ammo;
    }

    public float getAmmoNum(class_1263 container, String continuity) {
        float num = 0.0f;
        List<class_1799> ammos = this.getAmmoItemsContainer(container, continuity);
        if (ammos == null) {
            return 0.0f;
        }
        for (class_1799 ammo : ammos) {
            num += this.getAmmoNumFromItem(ammo);
        }
        return num;
    }

    public abstract boolean isLoadablePartItem(class_1799 var1);

    public abstract boolean isItemAmmo(class_1799 var1);

    public abstract boolean checkAmmoContinuity();

    public abstract String getItemAmmoContinuity(class_1799 var1);

    public abstract boolean isContinuityValid(String var1);

    public abstract int getContinuityMaxAmmo(I var1, String var2);

    public boolean canItemsCombine(ReloadablePartInstance lpd, List<class_1799> ammo) {
        if (lpd == null || ammo == null || ammo.isEmpty()) {
            return false;
        }
        if (this.checkAmmoContinuity()) {
            String ammoCont = this.getItemAmmoContinuity(ammo.get(0));
            if (!this.isContinuityValid(ammoCont)) {
                return false;
            }
            if (!lpd.isCompatibleWithAmmoContinuity(ammoCont)) {
                return false;
            }
            if (lpd.updateContinuityIfEmpty() && lpd.isContinuityEmpty()) {
                return true;
            }
            return lpd.getContinuity().equals(ammoCont);
        }
        System.out.println("can combine");
        return true;
    }

    public AmmoLoadType getAmmoLoadType() {
        return AmmoLoadType.ITEM_COUNT;
    }

    protected class_2371<class_1799> getRemainingItemsDefault(class_1263 pContainer) {
        class_2371 nonnulllist = class_2371.method_10213((int)pContainer.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            class_1799 item = pContainer.method_5438(i);
            if (!UtilItem.hasCraftingRemainingItem((class_1799)item)) continue;
            nonnulllist.set(i, (Object)UtilItem.getCraftingRemainingItem((class_1799)item));
        }
        return nonnulllist;
    }

    public static enum AmmoLoadType {
        ITEM_COUNT,
        ITEM_DURABILITY;

    }
}

