/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.crafting.FuelTankLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemUnloadRecipe;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.data.parts.stats.FuelTankStats;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class FuelTankInstance<T extends FuelTankStats>
extends PartInstance<T>
implements ReloadablePartInstance {
    private float fuel = 0.0f;
    private static final PartItemLoadRecipe<?> LOAD_RECIPE = new FuelTankLoadRecipe(new class_2960("dscombat:fuel_tank_load_recipe"));

    public FuelTankInstance(T stats) {
        super(stats);
    }

    @Override
    public void setFilled(String param) {
        super.setFilled(param);
        this.fuel = ((FuelTankStats)this.getStats()).getMaxFuel();
    }

    @Override
    public float getWeight() {
        float w = super.getWeight();
        return w + this.fuel * DSCPhyCons.getFuelKgPerLiter();
    }

    public float getFuel() {
        return this.fuel;
    }

    @Override
    public void readNBT(class_2487 tag) {
        super.readNBT(tag);
        this.fuel = tag.method_10583("fuel");
    }

    @Override
    public class_2487 writeNBT() {
        class_2487 tag = super.writeNBT();
        tag.method_10548("fuel", this.fuel);
        return tag;
    }

    @Override
    public void readBuffer(class_2540 buffer) {
        super.readBuffer(buffer);
        this.fuel = buffer.readFloat();
    }

    @Override
    public void writeBuffer(class_2540 buffer) {
        super.writeBuffer(buffer);
        buffer.writeFloat(this.fuel);
    }

    public float addFuel(float fuel) {
        float max = ((FuelTankStats)this.getStats()).getMaxFuel();
        this.fuel += fuel;
        if (this.fuel < 0.0f) {
            float r = this.fuel;
            this.fuel = 0.0f;
            return r;
        }
        if (this.fuel > max) {
            float r = this.fuel - max;
            this.fuel = max;
            return r;
        }
        this.setDirty();
        return 0.0f;
    }

    public void setFuel(float fuel) {
        float max = ((FuelTankStats)this.getStats()).getMaxFuel();
        if (fuel > max) {
            fuel = max;
        } else if (fuel < 0.0f) {
            fuel = 0.0f;
        }
        this.fuel = fuel;
        this.setDirty();
    }

    @Override
    public float getCurrentAmmo() {
        return this.getFuel();
    }

    @Override
    public float getMaxAmmo() {
        return this.getMaxFuel();
    }

    @Override
    public void setCurrentAmmo(float ammo) {
        this.setFuel(ammo);
    }

    @Override
    public void setMaxAmmo(float max) {
    }

    @Override
    public boolean isCompatibleWithAmmoContinuity(String continuity) {
        return true;
    }

    @Override
    public boolean updateContinuityIfEmpty() {
        return false;
    }

    @Override
    public void setContinuity(String continuity) {
    }

    @Override
    public String getContinuity() {
        return "";
    }

    @Override
    public PartItemLoadRecipe<?> getLoadRecipe() {
        return LOAD_RECIPE;
    }

    @Override
    @Nullable
    public PartItemUnloadRecipe<?> getUnloadRecipe() {
        return null;
    }

    @Override
    public void addToolTips(List<class_2561> tips, class_1836 isAdvanced) {
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.fuel").method_27693(": " + (int)this.fuel + "/" + (int)((FuelTankStats)this.getStats()).getMaxFuel()).method_10862(class_2583.field_24360.method_36139(0xAAAAAA)));
        super.addToolTips(tips, isAdvanced);
    }

    @Override
    public float getCurrentFuel() {
        return this.getFuel();
    }

    @Override
    public float getMaxFuel() {
        return ((FuelTankStats)this.getStats()).getMaxFuel();
    }

    @Override
    public void tick(String slotId) {
        super.tick(slotId);
        if (this.isDamaged()) {
            this.addFuel(-0.06f);
        }
    }
}

