/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.data.parts.SlotType;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.data.crafting.IngredientStack;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PartInstance<T extends PartStats>
extends JsonPresetInstance<T> {
    public static final int PARSE_VERSION = 3;
    protected boolean isSetup = false;
    private String slotId = "";
    private class_243 relPos = class_243.field_1353;
    private EntityVehicle parent;
    private boolean damaged;
    private boolean dirty;

    public PartInstance(T stats) {
        super(stats);
    }

    public void setFilled(String param) {
    }

    public void setParamNotFilled(String param) {
    }

    public void readNBT(class_2487 tag) {
        super.readNBT(tag);
        this.damaged = tag.method_10577("damaged");
    }

    public class_2487 writeNBT() {
        class_2487 tag = super.writeNBT();
        tag.method_10556("readnbt", true);
        tag.method_10569("parse_version", 3);
        tag.method_10582("part", this.getStatsId());
        tag.method_10556("damaged", this.damaged);
        return tag;
    }

    public void readBuffer(class_2540 buffer) {
        this.damaged = buffer.readBoolean();
    }

    public void writeBuffer(class_2540 buffer) {
        buffer.method_10814(((PartStats)this.getStats()).getId());
        buffer.writeBoolean(this.damaged);
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void onReceiveClientSync() {
        this.dirty = false;
    }

    public void onSendClientSync() {
        this.dirty = false;
    }

    public int getFlares() {
        return 0;
    }

    public float getWeight() {
        return ((PartStats)this.getStats()).getWeight();
    }

    public EntityVehicle getParent() {
        return this.parent;
    }

    public class_243 getRelPos() {
        return this.relPos;
    }

    protected void setParent(EntityVehicle parent) {
        this.parent = parent;
    }

    protected void setRelPos(class_243 pos) {
        this.relPos = pos;
    }

    public String getSlotId() {
        return this.slotId;
    }

    protected void setSlotId(String id) {
        this.slotId = id;
    }

    protected void serverSetup(EntityVehicle craft, String slotId, class_243 pos) {
        if (this.hasExternalEntity() && !this.isDamaged()) {
            this.addEntity(craft, slotId, pos);
        }
    }

    protected void clientSetup(EntityVehicle craft, String slotId, class_243 pos) {
    }

    public boolean canSetup() {
        return !this.isDamagedPreventsSetup() || !this.isDamaged();
    }

    public boolean isDamagedPreventsSetup() {
        return true;
    }

    public void setup(EntityVehicle craft, String slotId, class_243 pos) {
        this.setSlotId(slotId);
        this.setParent(craft);
        this.setRelPos(pos);
        if (craft.isClientSide()) {
            this.clientSetup(craft, slotId, pos);
        } else {
            this.serverSetup(craft, slotId, pos);
        }
        this.isSetup = true;
    }

    protected void serverRemove(String slotId) {
        if (this.hasExternalEntity()) {
            this.removeEntity(slotId);
        }
    }

    protected void clientRemove(String slotId) {
    }

    public void remove(EntityVehicle parent, String slotId) {
        if (parent.isClientSide()) {
            this.clientRemove(slotId);
        } else {
            this.serverRemove(slotId);
        }
        this.isSetup = false;
    }

    public void tick(String slotId) {
    }

    public void clientTick(String slotId) {
    }

    public class_1799 getNewItemStack() {
        class_1799 s = ((PartStats)this.getStats()).getItem().method_7854();
        s.method_7980(this.writeNBT());
        return s;
    }

    public boolean isEntitySetup(String slotId, EntityVehicle craft) {
        for (EntityPart part : craft.getPartEntities()) {
            if (!part.getPartType().is(((PartStats)this.getStats()).getType()) || !part.getSlotId().equals(slotId)) continue;
            return true;
        }
        return false;
    }

    public void removeEntity(String slotId) {
        if (this.getParent() == null) {
            return;
        }
        for (EntityPart part : this.getParent().getPartEntities()) {
            if (!part.getSlotId().equals(slotId)) continue;
            part.method_31472();
        }
    }

    public void addEntity(EntityVehicle craft, String slotId, class_243 pos) {
        if (this.isEntitySetup(slotId, craft)) {
            return;
        }
        EntityPart part = this.createEntity(craft, slotId);
        if (part == null) {
            return;
        }
        this.setUpPartEntity(part, craft, slotId, pos, ((PartStats)this.getStats()).getExternalEntityDefaultHealth());
        craft.getWorld().method_8649((class_1297)part);
    }

    @Nullable
    protected EntityPart createEntity(EntityVehicle vehicle, String slotId) {
        return (EntityPart)((PartStats)this.getStats()).getExernalEntityType().method_5883(vehicle.getWorld());
    }

    public void setUpPartEntity(EntityPart part, EntityVehicle craft, String slotId, class_243 pos, float health) {
        part.setPreset(this.getStatsId());
        part.setSlotId(slotId);
        part.setRelativePos(pos);
        part.method_33574(craft.method_19538());
        part.setHealth(health);
        part.method_5804((class_1297)craft);
    }

    public boolean isCompatible(SlotType type) {
        return ((PartStats)this.getStats()).isCompatible(type);
    }

    public boolean isDamaged() {
        return this.damaged;
    }

    protected void setDamaged(boolean damaged) {
        this.damaged = damaged;
        this.setDirty();
    }

    public void onDamaged(EntityVehicle parent, String slotId) {
        this.setDamaged(true);
        this.remove(parent, slotId);
    }

    public void onRepaired(EntityVehicle parent, String slotId, class_243 pos) {
        this.setDamaged(false);
        if (this.canSetup()) {
            this.setup(parent, slotId, pos);
        }
    }

    public void addToolTips(List<class_2561> tips, class_1836 isAdvanced) {
        if (this.isDamaged()) {
            tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.damaged").method_10862(class_2583.field_24360.method_36139(0xCC0000)));
            if (!((PartStats)this.getStats()).getRepairCost().isEmpty()) {
                class_2583 repairStyle = class_2583.field_24360.method_36139(0xE88888);
                class_5250 repairCost = UtilMCText.translatable((String)"info.dscombat.repair_cost").method_27693(": ").method_10862(repairStyle);
                for (class_1856 cost : ((PartStats)this.getStats()).getRepairCost()) {
                    int num = 1;
                    if (cost instanceof IngredientStack) {
                        IngredientStack is = (IngredientStack)cost;
                        num = is.cost;
                    }
                    repairCost.method_10852(cost.method_8105()[0].method_7954()).method_27693("(" + num + ")");
                }
                tips.add((class_2561)repairCost);
            }
        }
        ((PartStats)this.getStats()).addToolTips(tips, isAdvanced);
    }

    public class_5250 getItemName() {
        return ((PartStats)this.getStats()).getDisplayNameComponent().method_10862(class_2583.field_24360.method_36139(0x55FF55));
    }

    public boolean hasExternalEntity() {
        return ((PartStats)this.getStats()).hasExternalEntity();
    }

    public float getPushThrust(VehicleStats vehicleStats) {
        return 0.0f;
    }

    public float getSpinThrust(VehicleStats vehicleStats) {
        return 0.0f;
    }

    public float getEngineHeat(VehicleStats vehicleStats) {
        return 0.0f;
    }

    public float getFuelPerTick(VehicleStats vehicleStats) {
        return 0.0f;
    }

    public float getCurrentFuel() {
        return 0.0f;
    }

    public float getMaxFuel() {
        return 0.0f;
    }

    public boolean canJetesin() {
        return this.hasExternalEntity() && !((PartStats)this.getStats()).isSeat();
    }

    public boolean isSetup() {
        return this.isSetup;
    }

    public class_243 getRotInertia() {
        if (this.parent == null || UtilGeometry.isZero((class_243)this.relPos)) {
            return class_243.field_1353;
        }
        return new class_243((double)this.getWeight() * (this.relPos.field_1351 * this.relPos.field_1351 + this.relPos.field_1350 * this.relPos.field_1350), (double)this.getWeight() * (this.relPos.field_1352 * this.relPos.field_1352 + this.relPos.field_1350 * this.relPos.field_1350), (double)this.getWeight() * (this.relPos.field_1352 * this.relPos.field_1352 + this.relPos.field_1351 * this.relPos.field_1351)).method_1021(0.5);
    }

    public float getAfterburnerMaxPushThrust(@NotNull VehicleStats stats) {
        return 0.0f;
    }
}

