/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.radar;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.weapon.NonTickingMissileManager;
import com.onewhohears.dscombat.data.weapon.RadarTargetTypes;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class RadarInstance<T extends RadarStats>
extends JsonPresetInstance<T> {
    private String slotId = "";
    private class_243 pos = class_243.field_1353;
    private boolean freshTargets;
    private int scanTicks;
    private final List<RadarStats.RadarPing> pings = new ArrayList<RadarStats.RadarPing>();
    private int maxCheckDist = 150;

    public RadarInstance(T stats) {
        super(stats);
    }

    public void readNBT(class_2487 tag) {
        super.readNBT(tag);
        this.setSlot(tag.method_10558("slotId"));
    }

    public class_2487 writeNBT() {
        class_2487 tag = super.writeNBT();
        tag.method_10582("slotId", this.slotId);
        return tag;
    }

    public void resetPings(List<RadarStats.RadarPing> vehiclePings) {
        for (RadarStats.RadarPing ping : this.pings) {
            vehiclePings.remove(ping);
        }
        this.pings.clear();
    }

    public void tickUpdateTargets(EntityVehicle radar, List<RadarStats.RadarPing> vehiclePings) {
        if (radar.getWorld().method_8608()) {
            return;
        }
        if (this.scanTicks <= ((RadarStats)this.getStats()).getScanRate()) {
            ++this.scanTicks;
            this.freshTargets = false;
            return;
        }
        this.scanTicks = 0;
        this.maxCheckDist = (Integer)Config.COMMON.maxBlockCheckDepth.get();
        this.resetPings(vehiclePings);
        this.freshTargets = true;
        class_1297 controller = radar.getControllingPlayerOrBot();
        RadarStats.RadarMode mode = radar.getRadarMode();
        if (mode.isOff()) {
            return;
        }
        class_238 radarArea = this.getRadarBoundingBox((class_1297)radar);
        double rangeSqr = ((RadarStats)this.getStats()).getRange() * ((RadarStats)this.getStats()).getRange();
        if (((RadarStats)this.getStats()).isScanPlayers() && (mode.isPlayersOrBots() || mode.canScan(RadarStats.RadarMode.VEHICLES))) {
            this.scanPlayersVehicles(radar, controller, vehiclePings, rangeSqr, mode.isPlayersOnly(), mode.isVehiclesOnly());
        }
        if (((RadarStats)this.getStats()).isScanMobs() && mode.canScan(RadarStats.RadarMode.MOBS)) {
            this.scanMobs(radar, controller, vehiclePings, radarArea);
        }
        if (((RadarStats)this.getStats()).isScanMissiles() && mode.isOn()) {
            this.scanMissiles(radar, controller, vehiclePings, rangeSqr);
        }
    }

    private void scanPlayersVehicles(EntityVehicle radar, class_1297 controller, List<RadarStats.RadarPing> vehiclePings, double rangeSqr, boolean playersOnly, boolean vehiclesOnly) {
        MinecraftServer server = radar.getWorld().method_8503();
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            this.handleScanPlayerVehicle(radar, controller, vehiclePings, rangeSqr, playersOnly, vehiclesOnly, (class_1297)player, true);
        }
        Collection<class_1297> entities = TrackableEntitiesManager.getTrackableEntities();
        for (class_1297 entity : entities) {
            this.handleScanPlayerVehicle(radar, controller, vehiclePings, rangeSqr, playersOnly, vehiclesOnly, entity, false);
        }
    }

    private void handleScanPlayerVehicle(EntityVehicle radar, class_1297 controller, List<RadarStats.RadarPing> vehiclePings, double rangeSqr, boolean playersOnly, boolean vehiclesOnly, class_1297 entity, boolean player) {
        EntityVehicle pingEntity;
        if (entity.method_7325()) {
            return;
        }
        if (playersOnly && !player) {
            return;
        }
        if (entity.method_5858((class_1297)radar) > rangeSqr) {
            return;
        }
        if (!UtilEntity.getLevel((class_1297)entity).method_27983().equals(radar.getWorld().method_27983())) {
            return;
        }
        EntityVehicle vehicle = null;
        if (!player && entity instanceof EntityVehicle) {
            EntityVehicle ev;
            vehicle = ev = (EntityVehicle)entity;
        } else {
            class_1297 class_12972 = entity.method_5668();
            if (class_12972 instanceof EntityVehicle) {
                EntityVehicle ev;
                vehicle = ev = (EntityVehicle)class_12972;
            }
        }
        if (vehiclesOnly && vehicle == null) {
            return;
        }
        EntityVehicle entityVehicle = pingEntity = vehicle != null ? vehicle : entity;
        if (!player) {
            if (this.alreadyScanned(vehiclePings, (class_1297)pingEntity)) {
                return;
            }
            if (vehicle == null) {
                if (entity.method_5668().method_5864().method_20210(ModTags.EntityTypes.VEHICLE)) {
                    pingEntity = entity.method_5668();
                } else {
                    return;
                }
            }
        }
        double stealth = 1.0;
        if (vehicle != null) {
            stealth = vehicle.getStealth();
        }
        if (this.isFailBasicCheck(radar, (class_1297)pingEntity, stealth)) {
            return;
        }
        RadarStats.PingEntityType pingEntityType = player ? (vehicle != null || pingEntity.method_5628() != entity.method_5628() ? RadarStats.PingEntityType.VEHICLE_PLAYER : RadarStats.PingEntityType.PLAYER) : (vehicle != null || pingEntity.method_5628() != entity.method_5628() ? RadarStats.PingEntityType.VEHICLE_BOT : RadarStats.PingEntityType.HOSTILE_MOB);
        RadarStats.RadarPing p = new RadarStats.RadarPing((class_1297)pingEntity, this.checkFriendly(controller, (class_1297)pingEntity), pingEntityType);
        vehiclePings.add(p);
        this.pings.add(p);
        if (vehicle != null && !radar.method_5722((class_1297)vehicle)) {
            vehicle.lockedOnto((class_1297)radar);
        }
    }

    private boolean alreadyScanned(List<RadarStats.RadarPing> vehiclePings, class_1297 entity) {
        for (RadarStats.RadarPing ping : vehiclePings) {
            if (ping.id != entity.method_5628()) continue;
            return true;
        }
        return false;
    }

    private void scanMobs(EntityVehicle radar, class_1297 controller, List<RadarStats.RadarPing> vehiclePings, class_238 radarArea) {
        for (int j = 0; j < RadarTargetTypes.get().getRadarMobClasses().size(); ++j) {
            Class<? extends class_1297> clazz = RadarTargetTypes.get().getRadarMobClasses().get(j);
            List list = radar.getWorld().method_18467(clazz, radarArea);
            for (class_1297 entity : list) {
                if (entity.method_5765() || this.isFailBasicCheck(radar, entity, 1.0)) continue;
                RadarStats.RadarPing p = new RadarStats.RadarPing(entity, this.checkFriendly(controller, entity), RadarStats.PingEntityType.FRIENDLY_MOB);
                vehiclePings.add(p);
                this.pings.add(p);
            }
        }
    }

    private void scanMissiles(EntityVehicle radar, class_1297 controller, List<RadarStats.RadarPing> vehiclePings, double rangeSqr) {
        Collection<class_1297> list = TrackableEntitiesManager.getTrackableEntities();
        for (class_1297 class_12972 : list) {
            if (!class_12972.method_5864().method_20210(ModTags.EntityTypes.MISSILE)) continue;
            this.handleMissile(radar, controller, vehiclePings, rangeSqr, class_12972);
        }
        for (EntityMissile entityMissile : NonTickingMissileManager.getMissiles()) {
            this.handleMissile(radar, controller, vehiclePings, rangeSqr, (class_1297)entityMissile);
        }
    }

    private void handleMissile(EntityVehicle radar, class_1297 controller, List<RadarStats.RadarPing> vehiclePings, double rangeSqr, class_1297 target) {
        if (target.method_5858((class_1297)radar) > rangeSqr) {
            return;
        }
        if (!UtilEntity.getLevel((class_1297)target).method_27983().equals(radar.getWorld().method_27983())) {
            return;
        }
        if (this.isFailBasicCheck(radar, target, -1.0)) {
            return;
        }
        RadarStats.RadarPing p = new RadarStats.RadarPing(target, this.checkFriendly(controller, target), RadarStats.PingEntityType.MISSILE);
        vehiclePings.add(p);
        this.pings.add(p);
    }

    private boolean checkFriendly(class_1297 controller, class_1297 target) {
        if (target == null) {
            return false;
        }
        if (controller == null) {
            return false;
        }
        return UtilEntity.areEntitiesAllied((class_1297)target, (class_1297)controller);
    }

    private boolean isFailBasicCheck(EntityVehicle radar, class_1297 ping, double stealth) {
        if (radar.equals(ping)) {
            return true;
        }
        if (!this.groundCheck(ping)) {
            return true;
        }
        if (radar.isVehicleOf(ping)) {
            return true;
        }
        if (!this.checkTargetRange((class_1297)radar, ping, stealth)) {
            return true;
        }
        return !this.checkCanSee((class_1297)radar, ping);
    }

    private boolean groundCheck(class_1297 ping) {
        if (((RadarStats)this.getStats()).getThroWaterRange() > 0.0 && ping.method_5799()) {
            return true;
        }
        boolean groundWater = UtilVehicleEntity.isOnGroundOrWater(ping);
        if (((RadarStats)this.getStats()).isScanGround() && groundWater) {
            return true;
        }
        return ((RadarStats)this.getStats()).isScanAir() && !groundWater && UtilVehicleEntity.getDistFromGround(ping, 6, false) >= 6;
    }

    private boolean checkTargetRange(class_1297 radar, class_1297 target, double stealth) {
        double areaMin;
        float dist = radar.method_5739(target);
        if (((RadarStats)this.getStats()).getFov() == -1.0 ? (double)dist > ((RadarStats)this.getStats()).getRange() : !UtilGeometry.isPointInsideCone((class_243)target.method_19538(), (class_243)radar.method_19538().method_1019(this.pos), (class_243)radar.method_5720(), (double)((RadarStats)this.getStats()).getFov(), (double)((RadarStats)this.getStats()).getRange())) {
            return false;
        }
        if (stealth == -1.0) {
            return true;
        }
        double area = UtilVehicleEntity.getRadarCrossSectionalArea(target, radar.method_19538()) * stealth;
        return area >= (areaMin = (1.0 - Math.pow(((RadarStats)this.getStats()).getRange(), -2.0) * Math.pow((double)dist - ((RadarStats)this.getStats()).getRange(), 2.0)) * ((RadarStats)this.getStats()).getSensitivity());
    }

    private boolean checkCanSee(class_1297 radar, class_1297 target) {
        return UtilEntity.canPosSeeEntity((class_243)radar.method_19538().method_1019(this.pos), (class_1297)target, (int)this.maxCheckDist, (double)(((RadarStats)this.getStats()).getThroWaterRange() + 1.0), (double)((RadarStats)this.getStats()).getThroGroundRange());
    }

    private class_238 getRadarBoundingBox(class_1297 radar) {
        double x = radar.method_23317() + this.pos.field_1352;
        double y = radar.method_23318() + this.pos.field_1351;
        double z = radar.method_23321() + this.pos.field_1350;
        double w = ((RadarStats)this.getStats()).getRange();
        return new class_238(x + w, y + w, z + w, x - w, y - w, z - w);
    }

    public boolean isFreshTargets() {
        return this.freshTargets;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public boolean isInternal() {
        return Objects.equals(this.slotId, "");
    }

    public void setSlot(String slotId) {
        this.slotId = slotId;
    }

    public void setInternal() {
        this.slotId = "";
    }

    public void setPos(class_243 pos) {
        this.pos = pos;
    }

    public boolean idMatch(String id, String slotId) {
        if (slotId == null) {
            return false;
        }
        if (id == null) {
            return false;
        }
        return this.getStatsId().equals(id) && slotId.equals(this.slotId);
    }
}

