/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle.physics;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.data.vehicle.physics.LiftSurfaceData;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.dscombat.entity.PhysicsBody;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import org.slf4j.Logger;

public class LiftSurfaceInstance
extends PhysicsComponentInstance<LiftSurfaceData> {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private float aoa = 0.0f;
    private class_243 dragForce = class_243.field_1353;
    private class_243 liftForce = class_243.field_1353;

    public LiftSurfaceInstance(LiftSurfaceData data) {
        super(data);
    }

    @Override
    protected void calcPhysics(PhysicsBody body) {
        float rotate;
        QuaternionF vehicleQ;
        if (((LiftSurfaceData)this.getData()).isIgnoreRoll()) {
            vehicleQ = QuaternionF.ONE.copy();
            vehicleQ.mul(Vec3f.XP.rotationDegrees(body.method_36455()));
            vehicleQ.mul(Vec3f.YP.rotationDegrees(body.method_36454()));
        } else {
            vehicleQ = body.getQBySide().copy();
        }
        QuaternionF surfaceQ = vehicleQ.copy();
        Vec3f rotation = ((LiftSurfaceData)this.getData()).getRotation();
        if (rotation.x() != 0.0f) {
            surfaceQ.mul(Vec3f.XN.rotationDegrees(rotation.x()));
        }
        if (rotation.y() != 0.0f) {
            surfaceQ.mul(Vec3f.YP.rotationDegrees(rotation.y()));
        }
        if (rotation.z() != 0.0f) {
            surfaceQ.mul(Vec3f.ZP.rotationDegrees(rotation.z()));
        }
        if ((rotate = ((LiftSurfaceData)this.getData()).getInputType().getRotationFromInput((LiftSurfaceData)this.getData(), body)) != 0.0f) {
            surfaceQ.mul(Vec3f.XN.rotationDegrees(rotate));
        }
        class_243 u = body.method_18798();
        class_243 pitchAxis = UtilAngles.getPitchAxis((QuaternionF)surfaceQ);
        class_243 liftDir = u.method_1036(pitchAxis).method_1029();
        class_243 airFoilAxes = UtilAngles.getRollAxis((QuaternionF)surfaceQ);
        float airFoilSpeedSqr = (float)UtilGeometry.vecCompByNormAxis((class_243)u, (class_243)airFoilAxes).method_1027() * 400.0f;
        class_243 wingNormal = UtilAngles.getYawAxis((QuaternionF)surfaceQ).method_1021(-1.0);
        float goalAOA = UtilGeometry.isZero((class_243)u) ? 0.0f : LiftSurfaceInstance.calcAOA(u, wingNormal);
        this.aoa = class_3532.method_16439((float)LiftSurfaceInstance.getAOAChangeRate(body), (float)this.aoa, (float)goalAOA);
        float speedScaleSqr = (float)(1.0 / body.getHorizontalSpeedScale() / body.getHorizontalSpeedScale());
        float liftK = this.getLiftK(this.aoa) * speedScaleSqr;
        double P = this.getAirDensity(body);
        double wingLiftMag = 0.5 * (double)liftK * P * (double)airFoilSpeedSqr * ((LiftSurfaceData)this.getData()).getArea();
        this.liftForce = liftDir.method_1021(wingLiftMag);
        body.addForce(this.liftForce);
        QuaternionF vehicleQI = vehicleQ.copy();
        vehicleQI.conj();
        class_243 liftMoment = ((LiftSurfaceData)this.getData()).getPos().method_1036(UtilAngles.rotateVector((class_243)this.liftForce, (QuaternionF)vehicleQI)).method_18805(-1.0, 1.0, 1.0);
        body.addMoment(liftMoment, true, true);
        class_243 windDir = u.method_1029();
        float dragK = this.getDragK(this.aoa) * speedScaleSqr;
        if (dragK < 0.0f) {
            LOGGER.warn("Drag Coefficient is somehow negative. Should not happen! Is the drag graph setup correctly? graph_id = {} aoa = {}", (Object)((LiftSurfaceData)this.getData()).getDragGraph().getId(), (Object)Float.valueOf(this.aoa));
        }
        double dragMag = 0.5 * (double)dragK * P * (double)airFoilSpeedSqr * ((LiftSurfaceData)this.getData()).getArea() * ((LiftSurfaceData)this.getData()).getZeroLiftDrag();
        this.dragForce = windDir.method_1021(-dragMag);
        body.addDragForce(this.dragForce);
        class_243 dragMoment = ((LiftSurfaceData)this.getData()).getPos().method_1036(UtilAngles.rotateVector((class_243)this.dragForce, (QuaternionF)vehicleQI)).method_18805(-1.0, 1.0, 1.0);
        body.addMoment(dragMoment, false, true);
    }

    @Override
    protected boolean canCalcPhysics(PhysicsBody body) {
        if (!super.canCalcPhysics(body)) {
            return false;
        }
        return !body.isArcadeMode();
    }

    @Override
    public class_243 getDragForce() {
        return this.dragForce;
    }

    @Override
    public class_243 getLiftForce() {
        return this.liftForce;
    }

    @Override
    public float getAOA() {
        return this.aoa;
    }

    protected float getLiftK(float aoa) {
        class_2487 value;
        if (this.getWindTunnel() != null && (value = this.getWindTunnel().getOverrideValue("lift_coefficient")) != null) {
            double AOA = value.method_10574("aoa");
            double liftC = value.method_10574("liftC");
            if (Math.abs((double)aoa - AOA) < 0.1) {
                return (float)liftC;
            }
        }
        return ((LiftSurfaceData)this.getData()).getLiftKGraph().getLerpFloat(aoa);
    }

    protected float getDragK(float aoa) {
        class_2487 value;
        if (this.getWindTunnel() != null && (value = this.getWindTunnel().getOverrideValue("drag_coefficient")) != null) {
            double AOA = value.method_10574("aoa");
            double dragC = value.method_10574("dragC");
            if (Math.abs((double)aoa - AOA) < 0.1) {
                return (float)dragC;
            }
        }
        return ((LiftSurfaceData)this.getData()).getDragGraph().getLerpFloat(aoa);
    }

    protected double getAirDensity(PhysicsBody body) {
        return body.getAirDensity();
    }

    public static float calcAOA(class_243 u, class_243 wingNormal) {
        return (float)UtilGeometry.angleBetweenVecPlaneDegrees((class_243)u, (class_243)wingNormal);
    }

    public static float getAOAChangeRate(PhysicsBody body) {
        if (body.isTestMode()) {
            return 1.0f;
        }
        return 0.5f;
    }
}

