/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon;

import com.onewhohears.dscombat.crafting.WeaponRecipe;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1863;
import net.minecraft.class_2487;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class WeaponPresets
extends JsonPresetReloadListener<WeaponStats> {
    private static WeaponPresets instance;
    private final Map<String, List<String>> compatiblePartMap = new HashMap<String, List<String>>();
    private WeaponRecipe[] weaponRecipes;

    public static WeaponPresets get() {
        if (instance == null) {
            instance = new WeaponPresets();
        }
        return instance;
    }

    public WeaponPresets() {
        super("weapons");
    }

    public void registerDefaultPresetTypes() {
        this.addPresetType(WeaponType.NONE);
        this.addPresetType(WeaponType.BOMB);
        this.addPresetType(WeaponType.BUNKER_BUSTER);
        this.addPresetType(WeaponType.BULLET);
        this.addPresetType(WeaponType.POS_MISSILE);
        this.addPresetType(WeaponType.TRACK_MISSILE);
        this.addPresetType(WeaponType.TORPEDO);
        this.addPresetType(WeaponType.IR_MISSILE);
        this.addPresetType(WeaponType.ANTI_RADAR_MISSILE);
        this.addPresetType(WeaponType.DUMB_TORPEDO);
    }

    @Nullable
    public WeaponStats get(String id) {
        String updatedId = this.getUpdatedId(id);
        if (updatedId == null) {
            return null;
        }
        if (!this.has(updatedId)) {
            return null;
        }
        return (WeaponStats)((Object)this.presetMap.get(updatedId));
    }

    public String getUpdatedId(String id) {
        if (id == null) {
            return null;
        }
        if (this.presetMap.containsKey(id)) {
            return id;
        }
        if (id.equals("torpedo1")) {
            return "mk13";
        }
        if (id.equals("rifel1")) {
            return "agm88g";
        }
        return null;
    }

    public WeaponStats getFromNbt(class_2487 nbt) {
        if (nbt == null) {
            return null;
        }
        WeaponStats w = (WeaponStats)super.getFromNbt(nbt);
        if (w != null) {
            return w;
        }
        if (!nbt.method_10545("weaponId")) {
            return null;
        }
        String presetId = nbt.method_10558("weaponId");
        return this.get(presetId);
    }

    public boolean has(String id) {
        return this.getUpdatedId(id) != null;
    }

    public WeaponStats[] getNewArray(int i) {
        return new WeaponStats[i];
    }

    public WeaponRecipe[] getWeaponRecipes(class_1863 recipeManager) {
        if (this.weaponRecipes == null) {
            List wRecipes = recipeManager.method_30027((class_3956)WeaponRecipe.Type.INSTANCE);
            ArrayList list = new ArrayList(wRecipes);
            this.weaponRecipes = list.toArray(new WeaponRecipe[list.size()]);
            this.sort(this.weaponRecipes);
        }
        return this.weaponRecipes;
    }

    public void sort(WeaponRecipe[] recipes) {
        Arrays.sort(recipes, WeaponRecipe::compare);
    }

    public int getWeaponRecipeNum() {
        if (this.weaponRecipes == null) {
            return 0;
        }
        return this.weaponRecipes.length;
    }

    public List<String> getCompatibleWeapons(String weaponPartId) {
        List<String> list = this.compatiblePartMap.get(weaponPartId);
        if (list == null) {
            return new ArrayList<String>();
        }
        return list;
    }

    protected void resetCache() {
        this.weaponRecipes = null;
        this.refreshCompatibility();
    }

    protected void refreshCompatibility() {
        this.compatiblePartMap.clear();
        for (int i = 0; i < ((WeaponStats[])this.getAll()).length; ++i) {
            String[] partIds;
            for (String partId : partIds = ((WeaponStats[])this.getAll())[i].getCompatibleWeaponParts()) {
                List list = this.compatiblePartMap.computeIfAbsent(partId, k -> new ArrayList());
                list.add(((WeaponStats[])this.getAll())[i].getId());
            }
        }
        this.LOGGER.debug("WEAPON CAPATIBILITY: {}", (Object)this.compatiblePartMap.toString());
    }
}

