/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilParticles;
import com.onewhohears.dscombat.util.UtilSound;
import com.onewhohears.onewholibs.data.crafting.IngredientStackBuilder;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public abstract class WeaponStats
extends JsonPresetStats {
    public static final int INFO_COLOR = 6266528;
    public static final int COMPAT_COLOR = 11403055;
    public static final int TYPE_COLOR = Short.MAX_VALUE;
    public static final int SPECIAL_COLOR = 8388564;
    protected static final class_2960 NONE_ICON = new class_2960("dscombat", "textures/ui/weapon_icons/none.png");
    private final int craftNum;
    private final int maxAge;
    private final int fireRate;
    private final boolean canShootOnGround;
    private final float mass;
    private final String entityTypeKey;
    private final String shootSoundKey;
    private final String[] compatibleWeaponPart;
    private final String itemKey;
    private final String assetId;
    private final class_2960 icon;
    private class_2371<class_1856> ingredients;
    private class_1299<?> entityType;
    private class_3414 shootSound;
    private class_1792 item;
    private class_1799 stack;

    public WeaponStats(class_2960 key, JsonObject json) {
        super(key, json);
        this.craftNum = UtilParse.getIntSafe((JsonObject)json, (String)"craftNum", (int)0);
        this.maxAge = UtilParse.getIntSafe((JsonObject)json, (String)"maxAge", (int)0);
        this.fireRate = UtilParse.getIntSafe((JsonObject)json, (String)"fireRate", (int)0);
        this.canShootOnGround = UtilParse.getBooleanSafe((JsonObject)json, (String)"canShootOnGround", (boolean)false);
        this.mass = UtilParse.getFloatSafe((JsonObject)json, (String)"mass", (float)1.0f);
        this.entityTypeKey = UtilParse.getStringSafe((JsonObject)json, (String)"entityTypeKey", (String)"");
        this.shootSoundKey = UtilParse.getStringSafe((JsonObject)json, (String)"shootSoundKey", (String)"");
        this.compatibleWeaponPart = UtilParse.getStringArraySafe((JsonObject)json, (String)"compatibleWeaponPart");
        this.itemKey = UtilParse.getStringSafe((JsonObject)json, (String)"itemKey", (String)"");
        this.assetId = json.has("assetId") ? json.get("assetId").getAsString() : (json.has("modelId") ? json.get("modelId").getAsString() : this.getId());
        this.icon = new class_2960(UtilParse.getStringSafe((JsonObject)json, (String)"icon", (String)this.getDefaultIconLocation()));
    }

    public WeaponInstance<?> createWeaponInstance() {
        return (WeaponInstance)this.createPresetInstance();
    }

    public class_2371<class_1856> getIngredients() {
        if (this.ingredients == null) {
            this.ingredients = IngredientStackBuilder.getIngredients((JsonObject)this.getJsonData());
        }
        return this.ingredients;
    }

    public int getCraftNum() {
        return this.craftNum;
    }

    public boolean canAngleDown() {
        return this.isBullet();
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public int getFireRate() {
        return this.fireRate;
    }

    public boolean canShootOnGround() {
        return this.canShootOnGround;
    }

    public abstract double getMobTurretRange();

    public String toString() {
        return "[" + this.getType().toString() + ":" + this.getId() + "]";
    }

    public class_1299<?> getEntityType() {
        if (this.entityType == null) {
            this.entityType = UtilEntity.getEntityType((String)this.entityTypeKey, this.getWeaponType().getDefaultEntityType());
        }
        return this.entityType;
    }

    public class_3414 getShootSound() {
        if (this.shootSound == null) {
            this.shootSound = UtilSound.getSoundById(this.shootSoundKey, ModSounds.BULLET_SHOOT_1);
        }
        return this.shootSound;
    }

    private class_1792 getItem() {
        if (this.item == null) {
            this.item = UtilItem.getItem((String)this.itemKey, (class_1792)((class_1792)ModItems.AMMO.get()));
        }
        return this.item;
    }

    public class_1799 getDisplayStack() {
        if (this.stack == null) {
            this.stack = new class_1799((class_1935)this.getItem());
            this.stack.method_7939(this.craftNum);
            class_2487 tag = new class_2487();
            tag.method_10582("weapon", this.getId());
            this.stack.method_7980(tag);
        }
        return this.stack;
    }

    public class_1799 getNewItem() {
        return this.getDisplayStack().method_7972();
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public String[] getCompatibleWeaponParts() {
        return this.compatibleWeaponPart;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public class_2960 getWeaponIcon() {
        return this.isNoWeapon() ? NONE_ICON : this.icon;
    }

    public String getDefaultIconLocation() {
        return "dscombat:textures/ui/weapon_icons/default.png";
    }

    public abstract String getWeaponTypeCode();

    public WeaponType getWeaponType() {
        return (WeaponType)this.getType();
    }

    public void addToolTips(List<class_2561> tips, boolean advanced) {
        tips.add((class_2561)this.getType().getDisplayNameComponent().method_10862(class_2583.field_24360.method_36139(Short.MAX_VALUE)));
        if (this.compatibleWeaponPart.length > 0) {
            class_5250 weapons = UtilMCText.translatable((String)"info.dscombat.compatible").method_27693(": ").method_10862(class_2583.field_24360.method_36139(11403055));
            for (int i = 0; i < this.compatibleWeaponPart.length; ++i) {
                PartStats stats = (PartStats)PartPresets.get().get(this.compatibleWeaponPart[i]);
                if (stats == null) continue;
                if (i != 0) {
                    weapons.method_10852((class_2561)UtilMCText.literal((String)", "));
                }
                weapons.method_10852((class_2561)stats.getDisplayNameComponent());
            }
            tips.add((class_2561)weapons);
        }
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.fire_rate").method_27693(": " + this.getFireRate()).method_10862(class_2583.field_24360.method_36139(6266528)));
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.mass").method_27693(": " + this.getMass()).method_10862(class_2583.field_24360.method_36139(6266528)));
        if (advanced) {
            tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.max_age").method_27693(": " + this.getMaxAge()).method_10862(class_2583.field_24360.method_36139(6266528)));
            if (!this.canShootOnGround) {
                tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.must_fly").method_10862(class_2583.field_24360.method_36139(8388564)));
            }
        }
    }

    public boolean isBullet() {
        return false;
    }

    public boolean isNoWeapon() {
        return false;
    }

    public boolean isIRMissile() {
        return false;
    }

    public boolean requiresRadar() {
        return false;
    }

    public boolean isAimAssist() {
        return false;
    }

    public boolean isPosGuided() {
        return false;
    }

    public float getMass() {
        return this.mass;
    }

    public static enum WeaponClientImpactType {
        SMALL_BULLET_IMPACT((level, pos) -> UtilParticles.bulletImpact(level, pos, 5.0)),
        SMALL_BULLET_EXPLODE((level, pos) -> UtilParticles.bulletExplode(level, pos, 2.5, true)),
        MED_BOMB_EXPLODE((level, pos) -> UtilParticles.bombExplode(level, pos, 5.0, true)),
        MED_MISSILE_EXPLODE((level, pos) -> UtilParticles.missileExplode(level, pos, 4.0, true));

        private final BiConsumer<class_1937, class_243> clientImpactCallback;

        @Nullable
        public static WeaponClientImpactType getByOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= WeaponClientImpactType.values().length) {
                return null;
            }
            return WeaponClientImpactType.values()[ordinal];
        }

        private WeaponClientImpactType(BiConsumer<class_1937, class_243> clientImpactCallback) {
            this.clientImpactCallback = clientImpactCallback;
        }

        public void onClientImpact(class_1937 level, class_243 pos) {
            this.clientImpactCallback.accept(level, pos);
        }
    }
}

