/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity;

import com.onewhohears.dscombat.entity.PhysicsBody;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public interface DrivingBody
extends PhysicsBody {
    @Override
    default public void calcGroundMovement(QuaternionF q) {
        if (this.canFlattenOnGround()) {
            this.flatten(q, 4.0f, 4.0f, true);
        }
        if (this.canDriveOnGround()) {
            this.calcDriveMovement(q);
        } else {
            this.calcOtherGroundMovement(q);
        }
        if (this.canGroundBrake() && this.isGroundBraking()) {
            this.applyGroundBreaks();
        }
    }

    default public void applyGroundBreaks() {
        this.driveSlowDown(this.getGroundBreaksDeAcceleration());
    }

    default public void calcDriveMovement(QuaternionF q) {
        class_243 n = UtilAngles.rotationToVector((double)this.method_36454(), (double)0.0);
        double driveAcc = this.getDriveAcc();
        double minDriveAcc = this.getMinDriveAcc();
        if (Math.abs(driveAcc) < minDriveAcc) {
            driveAcc = minDriveAcc * (double)(driveAcc < 0.0 ? -1 : 1);
        }
        if (this.isSliding() || this.willSlideFromTurn()) {
            this.method_18799(this.method_18798().method_1019(n.method_1021(driveAcc * 0.5)));
            this.addFrictionForce(this.getKineticFriction());
        } else {
            this.method_18799(n.method_1021((double)(this.getXZSpeed() * (float)this.getXZSpeedDir()) + driveAcc));
            if (this.getCurrentThrottle() == 0.0f && this.getXZSpeed() != 0.0f) {
                this.driveSlowDown(2.0E-4);
            }
        }
        if (this.dontUseDriveTurnPhysics()) {
            return;
        }
        float max_tr = this.getTurnRadius();
        class_243 av = this.getAngularVel();
        if (this.getYawInput() == 0.0f || max_tr == 0.0f) {
            if (!this.isSliding()) {
                this.setAngularVel(av.method_18805(1.0, 0.0, 1.0));
            }
            return;
        }
        float tr = 1.0f / this.getYawInput() * max_tr;
        float turn = this.getXZSpeed() / tr * (float)this.getXZSpeedDir();
        float turnDeg = turn * 57.295776f;
        if (!this.isSliding()) {
            av = av.method_18805(1.0, 0.0, 1.0).method_1031(0.0, (double)turnDeg, 0.0);
        } else {
            this.addMomentY(turnDeg * this.getSlideAngleCos() * 5000000.0f, false);
        }
        this.setAngularVel(av);
    }

    default public boolean willSlideFromTurn() {
        double max_tr = this.getTurnRadius();
        if (this.getYawInput() != 0.0f && max_tr != 0.0) {
            double tr = max_tr * 1.0 / (double)Math.abs(this.getYawInput());
            double cen_acc = (double)(this.getXZSpeed() * this.getXZSpeed()) / tr * 400.0;
            double cen_force = cen_acc * (double)this.getTotalMass();
            return cen_force >= this.getStaticFriction();
        }
        return false;
    }

    default public boolean isSlideAngleNearZero() {
        if (this.getXZSpeedDir() == -1) {
            return class_3532.method_15379((float)(class_3532.method_15379((float)this.getSlideAngle()) - 180.0f)) < 2.0f;
        }
        return class_3532.method_15379((float)this.getSlideAngle()) < 2.0f;
    }

    default public boolean isSliding() {
        return !this.canDriveOnGround() || !this.isSlideAngleNearZero();
    }

    default public void calcOtherGroundMovement(QuaternionF q) {
        this.addFrictionForce(this.getKineticFriction());
    }

    default public void driveSlowDown(double amount) {
        class_243 m = this.method_18798().method_18805(1.0, 0.0, 1.0);
        if (UtilGeometry.isZero((class_243)m)) {
            return;
        }
        double speed = m.method_1033();
        double newSpeed = speed - amount;
        if (Math.signum(newSpeed) != Math.signum(speed)) {
            newSpeed = 0.0;
        }
        m = m.method_1021(newSpeed / speed);
        this.method_18799(new class_243(m.field_1352, this.method_18798().field_1351, m.field_1350));
    }

    public boolean canDriveOnGround();

    public boolean canGroundBrake();

    public boolean isGroundBraking();

    public double getKineticFriction();

    public double getStaticFriction();

    public boolean canAirBrake();

    public boolean isAirBreaking();

    public double getGroundBreaksDeAcceleration();

    public double getAirBreaksDeAcceleration();

    public double getDriveAcc();

    public float getCurrentThrottle();

    public float getTurnRadius();

    public boolean canFlattenOnGround();

    public double getMinDriveAcc();

    @Override
    default public void calcAirMovement(QuaternionF q) {
        if (this.canAirBrake() && this.isAirBreaking()) {
            this.applyAirBreaks();
        }
    }

    default public void applyAirBreaks() {
        this.airSlowDown(this.getAirBreaksDeAcceleration());
    }

    default public void airSlowDown(double amount) {
        class_243 m = this.method_18798();
        if (UtilGeometry.isZero((class_243)m)) {
            return;
        }
        double speed = m.method_1033();
        double newSpeed = speed - amount;
        if (Math.signum(newSpeed) != Math.signum(speed)) {
            newSpeed = 0.0;
        }
        m = m.method_1021(newSpeed / speed);
        this.method_18799(m);
    }

    @Override
    default public void calcMoveStatsPost(QuaternionF q) {
        class_243 m = this.method_18798();
        float y = this.method_36454();
        this.setXZSpeed((float)Math.sqrt(m.field_1352 * m.field_1352 + m.field_1350 * m.field_1350));
        if (this.getXZSpeed() == 0.0f) {
            this.setXZYaw(y);
            this.setSlideAngle(0.0f);
        } else {
            this.setXZYaw(UtilAngles.getYaw((class_243)m));
            this.setSlideAngle(class_3532.method_15381((float)this.getXZYaw(), (float)y));
            this.setSlideAngleCos((float)Math.abs(Math.cos(Math.toRadians(this.getSlideAngle()))));
        }
        this.setXZSpeedDir(1);
        if (Math.abs(this.getSlideAngle()) > 90.0f) {
            this.setXZSpeedDir(-1);
        }
    }

    public float getXZSpeed();

    public void setXZSpeed(float var1);

    public int getXZSpeedDir();

    public void setXZSpeedDir(int var1);

    public float getXZYaw();

    public void setXZYaw(float var1);

    public float getSlideAngle();

    public void setSlideAngle(float var1);

    public float getSlideAngleCos();

    public void setSlideAngleCos(float var1);
}

