/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.parts;

import com.onewhohears.dscombat.common.network.toserver.ToServerGetHookChains;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.instance.ChainHookInstance;
import com.onewhohears.dscombat.data.parts.stats.ChainHookStats;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilServerPacket;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class EntityChainHook
extends EntityPart<ChainHookStats, ChainHookInstance<ChainHookStats>> {
    public static final double CHAIN_LENGTH = 8.0;
    private final List<ChainConnection> chains = new ArrayList<ChainConnection>();

    public EntityChainHook(class_1299<?> entityType, class_1937 level) {
        super(entityType, level, "chain_hook");
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        class_2499 conns = nbt.method_10554("chains", 10);
        for (int i = 0; i < conns.size(); ++i) {
            class_2487 tag = conns.method_10602(i);
            ChainConnection conn = this.fromNBT(tag, this.getWorld());
            if (conn == null) continue;
            this.chains.add(conn);
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_2499 conns = new class_2499();
        for (int i = 0; i < this.chains.size(); ++i) {
            class_2487 tag = this.chains.get(i).toNBT();
            if (tag == null) continue;
            conns.add((Object)tag);
        }
        nbt.method_10566("chains", (class_2520)conns);
    }

    @Override
    public void method_5773() {
        if (this.field_5953 && this.isClientSide()) {
            this.requestChainsFromServer();
        }
        super.method_5773();
        for (int i = 0; i < this.chains.size(); ++i) {
            ChainConnection chain = this.chains.get(i);
            chain.tick();
            if (this.isClientSide() || !chain.isDisconnected()) continue;
            this.disconnectChain(i--);
        }
    }

    public boolean isClientSide() {
        return this.getWorld().method_8608();
    }

    @Override
    public class_1937 getWorld() {
        return UtilEntity.getLevel((class_1297)this);
    }

    private void requestChainsFromServer() {
        if (!this.isClientSide()) {
            return;
        }
        new ToServerGetHookChains(this).sendToServer();
    }

    public void sendAllVehicleChainsToClient(class_3222 reciever) {
        if (this.isClientSide()) {
            return;
        }
        for (ChainConnection chain : this.chains) {
            if (!chain.isVehicleConnection()) continue;
            UtilServerPacket.sendChainAddVehicleTo(chain.getVehicle(), this, reciever);
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 item = player.method_5998(hand);
        if (!item.method_7960() && item.method_31573(ModTags.Items.VEHICLE_CHAIN)) {
            this.handleChainInteract(player, item);
            return class_1269.method_29236((boolean)this.isClientSide());
        }
        if (this.hasChain()) {
            this.disconnectAllChains();
            return class_1269.method_29236((boolean)this.isClientSide());
        }
        return class_1269.field_5811;
    }

    protected void handleChainInteract(class_1657 player, class_1799 item) {
        if (this.isClientSide()) {
            return;
        }
        if (this.isPlayerConnected(player)) {
            return;
        }
        List vehicles = this.getWorld().method_8390(EntityVehicle.class, this.method_5829().method_1014(8.0), vehicle -> vehicle.isChainConnectedToPlayer(player));
        if (vehicles.size() == 0) {
            this.addPlayerConnection(player);
            return;
        }
        for (EntityVehicle vehicle2 : vehicles) {
            this.addVehicleConnection(null, vehicle2);
        }
    }

    public void addPlayerConnection(class_1657 player) {
        this.chains.add(new ChainConnection(this, player, null));
        if (!this.isClientSide()) {
            UtilServerPacket.sendChainAddPlayer(this, player);
            this.playChainConnectSound();
        }
    }

    public boolean addVehicleConnection(@Nullable class_1657 player, EntityVehicle vehicle) {
        boolean foundConnection;
        block5: {
            block4: {
                if (vehicle.equals(this.getParentVehicle())) {
                    return false;
                }
                foundConnection = false;
                if (player != null) break block4;
                boolean alreadyConnected = false;
                for (ChainConnection chain : this.chains) {
                    if (!chain.isVehicleConnection() || !chain.getVehicle().equals(vehicle)) continue;
                    alreadyConnected = true;
                    break;
                }
                if (alreadyConnected) break block5;
                this.chains.add(new ChainConnection(this, null, vehicle));
                break block5;
            }
            for (ChainConnection chain : this.chains) {
                if (!chain.attachVehicle(player, vehicle)) continue;
                foundConnection = true;
                break;
            }
        }
        if (!this.isClientSide()) {
            UtilServerPacket.sendChainAddVehicle(vehicle, this, player);
            this.playChainConnectSound();
        }
        return foundConnection;
    }

    public void playChainConnectSound() {
        this.getWorld().method_43129(null, (class_1297)this, class_3417.field_24063, class_3419.field_15245, 1.0f, 1.0f);
    }

    public void playChainDisconnectSound() {
        this.getWorld().method_43129(null, (class_1297)this, class_3417.field_24065, class_3419.field_15245, 1.0f, 1.0f);
    }

    public void disconnectVehicle(EntityVehicle vehicle) {
        for (int i = 0; i < this.chains.size(); ++i) {
            if (!this.chains.get(i).isVehicleConnection() || !this.chains.get(i).getVehicle().equals(vehicle)) continue;
            this.disconnectChain(i--);
        }
    }

    public void disconnectPlayer(class_1657 player) {
        for (int i = 0; i < this.chains.size(); ++i) {
            if (!this.chains.get(i).isPlayerConnected(player)) continue;
            this.disconnectChain(i--);
        }
    }

    public boolean hasChain() {
        return this.chains.size() > 0;
    }

    public void disconnectAllChains() {
        for (int i = 0; i < this.chains.size(); ++i) {
            this.disconnectChain(i--);
        }
    }

    public void disconnectChain(int index) {
        this.chains.get(index).onDisconnect();
        this.chains.remove(index);
    }

    public boolean isPlayerConnected(class_1657 player) {
        for (ChainConnection chain : this.chains) {
            if (!chain.isPlayerConnected(player)) continue;
            return true;
        }
        return false;
    }

    public List<ChainConnection> getConnections() {
        return this.chains;
    }

    @Nullable
    private ChainConnection fromNBT(class_2487 nbt, class_1937 level) {
        UUID vehicleId = nbt.method_25926("vehicle");
        if (vehicleId == null) {
            return null;
        }
        return new ChainConnection(this, vehicleId);
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    public PartType getPartType() {
        return PartType.CHAIN_HOOK;
    }

    @Override
    public boolean canGetHurt() {
        return true;
    }

    @Override
    public void method_5768() {
        this.disconnectAllChains();
        super.method_5768();
    }

    @Override
    protected void onNoParent() {
        this.disconnectAllChains();
        super.onNoParent();
    }

    public static class ChainConnection {
        private final EntityChainHook hook;
        private class_1657 player;
        private EntityVehicle vehicle;
        private UUID vehicleUUID;
        private int vehicleId = -1;

        private ChainConnection(EntityChainHook hook, @Nullable class_1657 player, @Nullable EntityVehicle vehicle) {
            this.hook = hook;
            this.player = player;
            this.vehicle = vehicle;
            if (vehicle != null) {
                this.vehicleUUID = vehicle.method_5667();
                this.vehicleId = vehicle.method_5628();
            }
        }

        private ChainConnection(EntityChainHook hook, UUID vehicleUUID) {
            this.hook = hook;
            this.vehicleUUID = vehicleUUID;
        }

        private ChainConnection(EntityChainHook hook, int vehicleId) {
            this.hook = hook;
            this.vehicleId = vehicleId;
        }

        @Nullable
        private class_2487 toNBT() {
            if (!this.isVehicleConnection()) {
                return null;
            }
            class_2487 tag = new class_2487();
            tag.method_25927("vehicle", this.vehicleUUID);
            return tag;
        }

        protected void tickPhysics() {
            if (this.getVehicle() == null) {
                return;
            }
            EntityVehicle parent = this.hook.getParentVehicle();
            if (parent == null) {
                return;
            }
            class_243 vehicleHookDiff = this.hook.method_19538().method_1020(this.getVehicle().method_19538());
            double distance = vehicleHookDiff.method_1033();
            if (distance > 7.5 || !parent.method_24828() && !this.getVehicle().method_24828()) {
                parent.addForceMomentToClient(this.getVehicle().getWeightForce(), class_243.field_1353);
            }
            if (distance <= 8.0) {
                return;
            }
            double fraction = (distance - 8.0) / distance;
            double yMove = vehicleHookDiff.field_1351 * fraction;
            if (parent.method_24828() && this.getVehicle().method_24828()) {
                yMove = 0.0;
            }
            class_243 move = new class_243(vehicleHookDiff.field_1352 * fraction, yMove, vehicleHookDiff.field_1350 * fraction);
            if (this.getVehicle().method_24828()) {
                double speed = (double)(this.getVehicle().getXZSpeed() * (float)this.getVehicle().getXZSpeedDir()) + move.method_37267();
                this.getVehicle().method_18799(move.method_1029().method_1021(speed));
            } else {
                this.getVehicle().method_18799(this.getVehicle().method_18798().method_1019(move));
            }
            this.getVehicle().method_5784(class_1313.field_6308, move);
            if (move.method_37268() > 0.01) {
                float turn = class_3532.method_15388((float)this.getVehicle().method_36454(), (float)UtilAngles.getYaw((class_243)move), (float)this.getVehicle().getMaxDeltaYaw());
                this.getVehicle().method_36456(turn);
            }
        }

        protected double moveComponent(double diff, double fraction) {
            return diff * fraction;
        }

        public void tick() {
            if (this.isVehicleConnection()) {
                this.tickPhysics();
                return;
            }
        }

        private void onDisconnect() {
            if (this.getVehicle() != null) {
                this.getVehicle().disconnectChain();
                if (!this.hook.isClientSide()) {
                    class_1264.method_5449((class_1937)this.hook.getWorld(), (double)this.hook.method_23317(), (double)this.hook.method_23318(), (double)this.hook.method_23321(), (class_1799)class_1802.field_23983.method_7854());
                    UtilServerPacket.sendChainDisconnectVehicle(this.getVehicle(), this.hook);
                }
            } else if (this.player != null && !this.hook.isClientSide()) {
                UtilServerPacket.sendChainDisconnectPlayer(this.hook, this.player);
            }
            if (!this.hook.isClientSide()) {
                this.hook.playChainDisconnectSound();
            }
            this.resetVehicle();
            this.player = null;
        }

        public boolean attachVehicle(class_1657 player, EntityVehicle vehicle) {
            if (!this.canAttachVehicle(player, vehicle)) {
                return false;
            }
            this.player = null;
            this.vehicleId = vehicle.method_5628();
            this.vehicleUUID = vehicle.method_5667();
            this.vehicle = vehicle;
            this.vehicle.chainToHook(this.hook);
            return true;
        }

        public void resetVehicle() {
            this.vehicle = null;
            this.vehicleUUID = null;
            this.vehicleId = -1;
        }

        public boolean canAttachVehicle(class_1657 player, EntityVehicle vehicle) {
            return this.isPlayerConnected(player) && vehicle.getChainHolderHook() == null;
        }

        public boolean isPlayerConnected(class_1657 player) {
            return this.isPlayerConnection() && this.getPlayer().equals((Object)player);
        }

        @Nullable
        public class_1657 getPlayer() {
            return this.player;
        }

        @Nullable
        public EntityVehicle getVehicle() {
            if (this.vehicle == null) {
                if (this.vehicleUUID != null && !this.hook.isClientSide()) {
                    class_1297 entity = ((class_3218)this.hook.getWorld()).method_14190(this.vehicleUUID);
                    if (!(entity instanceof EntityVehicle)) {
                        this.resetVehicle();
                        return null;
                    }
                    EntityVehicle v = (EntityVehicle)entity;
                    this.vehicle = v;
                    this.vehicleId = this.vehicle.method_5628();
                    this.vehicle.chainToHook(this.hook);
                } else if (this.vehicleId != -1 && this.hook.isClientSide()) {
                    class_1297 entity = this.hook.getWorld().method_8469(this.vehicleId);
                    if (!(entity instanceof EntityVehicle)) {
                        this.resetVehicle();
                        return null;
                    }
                    EntityVehicle v = (EntityVehicle)entity;
                    this.vehicle = v;
                    this.vehicle.chainToHook(this.hook);
                }
            }
            return this.vehicle;
        }

        @Nullable
        public class_1297 getEntity() {
            return this.getVehicle() != null ? this.getVehicle() : this.player;
        }

        public boolean isDisconnected() {
            return this.getVehicle() == null && this.player == null || this.isVehicleDead() || this.isVehicleDisconnected() || this.isPlayerTooFar();
        }

        public boolean isPlayerConnection() {
            return this.player != null;
        }

        public boolean isVehicleConnection() {
            return this.getVehicle() != null;
        }

        public boolean isVehicleDead() {
            return this.isVehicleConnection() && this.getVehicle().method_31481();
        }

        public boolean isVehicleDisconnected() {
            return this.isVehicleConnection() && this.getVehicle().getChainHolderHook() == null;
        }

        public boolean isPlayerTooFar() {
            return this.isPlayerConnection() && (double)this.hook.method_5739((class_1297)this.player) > 8.0;
        }

        @Nullable
        public UUID getVehicleUUID() {
            return this.vehicleUUID;
        }
    }

    public static enum ChainUpdateType {
        CHAIN_ADD_VEHICLE,
        CHAIN_ADD_PLAYER,
        CHAIN_DISCONNECT_PLAYER,
        CHAIN_DISCONNECT_VEHICLE,
        VEHICLE_ADD_PLAYER;

    }
}

