/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.parts;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.model.obj.ObjRadarModel;
import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.client.PartAssets;
import com.onewhohears.dscombat.data.parts.client.PartClientStats;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetAssetReader;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.entity.CustomAnimEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_270;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityPart<P extends PartStats, I extends PartInstance<P>>
extends CustomAnimEntity<P, PartClientStats> {
    public static final class_2940<class_243> POS = class_2945.method_12791(EntityPart.class, DataSerializers.VEC3);
    public static final class_2940<String> SLOT_ID = class_2945.method_12791(EntityPart.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Float> HEALTH = class_2945.method_12791(EntityPart.class, (class_2941)class_2943.field_13320);
    private float z_rot;
    protected double renderSqrDistance = 0.0;

    protected EntityPart(class_1299<?> entityType, class_1937 level, String defaultPresetId) {
        super(entityType, level, defaultPresetId);
        if (this.isClientSide() && this.shouldRender()) {
            double dist = this.getClientRenderDistance();
            this.renderSqrDistance = dist * dist;
        }
    }

    protected void method_5693() {
        this.field_6011.method_12784(POS, (Object)class_243.field_1353);
        this.field_6011.method_12784(SLOT_ID, (Object)"");
        this.field_6011.method_12784(HEALTH, (Object)Float.valueOf(0.0f));
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setRelativePos(UtilParse.readVec3((class_2487)compound, (String)"relpos"));
        this.setSlotId(compound.method_10558("slotid"));
        this.setHealth(compound.method_10583("health"));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        UtilParse.writeVec3((class_2487)compound, (class_243)this.getRelativePos(), (String)"relpos");
        compound.method_10582("slotid", this.getSlotId());
        compound.method_10548("health", this.getHealth());
    }

    public void init() {
        PartSlot ps = this.getSlot();
        if (ps != null) {
            this.z_rot = ps.getZRot();
            this.setRelativePos(ps.getRelPos());
        }
    }

    public void method_5773() {
        if (this.field_5953) {
            this.init();
        }
        super.method_5773();
        if (!this.isClientSide() && this.field_6012 > 10 && this.method_5854() == null) {
            this.onNoParent();
        }
    }

    protected void onNoParent() {
        this.method_31472();
    }

    public class_243 getRelativePos() {
        return (class_243)this.field_6011.method_12789(POS);
    }

    public void setRelativePos(class_243 pos) {
        this.field_6011.method_12778(POS, (Object)pos);
    }

    public String getSlotId() {
        return (String)this.field_6011.method_12789(SLOT_ID);
    }

    public void setSlotId(String id) {
        this.field_6011.method_12778(SLOT_ID, (Object)id);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.canGetHurt()) {
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle != null) {
            amount = vehicle.calcDamageToRider(source, amount);
        }
        this.addHealth(-amount);
        if (this.getHealth() <= 0.0f) {
            this.method_5768();
        }
        return true;
    }

    public void onDeath() {
        if (!this.canGetHurt()) {
            return;
        }
        class_1297 class_12972 = this.method_5854();
        if (!(class_12972 instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle plane = (EntityVehicle)class_12972;
        plane.partsManager.killPartInSlot(this.getSlotId());
    }

    public void method_5768() {
        this.onDeath();
        super.method_5768();
    }

    @Nullable
    public EntityVehicle getParentVehicle() {
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle vehicle = (EntityVehicle)class_12972;
            return vehicle;
        }
        return null;
    }

    public abstract boolean shouldRender();

    protected double getClientRenderDistance() {
        return (Double)Config.CLIENT.renderOtherExternalPartDistance.get();
    }

    public boolean method_5640(double dist) {
        return this.shouldRender() && dist <= this.renderSqrDistance;
    }

    public float getZRot() {
        return this.z_rot;
    }

    public boolean method_5863() {
        return this.canGetHurt();
    }

    public boolean method_30949(class_1297 entity) {
        return false;
    }

    public boolean method_30948() {
        return false;
    }

    public abstract PartType getPartType();

    public boolean isPilotSeat() {
        return PartSlot.isPilotSeat(this.getSlotId());
    }

    public boolean isCoPilotSeat() {
        return PartSlot.isCoPilotSeat(this.getSlotId());
    }

    public boolean isSeat() {
        return false;
    }

    public boolean isTurret() {
        return false;
    }

    public boolean canPassengerShootParentWeapon() {
        return this.isPilotSeat() || this.isCoPilotSeat();
    }

    public boolean method_5722(class_1297 entity) {
        if (entity == null) {
            return false;
        }
        class_1297 c = entity.method_5642();
        if (c != null) {
            return this.method_5645(c.method_5781());
        }
        return super.method_5722(entity);
    }

    public boolean method_5645(class_270 team) {
        if (team == null) {
            return false;
        }
        class_1297 v = this.method_5854();
        if (v == null) {
            return false;
        }
        class_1297 c = v.method_5642();
        if (c != null) {
            return team.method_1206(c.method_5781());
        }
        return super.method_5645(team);
    }

    @Nullable
    public class_1297 method_5642() {
        class_1297 v = this.method_5854();
        if (v == null) {
            return null;
        }
        return v.method_5642();
    }

    public float getHealth() {
        return ((Float)this.field_6011.method_12789(HEALTH)).floatValue();
    }

    public void setHealth(float health) {
        this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(Math.max(0.0f, health)));
    }

    public void addHealth(float health) {
        this.setHealth(this.getHealth() + health);
    }

    public abstract boolean canGetHurt();

    @NotNull
    protected class_238 method_33332() {
        if (!this.isStatsHolderLoaded()) {
            return super.method_33332();
        }
        double pX = this.method_23317();
        double pY = this.method_23318();
        double pZ = this.method_23321();
        class_4048 d = ((PartStats)this.getStats()).getEntityDimensions();
        double f = d.field_18067 / 2.0f;
        double f1 = d.field_18068;
        if (class_3532.method_15379((float)this.getZRot()) > 90.0f) {
            f1 *= -1.0;
        }
        return new class_238(pX - f, pY, pZ - f, pX + f, pY + f1, pZ + f);
    }

    public ObjRadarModel.MastType getVehicleMastType() {
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle == null) {
            return ObjRadarModel.MastType.NONE;
        }
        return vehicle.getMastType();
    }

    @Nullable
    public PartSlot getSlot() {
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle == null) {
            return null;
        }
        return vehicle.partsManager.getSlot(this.getSlotId());
    }

    @Nullable
    public I getPartInstance() {
        PartSlot slot = this.getSlot();
        if (slot == null) {
            return null;
        }
        if (slot.getPartData() == null) {
            return null;
        }
        return (I)((Object)slot.getPartData());
    }

    @Nullable
    public String getAssetId() {
        return this.getStatsId();
    }

    @Nullable
    public JsonPresetAssetReader<PartClientStats> getClientPresets() {
        if (!this.isClientSide()) {
            return null;
        }
        return PartAssets.get();
    }

    @NotNull
    public JsonPresetReloadListener<P> getPresets() {
        return PartPresets.get();
    }

    public class_1937 getWorld() {
        return UtilEntity.getLevel((class_1297)this);
    }
}

