/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.parts;

import com.onewhohears.dscombat.client.event.ClientInputEventHandlers;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.instance.SeatInstance;
import com.onewhohears.dscombat.data.parts.stats.SeatStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityRidablePart<P extends SeatStats, I extends SeatInstance<P>>
extends EntityPart<P, I> {
    public EntityRidablePart(class_1299<?> type, class_1937 level, String defaultPreset) {
        super(type, level, defaultPreset);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.isClientSide() && this.getWorld().method_8450().method_8355(DSCGameRules.MOBS_RIDE_VEHICLES)) {
            this.tickRideCollision();
        }
    }

    protected void tickRideCollision() {
        if (this.isPilotSeat()) {
            return;
        }
        if (this.getPassenger() != null) {
            return;
        }
        class_1297 class_12972 = this.method_5854();
        if (!(class_12972 instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)class_12972;
        if ((double)vehicle.getXZSpeed() > 0.1) {
            return;
        }
        List entities = this.getWorld().method_8333((class_1297)this, this.method_5829().method_1014(0.1), this.getRidePredicate());
        for (class_1297 entity : entities) {
            if (!entity.method_5804((class_1297)this)) continue;
            return;
        }
    }

    protected Predicate<? super class_1297> getRidePredicate() {
        return entity -> {
            if (this.equals(entity.method_5668())) {
                return false;
            }
            if (entity.method_7325()) {
                return false;
            }
            return entity instanceof class_1308;
        };
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (!this.isClientSide()) {
            if (player.method_5765()) {
                return class_1269.field_5811;
            }
            if (player.method_5804((class_1297)this)) {
                return class_1269.field_21466;
            }
            if (this.method_5854() != null && player.method_5804(this.method_5854())) {
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    @Override
    public boolean method_5863() {
        return true;
    }

    public void method_5865(class_1297 passenger) {
        class_1297 class_12972 = this.method_5854();
        if (!(class_12972 instanceof EntityVehicle)) {
            super.method_5865(passenger);
            return;
        }
        EntityVehicle craft = (EntityVehicle)class_12972;
        if (this.field_6012 % 20 == 0 && passenger instanceof class_1657) {
            class_1657 player = (class_1657)passenger;
            if (craft.nightVisionHud) {
                player.method_6092(new class_1293(class_1294.field_5925, 240, 0, false, false));
            }
            if (((VehicleStats)craft.getStats()).isSub()) {
                player.method_6092(new class_1293(class_1294.field_5923, 240, 0, false, false));
                player.method_6092(new class_1293(class_1294.field_5925, 240, 0, false, false));
            }
        }
        passenger.method_33574(this.method_19538().method_1019(this.getPassengerRelPos(passenger, craft)));
    }

    protected class_243 getPassengerRelPos(class_1297 passenger, EntityVehicle craft) {
        QuaternionF q = craft.getQBySide();
        double offset = this.method_5621() + passenger.method_5678() + (double)passenger.method_5751();
        return UtilAngles.rotateVector((class_243)new class_243(0.0, offset, 0.0), (QuaternionF)q).method_1023(0.0, (double)passenger.method_5751(), 0.0);
    }

    protected void method_5627(class_1297 passenger) {
        if (!this.isClientSide()) {
            EntityVehicle vehicle = this.getParentVehicle();
            if (vehicle != null && !vehicle.hasOwner()) {
                vehicle.setOwner(passenger);
            }
        } else {
            ClientInputEventHandlers.onEntityMountVehicle(passenger);
        }
        super.method_5627(passenger);
    }

    public boolean method_5818(class_1297 passenger) {
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle == null) {
            return false;
        }
        if (!vehicle.hasPermission(passenger)) {
            return false;
        }
        if (passenger instanceof class_1309) {
            return this.getPassenger() == null;
        }
        return false;
    }

    protected boolean method_5860(class_1297 entityIn) {
        return entityIn instanceof EntityVehicle;
    }

    protected void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        if (this.isClientSide()) {
            return;
        }
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle == null) {
            return;
        }
        vehicle.onSeatDismount(passenger);
    }

    @NotNull
    public class_243 method_24829(class_1309 entity) {
        int minY = this.getWorld().method_31607() + 4;
        class_3966 ehr = UtilEntity.getEntityHitResultAtClip((class_1937)this.getWorld(), (class_1297)entity, (class_243)this.method_19538().method_1031(0.0, 10.0, 0.0), (class_243)this.method_19538(), (class_238)entity.method_5829(), e -> !e.equals((Object)entity), (float)0.3f);
        class_243 dis = ehr != null ? ehr.method_17784().method_1031(0.0, 0.2, 0.0) : super.method_24829(entity);
        if (dis.method_10214() < (double)minY) {
            dis = new class_243(dis.method_10216(), (double)minY, dis.method_10215());
        }
        return dis;
    }

    @Nullable
    public class_1657 getPlayer() {
        List list = this.method_5685();
        for (class_1297 e : list) {
            if (!(e instanceof class_1657)) continue;
            class_1657 p = (class_1657)e;
            return p;
        }
        return null;
    }

    @Nullable
    public class_1309 getPassenger() {
        List list = this.method_5685();
        for (class_1297 e : list) {
            if (!(e instanceof class_1309)) continue;
            class_1309 l = (class_1309)e;
            return l;
        }
        return null;
    }

    @Override
    @Nullable
    public class_1297 method_5642() {
        class_1657 p = this.getPlayer();
        if (p == null) {
            return super.method_5642();
        }
        return p;
    }

    public boolean isPlayerOrBotRiding() {
        if (this.getPlayer() != null) {
            return true;
        }
        return this.hasAIUsingTurret();
    }

    public void explode(class_1282 source, class_1297 parent) {
        this.getWorld().method_8454(parent, source, null, this.method_23317(), this.method_23318(), this.method_23321(), 3.0f, true, class_1927.class_4179.field_18686);
    }

    public boolean hasAIUsingTurret() {
        return false;
    }

    public double method_5621() {
        return this.getPassengerOffsets().field_1351;
    }

    @Override
    public boolean shouldRender() {
        return false;
    }

    @Override
    public PartType getPartType() {
        return PartType.SEAT;
    }

    public boolean method_5753() {
        return true;
    }

    @Override
    public boolean canGetHurt() {
        return false;
    }

    public float getCameraYOffset() {
        return 0.0f;
    }

    @Override
    public boolean isSeat() {
        return true;
    }

    public boolean method_5732() {
        return false;
    }

    public boolean method_5805() {
        return false;
    }

    public boolean canEject() {
        SeatInstance data = (SeatInstance)((Object)this.getPartInstance());
        if (data == null) {
            return false;
        }
        return data.canEject();
    }

    public void useEject() {
        SeatInstance data = (SeatInstance)((Object)this.getPartInstance());
        if (data == null) {
            return;
        }
        data.setCanEject(false);
    }

    public class_243 getPassengerOffsets() {
        return ((SeatStats)this.getStats()).getPassengerOffsets();
    }
}

