/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle.hitbox;

import com.onewhohears.dscombat.data.vehicle.RotableHitboxData;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.CustomExplosion;
import com.onewhohears.dscombat.entity.Revivable;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitboxes;
import com.onewhohears.dscombat.init.ModEntities;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.dscombat.util.math.RotableAABB;
import com.onewhohears.onewholibs.common.network.toclient.ClientBoundSpawnDataPacket;
import com.onewhohears.onewholibs.entity.AdditionalSpawnDataEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_270;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.jetbrains.annotations.NotNull;

public class RotableHitbox
extends class_1297
implements CustomExplosion,
Revivable,
AdditionalSpawnDataEntity {
    public static final class_2940<Float> HEALTH = class_2945.method_12791(RotableHitbox.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> ARMOR = class_2945.method_12791(RotableHitbox.class, (class_2941)class_2943.field_13320);
    private EntityVehicle parent;
    private RotableHitboxData data;
    private RotableAABB hitbox;
    private class_243 test_pos;
    private class_243 test_size;

    public RotableHitbox(EntityVehicle parent, RotableHitboxData data) {
        this((class_1299)ModEntities.ROTABLE_HITBOX.get(), parent.getWorld());
        this.parent = parent;
        this.data = data;
        this.field_5960 = true;
        this.initStats();
        this.setHealth(data.getMaxHealth());
        this.setArmor(data.getMaxArmor());
        RotableHitboxes.addHitbox(this);
    }

    public void readNbt(class_2487 nbt) {
        class_2487 tag = nbt.method_10562(this.getHitboxName());
        if (tag == null || tag.method_33133()) {
            return;
        }
        if (tag.method_10545("health")) {
            this.setHealth(tag.method_10583("health"));
        }
        if (tag.method_10545("armor")) {
            this.setArmor(tag.method_10583("armor"));
        }
    }

    public void writeNbt(class_2487 nbt) {
        class_2487 tag = new class_2487();
        tag.method_10548("health", this.getHealth());
        tag.method_10548("armor", this.getArmor());
        nbt.method_10566(this.getHitboxName(), (class_2520)tag);
    }

    public RotableHitbox(class_1299<?> type, class_1937 level) {
        super(type, level);
    }

    public void handleClientAddEntityPacket(int parentId, String name) {
        this.parent = (EntityVehicle)this.getWorld().method_8469(parentId);
        if (this.parent == null) {
            return;
        }
        this.data = ((VehicleStats)this.parent.getStats()).getHitboxDataByName(name);
        this.initStats();
        this.parent.addRotableHitboxForClient(this);
    }

    protected void initStats() {
        if (this.data == null) {
            return;
        }
        this.hitbox = new RotableAABB(this.getHitboxSize().method_10216(), this.getHitboxSize().method_10214(), this.getHitboxSize().method_10215());
        this.method_18382();
    }

    public void method_5773() {
        if (this.parent == null || this.parent.method_31481()) {
            this.method_31472();
            return;
        }
        if (this.data == null || this.hitbox == null) {
            this.method_31472();
            return;
        }
        if (!this.isClientSide() && this.field_6012 > 20 && this.data.isRemoveOnDestroy() && this.isDestroyed()) {
            this.method_5768();
            return;
        }
        this.positionSelf();
        this.field_5953 = false;
    }

    public boolean isClientSide() {
        return this.getWorld().method_8608();
    }

    public class_1937 getWorld() {
        return UtilEntity.getLevel((class_1297)this);
    }

    protected void positionSelf() {
        this.method_22862();
        QuaternionF q = this.getParent().getQBySide();
        class_243 pos = this.getParent().method_19538().method_1019(UtilAngles.rotateVector((class_243)this.getRelPos(), (QuaternionF)q));
        this.hitbox.setCenterAndRot(pos, q);
        this.method_33574(pos);
    }

    public class_243 collide(class_1297 entity, class_238 aabb, class_243 move) {
        if (this.hitbox == null || this.getParent() == null) {
            return move;
        }
        if (this.getParent().isEntityHitboxCooldown(entity)) {
            return move;
        }
        if (!this.couldCollide(entity)) {
            return move;
        }
        if (!this.hitbox.isInside(aabb, 0.0)) {
            return move;
        }
        if (this.isInside(entity)) {
            class_243 push = this.hitbox.getPushOutPos(entity.method_19538(), entity.method_5829(), 0.0);
            entity.method_29495(push);
            entity.method_24830(true);
            entity.method_38785();
            move = move.method_18805(1.0, 0.0, 1.0);
        }
        this.moveEntityFromParent(entity);
        move = this.hitbox.collide(entity.method_19538(), entity.method_5829(), move);
        this.getParent().addEntityCollideInfo(entity, this, entity.method_19538());
        if (this.getParent().isStuckInHitbox(entity)) {
            this.getParent().addEntityToHitboxCooldown(entity);
            entity.method_29495(new class_243(entity.method_23317(), this.getParent().getMaxHitboxY(), entity.method_23321()));
        }
        return move;
    }

    public class_243 moveEntityFromParent(class_1297 entity) {
        class_243 parent_pos = this.getParent().method_19538();
        class_243 parent_move = this.getParent().method_18798();
        class_243 parent_rot_rate = this.getParent().getAngularVel();
        QuaternionF q = this.getParent().getQBySide();
        QuaternionF qi = q.copy();
        qi.conj();
        class_243 rel_pos = UtilAngles.rotateVector((class_243)entity.method_19538().method_1020(parent_pos), (QuaternionF)qi);
        class_243 rel_tan_vel = parent_rot_rate.method_1021(Math.toRadians(1.0)).method_18805(-1.0, -1.0, 1.0).method_1036(rel_pos);
        class_243 tan_vel = UtilAngles.rotateVector((class_243)rel_tan_vel, (QuaternionF)q);
        class_243 entityMoveByParent = parent_move.method_1019(tan_vel);
        entity.method_33574(entity.method_19538().method_1019(entityMoveByParent));
        entity.method_36456(entity.method_36454() + (float)parent_rot_rate.field_1351);
        return entityMoveByParent;
    }

    public boolean isInside(class_1297 entity) {
        return this.hitbox.isInside(entity.method_5829(), -0.01);
    }

    public boolean couldCollide(class_1297 entity) {
        if (this.getParent() == null) {
            return false;
        }
        if (this.method_31481()) {
            return false;
        }
        if (this.isDestroyed()) {
            return false;
        }
        if (entity.field_5960) {
            return false;
        }
        if (entity.method_31481()) {
            return false;
        }
        if (entity.method_5765()) {
            return false;
        }
        return !entity.method_5668().equals((Object)this.getParent());
    }

    public boolean method_5643(class_1282 source, float amount) {
        return this.getParent().hurtHitbox(source, amount, this);
    }

    protected class_238 method_33332() {
        if (this.hitbox == null) {
            return class_238.method_30048((class_243)this.method_19538(), (double)1.0, (double)1.0, (double)1.0);
        }
        return this.hitbox.getDisguisedAABB(this.method_19538());
    }

    public RotableHitboxData getHitboxData() {
        return this.data;
    }

    public String getHitboxName() {
        return this.getHitboxData().getName();
    }

    public RotableAABB getHitbox() {
        return this.hitbox;
    }

    public class_243 getRelPos() {
        if (this.test_pos != null) {
            return this.test_pos;
        }
        return this.getHitboxData().getRelPos();
    }

    public class_243 getHitboxSize() {
        if (this.test_size != null) {
            return this.test_size;
        }
        return this.getHitboxData().getSize();
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_30949(class_1297 entity) {
        return this.couldCollide(entity);
    }

    @NotNull
    public class_2596<?> method_18002() {
        return new ClientBoundSpawnDataPacket((class_1297)this, (AdditionalSpawnDataEntity)this);
    }

    public boolean method_31746() {
        return false;
    }

    public void method_5650(class_1297.class_5529 removalReason) {
        super.method_5650(removalReason);
        RotableHitboxes.removeHitbox(this);
    }

    protected void method_5693() {
        this.field_6011.method_12784(HEALTH, (Object)Float.valueOf(10.0f));
        this.field_6011.method_12784(ARMOR, (Object)Float.valueOf(10.0f));
    }

    protected void method_5749(class_2487 nbt) {
    }

    protected void method_5652(class_2487 nbt) {
    }

    public EntityVehicle getParent() {
        return this.parent;
    }

    public boolean method_5727(double pX, double pY, double pZ) {
        return false;
    }

    public boolean method_5640(double pDistance) {
        return false;
    }

    public void method_5697(class_1297 entity) {
    }

    public float getHealth() {
        return ((Float)this.field_6011.method_12789(HEALTH)).floatValue();
    }

    public float getMaxHealth() {
        if (this.data == null) {
            return 0.0f;
        }
        return this.data.getMaxHealth();
    }

    public float getArmor() {
        return ((Float)this.field_6011.method_12789(ARMOR)).floatValue();
    }

    public float getMaxArmor() {
        if (this.data == null) {
            return 0.0f;
        }
        return this.data.getMaxArmor();
    }

    public void setHealth(float health) {
        if (health < 0.0f) {
            health = 0.0f;
        } else if (health > this.data.getMaxHealth()) {
            health = this.getMaxHealth();
        }
        this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(health));
    }

    public void setArmor(float armor) {
        if (armor < 0.0f) {
            armor = 0.0f;
        } else if (armor > this.data.getMaxArmor()) {
            armor = this.getMaxArmor();
        }
        this.field_6011.method_12778(ARMOR, (Object)Float.valueOf(armor));
    }

    public void addHealth(float health) {
        this.setHealth(this.getHealth() + health);
    }

    public void addArmor(float armor) {
        this.setArmor(this.getArmor() + armor);
    }

    public void fullyRepair() {
        this.repair(100000.0f);
        this.repair(100000.0f);
    }

    public void repair(float repair) {
        if (!this.isClientSide() && this.method_31481()) {
            this.invokeRevive();
            this.getWorld().method_8649((class_1297)this);
        }
        if (this.getHealth() < this.getMaxHealth()) {
            this.addHealth(repair);
        } else if (this.getArmor() < this.getMaxArmor()) {
            this.addArmor(repair);
        }
    }

    public boolean isDamaged() {
        return this.getHealth() < this.getMaxHealth() || this.getArmor() < this.getMaxArmor();
    }

    public boolean isDestroyed() {
        return this.getHealth() <= 0.0f && this.getMaxHealth() > 0.0f;
    }

    public String toString() {
        if (this.getParent() == null) {
            return super.toString() + "{" + this.getHitboxName() + ",NO_PARENT}";
        }
        return super.toString() + "{" + this.getHitboxName() + ",HI:" + this.getHitboxIndex() + ",PID:" + this.getParent().method_5628() + "}";
    }

    public void setTestPos(class_243 test_pos) {
        this.test_pos = test_pos;
    }

    public void setTestSize(class_243 test_size) {
        this.test_size = test_size;
        this.getHitbox().setExtents(test_size.method_1021(0.5));
    }

    public boolean method_5659() {
        return true;
    }

    @Override
    public void customExplosionHandler(class_1927 exp) {
        if (this.getParent() != null) {
            this.getParent().customExplosionHandler(exp, this);
        }
    }

    public int getHitboxIndex() {
        if (this.data == null) {
            return -1;
        }
        return this.data.getIndex();
    }

    public boolean canHandleInteract() {
        return this.getHitboxIndex() == 0 && this.getParent() != null && !this.getParent().rootHitboxEntityInteract();
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.canHandleInteract()) {
            return this.getParent().method_5688(player, hand);
        }
        return class_1269.field_5811;
    }

    public class_1297 method_5668() {
        return this.getParent() != null ? this.getParent() : this;
    }

    public boolean method_5722(class_1297 entity) {
        return this.method_5668().method_5722(entity);
    }

    public boolean method_5645(class_270 team) {
        return this.method_5668().method_5645(team);
    }

    public double getMaxY() {
        return this.hitbox.getMaxY();
    }

    public class_1799 method_31480() {
        if (this.getParent() != null) {
            return this.getParent().getItem();
        }
        return null;
    }

    @Override
    public void invokeRevive() {
        UtilVehicleEntity.revive(this);
    }

    public void readSpawnData(class_2540 buffer) {
        int parentId = buffer.readInt();
        String hitboxName = buffer.method_19772();
        this.handleClientAddEntityPacket(parentId, hitboxName);
    }

    public void writeSpawnData(class_2540 buffer) {
        buffer.writeInt(this.getParent().method_5628());
        buffer.method_10814(this.getHitboxName());
    }
}

