/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.data.weapon.NonTickingMissileManager;
import com.onewhohears.dscombat.data.weapon.stats.MissileStats;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.Revivable;
import com.onewhohears.dscombat.entity.damagesource.WeaponDamageSource;
import com.onewhohears.dscombat.entity.weapon.EntityBullet;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilClientSafeSounds;
import com.onewhohears.dscombat.util.UtilParticles;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import net.minecraft.class_5250;

public abstract class EntityMissile<T extends MissileStats>
extends EntityBullet<T>
implements Revivable {
    public static final class_2940<Integer> TARGET_ID = class_2945.method_12791(EntityMissile.class, (class_2941)class_2943.field_13327);
    public static final class_2940<class_243> TARGET_POS = class_2945.method_12791(EntityMissile.class, DataSerializers.VEC3);
    public class_1297 target;
    public class_243 targetPos;
    private boolean discardedButTicking;
    private boolean didSonicBoom;
    private int prevTickCount;
    private int tickCountRepeats;
    private int repeatCoolDown;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpXRot;
    private double lerpYRot;

    public EntityMissile(class_1299<? extends EntityMissile<?>> type, class_1937 level, String defaultWeaponId) {
        super((class_1299<? extends EntityBullet<?>>)type, level, defaultWeaponId);
        if (!this.isClientSide()) {
            NonTickingMissileManager.addMissile(this);
        }
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TARGET_ID, (Object)-1);
        this.field_6011.method_12784(TARGET_POS, (Object)class_243.field_1353.method_1031(0.0, -1000.0, 0.0));
    }

    public void writeSpawnData(class_2540 buffer) {
        super.writeSpawnData(buffer);
        DataSerializers.VEC3.method_12715(buffer, (Object)this.method_18798());
    }

    public void readSpawnData(class_2540 buffer) {
        super.readSpawnData(buffer);
        this.method_18799((class_243)DataSerializers.VEC3.method_12716(buffer));
    }

    @Override
    public void init() {
    }

    @Override
    public void method_5773() {
        if (this.isClientSide()) {
            this.clientTickParticles();
        }
        if (this.isTestMode()) {
            return;
        }
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        if (!this.method_31481()) {
            if (!this.isClientSide()) {
                this.tickGuide();
                if (this.targetPos != null) {
                    this.setTargetPos(this.targetPos);
                } else {
                    this.setTargetPos(class_243.field_1353.method_1031(0.0, -1000.0, 0.0));
                }
                if (this.target != null) {
                    this.setTargetId(this.target.method_5628());
                } else {
                    this.setTargetId(-1);
                }
                if (this.target != null && (double)this.method_5739(this.target) <= ((MissileStats)((Object)this.getWeaponStats())).getFuseDist()) {
                    this.method_5768();
                }
                TrackableEntitiesManager.addTrackableEntity((class_1297)this);
                DependencySafety.addExtraEntityToRDP(Objects.requireNonNull(this.method_5682()), (class_1297)this, new class_3222[0]);
            } else {
                this.tickClientGuide();
                if (this.field_5953) {
                    this.engineSound();
                }
                if (this.canSonicBoom()) {
                    this.sonicBoomSound();
                }
            }
        }
        super.method_5773();
        this.tickLerp();
        if (!this.isClientSide() && this.field_6012 > 100 && this.method_18798().method_1033() < 0.1) {
            this.method_5768();
            return;
        }
    }

    public void clientTickParticles() {
        if (this.getAge() <= this.getFuelTicks()) {
            UtilParticles.missileAfterBurner(this.getWorld(), this.method_19538(), this.method_5720().method_1021(-1.0));
        }
        UtilParticles.missileTrail(this.getWorld(), this.method_19538(), this.method_5720(), this.getRadius(), this.method_5799());
    }

    public abstract void tickGuide();

    public void tickClientGuide() {
        class_1297 t;
        int tid;
        class_243 tpos = this.getTargetPos();
        if (tpos.field_1351 == -1000.0) {
            tpos = null;
        }
        this.targetPos = (tid = this.getTargetId()) != -1 ? ((t = this.getWorld().method_8469(tid)) != null ? t.method_19538() : tpos) : tpos;
        this.guideToPosition();
    }

    public void guideToTarget() {
        if (this.target == null) {
            this.targetPos = null;
            return;
        }
        if (this.target.method_31481()) {
            this.target = null;
            this.targetPos = null;
            return;
        }
        if (this.field_6012 % 10 == 0) {
            if (!this.checkTargetRange(this.target, 10000.0)) {
                this.target = null;
                this.targetPos = null;
                return;
            }
            if (!this.checkCanSee(this.target)) {
                this.target = null;
                this.targetPos = null;
                return;
            }
        }
        class_243 tVel = this.target.method_18798();
        if (UtilVehicleEntity.isOnGroundOrWater(this.target)) {
            tVel = tVel.method_18805(1.0, 0.0, 1.0);
        }
        this.targetPos = UtilGeometry.interceptPos((class_243)this.method_19538(), (class_243)this.method_18798(), (class_243)this.target.method_5829().method_1005(), (class_243)tVel);
        this.guideToPosition();
    }

    protected static boolean checkTargetRange(class_1297 weapon, class_1297 target, float fov, double range) {
        if (fov == -1.0f) {
            return (double)weapon.method_5739(target) <= range;
        }
        return UtilGeometry.isPointInsideCone((class_243)target.method_19538(), (class_243)weapon.method_19538(), (class_243)weapon.method_5720(), (double)fov, (double)range);
    }

    protected boolean checkTargetRange(class_1297 target, double range) {
        return EntityMissile.checkTargetRange((class_1297)this, target, ((MissileStats)((Object)this.getWeaponStats())).getFov(), range);
    }

    protected boolean checkCanSee(class_1297 target) {
        return UtilEntity.canEntitySeeEntity((class_1297)this, (class_1297)target, (int)((Integer)Config.COMMON.maxBlockCheckDepth.get()), (double)(((MissileStats)((Object)this.getWeaponStats())).getSeeThroWater() + 1), (double)((MissileStats)((Object)this.getWeaponStats())).getSeeThroBlock());
    }

    private void engineSound() {
        UtilClientSafeSounds.dopplerSound((class_1297)this, ModSounds.MISSILE_ENGINE_1, 0.8f, 1.0f, DSCPhyCons.getVelSound(), false);
    }

    private boolean canSonicBoom() {
        if (this.didSonicBoom) {
            return false;
        }
        if (!this.isClientSide()) {
            return false;
        }
        class_1297 owner = this.method_24921();
        return owner == null || !owner.equals((Object)class_310.method_1551().field_1724);
    }

    private void sonicBoomSound() {
        this.didSonicBoom = UtilClientSafeSounds.missileSonicBoom(this);
    }

    @Override
    public void method_5982() {
    }

    public void tickOutRange() {
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        if (this.field_6012 > this.getMaxAge()) {
            this.method_5768();
            return;
        }
        if (this.dieIfNoTargetOutsideTickRange() && this.targetPos == null) {
            this.method_5768();
            return;
        }
        if (this.field_6012 > 100 && this.method_18798().method_1033() < 0.1) {
            this.method_5768();
            return;
        }
        this.tickGuide();
        this.tickSetMove();
        this.method_33574(this.method_19538().method_1019(this.method_18798()));
        ++this.field_6012;
    }

    public boolean dieIfNoTargetOutsideTickRange() {
        return true;
    }

    @Override
    protected void tickSetMove() {
        double ga;
        double gravityAcc;
        class_243 cm = this.method_18798();
        double cv = cm.method_1033();
        double max = this.getSpeed();
        double B = this.getBleed() * UtilVehicleEntity.getAirDensity((class_1297)this) * 0.4;
        double turnBleed = B * (double)(Math.abs(this.method_36455() - this.field_6004) + Math.abs(this.method_36454() - this.field_5982));
        double airRes = B * cv * 0.01;
        double vel = cv - turnBleed - airRes;
        if (this.getAge() <= this.getFuelTicks()) {
            vel += this.getAcceleration();
        }
        if ((vel += (gravityAcc = Math.max(0.0, ga = Math.sin((float)Math.PI / 180 * UtilAngles.getPitch((class_243)cm)) * this.getGravityAcc() * 0.05))) > max) {
            vel = max;
        } else if (vel < 0.1) {
            vel = 0.1;
        }
        class_243 nm = this.method_5720().method_1021(vel);
        this.method_18799(nm);
    }

    @Override
    protected void tickSetAngle() {
    }

    public void guideToPosition() {
        float rot;
        class_243 cur_dir;
        if (this.targetPos == null) {
            return;
        }
        class_243 goal_dir = this.targetPos.method_1020(this.method_19538());
        float deg_diff = (float)UtilGeometry.angleBetweenDegrees((class_243)goal_dir, (class_243)(cur_dir = this.method_5720()));
        if (deg_diff <= (rot = this.getTurnDegrees())) {
            this.method_36457(UtilAngles.getPitch((class_243)goal_dir));
            this.method_36456(UtilAngles.getYaw((class_243)goal_dir));
        } else {
            class_243 P = cur_dir.method_1036(goal_dir).method_1029();
            class_243 new_dir = UtilAngles.rotateVector((class_243)cur_dir, (QuaternionF)new QuaternionF(UtilGeometry.convertVector((class_243)P), rot, true));
            this.method_36457(UtilAngles.getPitch((class_243)new_dir));
            this.method_36456(UtilAngles.getYaw((class_243)new_dir));
        }
    }

    public float getTurnDegrees() {
        return (float)this.method_18798().method_1033() / this.getTurnRadius() * 57.295776f;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_31481()) {
            return false;
        }
        if (this.equals(source.method_5526())) {
            return false;
        }
        if (this.method_5722(source.method_5529())) {
            return false;
        }
        this.method_5768();
        return true;
    }

    @Override
    public boolean method_5659() {
        return false;
    }

    public double getAcceleration() {
        return ((MissileStats)((Object)this.getWeaponStats())).getAcceleration();
    }

    public double getBleed() {
        return ((MissileStats)((Object)this.getWeaponStats())).getBleed();
    }

    public int getFuelTicks() {
        return ((MissileStats)((Object)this.getWeaponStats())).getFuelTicks();
    }

    public float getTurnRadius() {
        return ((MissileStats)((Object)this.getWeaponStats())).getTurnRadius();
    }

    public int getTargetId() {
        return (Integer)this.field_6011.method_12789(TARGET_ID);
    }

    public void setTargetId(int id) {
        this.field_6011.method_12778(TARGET_ID, (Object)id);
    }

    public class_243 getTargetPos() {
        return (class_243)this.field_6011.method_12789(TARGET_POS);
    }

    public void setTargetPos(class_243 pos) {
        this.field_6011.method_12778(TARGET_POS, (Object)pos);
    }

    public void discardButTick() {
        this.method_31472();
        this.discardedButTicking = true;
        this.repeatCoolDown = 5;
    }

    @Override
    public void method_5768() {
        super.method_5768();
        this.discardedButTicking = false;
    }

    @Override
    public void invokeRevive() {
        UtilVehicleEntity.revive((class_1297)this);
        this.discardedButTicking = false;
    }

    @Override
    public boolean isDiscardedButTicking() {
        return this.discardedButTicking;
    }

    public int getTickCountRepeats() {
        if (this.field_6012 == this.prevTickCount) {
            ++this.tickCountRepeats;
        } else if (this.tickCountRepeats > 0) {
            this.tickCountRepeats = 0;
        }
        this.prevTickCount = this.field_6012;
        if (this.repeatCoolDown > 0) {
            --this.repeatCoolDown;
            return 10;
        }
        return this.tickCountRepeats;
    }

    @Override
    public class_3959.class_242 getFluidClipContext() {
        return class_3959.class_242.field_1345;
    }

    @Override
    public int minExplodeAge() {
        return 20;
    }

    @Override
    protected WeaponDamageSource getImpactDamageSource() {
        return WeaponDamageSource.WeaponDamageType.MISSILE_CONTACT.getSource(this.method_24921(), this);
    }

    @Override
    protected WeaponDamageSource getExplosionDamageSource() {
        return WeaponDamageSource.WeaponDamageType.MISSILE.getSource(this.method_24921(), this);
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (x == this.method_23317() && y == this.method_23318() && z == this.method_23321()) {
            return;
        }
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    private void tickLerp() {
        if (!this.isClientSide()) {
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
            this.lerpSteps = 0;
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.method_23317() + (this.lerpX - this.method_23317()) / (double)this.lerpSteps;
            double d1 = this.method_23318() + (this.lerpY - this.method_23318()) / (double)this.lerpSteps;
            double d2 = this.method_23321() + (this.lerpZ - this.method_23321()) / (double)this.lerpSteps;
            double d3 = class_3532.method_15338((double)(this.lerpYRot - (double)this.method_36454()));
            this.method_36456(this.method_36454() + (float)d3 / (float)this.lerpSteps);
            this.method_36457(this.method_36455() + (float)(this.lerpXRot - (double)this.method_36455()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.method_5814(d0, d1, d2);
            this.method_5710(this.method_36454(), this.method_36455());
        }
    }

    public boolean method_5863() {
        return true;
    }

    @Override
    public void method_7454(class_3966 result) {
        super.method_7454(result);
        if (this.isClientSide()) {
            return;
        }
        if (this.getWorld().method_8450().method_8355(DSCGameRules.BROADCAST_MISSILE_HIT)) {
            class_1297 entity = result.method_17782();
            if (entity == null) {
                return;
            }
            class_3222 targetPlayer = null;
            if (entity instanceof class_3222) {
                class_3222 tsp;
                targetPlayer = tsp = (class_3222)entity;
            } else {
                class_1297 class_12972 = entity.method_5642();
                if (class_12972 instanceof class_3222) {
                    class_3222 tsp;
                    targetPlayer = tsp = (class_3222)class_12972;
                }
            }
            if (targetPlayer == null) {
                return;
            }
            class_1297 owner = this.method_24921();
            if (!(owner instanceof class_3222)) {
                return;
            }
            class_3222 ownerPlayer = (class_3222)owner;
            class_5250 message = UtilMCText.translatable((String)"info.dscombat.missile_impacted_player", (Object[])new Object[]{ownerPlayer.method_5476(), targetPlayer.method_5476()});
            boolean teamOnly = this.getWorld().method_8450().method_8355(DSCGameRules.BROADCAST_MISSILE_HIT_TEAM_ONLY);
            List players = this.getWorld().method_8503().method_3760().method_14571();
            for (class_3222 player : players) {
                if (teamOnly && (ownerPlayer.method_5781() == null || player.method_5781() == null || !ownerPlayer.method_5781().method_1197().equals(player.method_5781().method_1197()))) continue;
                player.method_7353((class_2561)message, false);
            }
        }
    }

    @Override
    public WeaponStats.WeaponClientImpactType getClientImpactType() {
        return WeaponStats.WeaponClientImpactType.MED_MISSILE_EXPLODE;
    }
}

