/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.client.WeaponAssets;
import com.onewhohears.dscombat.data.weapon.client.WeaponClientStats;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.item.ItemVehicle;
import com.onewhohears.dscombat.item.VehicleInteractItem;
import com.onewhohears.dscombat.item.fabric.ItemAmmoImpl;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemAmmo
extends class_1792
implements VehicleInteractItem,
ObjModelItem {
    private final String defaultWeaponId;

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemAmmo create(int stackSize, String defaultWeaponId) {
        void var1_1;
        return ItemAmmoImpl.create(stackSize, (String)var1_1);
    }

    public ItemAmmo(int size, String defaultWeaponId) {
        super(ItemAmmo.weaponProps(size));
        this.defaultWeaponId = defaultWeaponId;
    }

    public void method_7850(@NotNull class_1761 group, @NotNull class_2371<class_1799> items) {
        if (group != ModItems.WEAPONS && group != class_1761.field_7915) {
            return;
        }
        String itemId = UtilItem.getItemKeyString((class_1792)this);
        for (int i = 0; i < WeaponPresets.get().getNum(); ++i) {
            WeaponStats w = ((WeaponStats[])WeaponPresets.get().getAll())[i];
            if (!w.getItemKey().equals(itemId)) continue;
            class_1799 test = new class_1799((class_1935)this);
            class_2487 tag = new class_2487();
            tag.method_10582("weapon", w.getId());
            test.method_7980(tag);
            items.add((Object)test);
        }
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tips, @NotNull class_1836 isAdvanced) {
        super.method_7851(stack, level, tips, isAdvanced);
        String id = ItemAmmo.getWeaponId(stack);
        WeaponStats wd = WeaponPresets.get().get(id);
        if (wd == null) {
            return;
        }
        wd.addToolTips(tips, isAdvanced.method_8035());
        if (isAdvanced.method_8035()) {
            tips.add(ItemVehicle.formatTooltip("WeaponId", id));
        }
    }

    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        String id = ItemAmmo.getWeaponId(stack);
        WeaponStats wd = WeaponPresets.get().get(id);
        if (wd == null) {
            return UtilMCText.translatable((String)this.method_7876()).method_27693(" ").method_10852((class_2561)UtilMCText.translatable((String)"error.dscombat.unknown_preset"));
        }
        return wd.getDisplayNameComponent().method_27693(" ").method_10852((class_2561)UtilMCText.literal((String)wd.getWeaponTypeCode())).method_27693(" ").method_10852((class_2561)UtilMCText.translatable((String)"info.dscombat.ammo"));
    }

    public static String getWeaponId(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ItemAmmo) {
            ItemAmmo ia = (ItemAmmo)class_17922;
            if (stack.method_7969() != null && stack.method_7969().method_10545("weapon")) {
                return stack.method_7969().method_10558("weapon");
            }
            return ia.defaultWeaponId;
        }
        return "";
    }

    public static class_1792.class_1793 weaponProps(int stackSize) {
        return new class_1792.class_1793().method_7892(ModItems.WEAPONS).method_7889(stackSize);
    }

    @Override
    public class_1269 onServerInteract(EntityVehicle vehicle, class_1799 stack, class_1657 player, class_1268 hand) {
        if (!vehicle.isOperational()) {
            return class_1269.field_5814;
        }
        String ammoId = ItemAmmo.getWeaponId(stack);
        for (EntityTurret t : vehicle.getTurrets()) {
            int o = t.addAmmo(stack.method_7947());
            stack.method_7939(o);
            if (stack.method_7947() != 0) continue;
            return class_1269.field_5812;
        }
        int o = vehicle.weaponSystem.addAmmo(ammoId, stack.method_7947(), true);
        stack.method_7939(o);
        return class_1269.field_5812;
    }

    @NotNull
    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        stack.method_7948().method_10582("weapon", this.defaultWeaponId);
        return stack;
    }

    @NotNull
    public String getPreset(@NotNull class_1799 stack) {
        return ItemAmmo.getWeaponId(stack);
    }

    @NotNull
    public String getObjModelId(@NotNull String preset) {
        WeaponStats wd = WeaponPresets.get().get(preset);
        if (wd == null) {
            return "";
        }
        String assetId = wd.getAssetId();
        WeaponClientStats assets = WeaponAssets.get().get(assetId);
        if (assets == null) {
            return "";
        }
        return assets.getModelId();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ObjEntityModels.ModelOverrides getItemModelOverrides(@NotNull String preset) {
        return ObjEntityModels.NO_OVERRIDES;
    }

    @NotNull
    public class_1792 method_8389() {
        return this;
    }
}

