/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.entity.ai.goal.MoveToPassengerSeatGoal;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.item.VehicleInteractItem;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemTicketBook
extends class_1792
implements VehicleInteractItem {
    public static final int VEHICLE_SEARCH_RANGE = 32;

    public ItemTicketBook() {
        super(new class_1792.class_1793().method_7892(ModItems.DSC_ITEMS).method_7889(1));
    }

    @NotNull
    public class_1269 method_7847(@NotNull class_1799 stack, @NotNull class_1657 player, @NotNull class_1309 entity, @NotNull class_1268 hand) {
        class_1937 level = UtilEntity.getLevel((class_1297)player);
        if (level.method_8608()) {
            return class_1269.field_5811;
        }
        if (entity.method_5765()) {
            return ItemTicketBook.sendError(player, "error.dscombat.entity_already_passenger");
        }
        if (!entity.method_5864().method_20210(ModTags.EntityTypes.TICKET_BOOKER) || !(entity instanceof class_1314)) {
            return ItemTicketBook.sendError(player, "error.dscombat.entity_cant_use_tickets");
        }
        class_1314 mob = (class_1314)entity;
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10545("vehicle")) {
            return ItemTicketBook.sendError(player, "error.dscombat.ticket_not_linked_vehicle");
        }
        UUID vehicleId = tag.method_25926("vehicle");
        List vehicles = level.method_8390(EntityVehicle.class, player.method_5829().method_1014(32.0), vehicle -> vehicle.method_5667().equals(vehicleId));
        if (vehicles.isEmpty()) {
            return ItemTicketBook.sendError(player, "error.dscombat.vehicle_not_found");
        }
        EntityVehicle vehicle2 = (EntityVehicle)vehicles.get(0);
        if (!vehicle2.hasOpenPassengerSeat()) {
            return ItemTicketBook.sendError(player, "error.dscombat.no_open_seats");
        }
        mob.field_6201.method_6277(30, (class_1352)new MoveToPassengerSeatGoal(mob, vehicle2));
        player.method_7353((class_2561)UtilMCText.translatable((String)"success.dscombat.ticket_book_assign").method_10862(class_2583.field_24360.method_36139(65280)), true);
        return class_1269.field_5812;
    }

    @Override
    public class_1269 onServerInteract(EntityVehicle vehicle, class_1799 stack, class_1657 player, class_1268 hand) {
        if (!vehicle.hasPermission((class_1297)player)) {
            return class_1269.field_5811;
        }
        class_2561 name = vehicle.method_5477();
        class_2487 tag = stack.method_7948();
        tag.method_25927("vehicle", vehicle.method_5667());
        tag.method_10582("vehicle_name", name.getString());
        stack.method_7980(tag);
        player.method_7353((class_2561)UtilMCText.translatable((String)"success.dscombat.ticket_book_link", (Object[])new Object[]{name}).method_10862(class_2583.field_24360.method_36139(65280)), true);
        return class_1269.field_5812;
    }

    public boolean method_7886(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("vehicle");
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tips, @NotNull class_1836 isAdvanced) {
        super.method_7851(stack, level, tips, isAdvanced);
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10545("vehicle_name")) {
            return;
        }
        String name = tag.method_10558("vehicle_name");
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.ticket_linked_to", (Object[])new Object[]{name}).method_10862(class_2583.field_24360.method_36139(0xAAAAAA)));
    }

    public static class_1269 sendError(class_1657 player, String error) {
        player.method_7353((class_2561)UtilMCText.translatable((String)error).method_10862(class_2583.field_24360.method_36139(0xFF0000)), true);
        return class_1269.field_5814;
    }
}

