/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModParticles;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;

public class UtilParticles {
    public static Random random = new Random();

    public static void vehicleCrashExplosion(class_1937 level, class_243 pos, double expRadius) {
        int i;
        double d;
        expRadius *= 1.8;
        for (d = 1.0; d <= expRadius; d += 1.0) {
            for (i = 0; i < 360; i += 15) {
                level.method_17452((class_2394)ModParticles.LARGE_SMOKE_CLOUD.get(), true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, Math.cos(i) * d, 0.5, Math.sin(i) * d);
            }
        }
        for (d = 1.0; d <= expRadius; d += 1.0) {
            for (i = 0; i < 360; i += 45) {
                level.method_17452((class_2394)ModParticles.LARGE_SMOKE_CLOUD.get(), true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, Math.cos(i), d, Math.sin(i));
            }
        }
        for (d = 1.0; d <= expRadius; d += 1.0) {
            double h = (expRadius - d + 1.0) * 0.075;
            for (int i2 = 0; i2 < 360; i2 += 10) {
                level.method_17452((class_2394)ModParticles.SHRAPNEL.get(), true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, Math.cos(i2) * h, d * 0.15, Math.sin(i2) * h);
            }
        }
        for (int i3 = 0; i3 < 32; ++i3) {
            level.method_17452((class_2394)ModParticles.BIG_FLAME.get(), true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, UtilParticles.randomSpeed(0.3, 0.2), UtilParticles.randomSpeedUp(0.6, 0.3), UtilParticles.randomSpeed(0.3, 0.2));
        }
    }

    public static double randomSpeedUp(double speed, double range) {
        return speed + range * random.nextGaussian();
    }

    public static double randomSpeed(double speed, double range) {
        return speed * (double)UtilParticles.randPosNeg() + range * random.nextGaussian();
    }

    public static int randPosNeg() {
        if (random.nextBoolean()) {
            return 1;
        }
        return -1;
    }

    public static void vehicleParticles(EntityVehicle vehicle) {
        UtilParticles.vehicleAfterBurner(vehicle);
        UtilParticles.fuelLeakSmoke(vehicle);
        UtilParticles.engineFireSmoke(vehicle);
        UtilParticles.vehicleDamageSmoke(vehicle);
    }

    public static void vehicleAfterBurner(EntityVehicle vehicle) {
        QuaternionF q = vehicle.getClientQ();
        class_243 dir = vehicle.method_5720().method_1021((double)(-vehicle.getCurrentThrottle()) * 0.4);
        for (class_243 relPos : vehicle.getAfterBurnerSmokePos()) {
            class_243 pos = UtilAngles.rotateVector((class_243)relPos, (QuaternionF)q).method_1019(vehicle.method_19538());
            UtilParticles.afterBurner(vehicle, pos, dir);
        }
    }

    public static void afterBurner(EntityVehicle vehicle, class_243 pos, class_243 dir) {
        if (vehicle.showContrailParticles()) {
            vehicle.getWorld().method_8406((class_2394)ModParticles.CONTRAIL.get(), pos.field_1352, pos.field_1351, pos.field_1350, dir.field_1352, dir.field_1351, dir.field_1350);
        }
        if (vehicle.showAfterBurnerParticles()) {
            vehicle.getWorld().method_8406((class_2394)ModParticles.AFTER_BURNER.get(), pos.field_1352, pos.field_1351, pos.field_1350, dir.field_1352, dir.field_1351, dir.field_1350);
            dir = dir.method_1021(0.5);
            if (vehicle.showMoreAfterBurnerParticles()) {
                vehicle.getWorld().method_8406((class_2394)ModParticles.AFTER_BURNER.get(), pos.field_1352, pos.field_1351, pos.field_1350, dir.field_1352, dir.field_1351, dir.field_1350);
            }
        }
    }

    public static void fuelLeakSmoke(EntityVehicle vehicle) {
        if (!vehicle.isFuelLeak() || vehicle.getCurrentFuel() <= 0.0f) {
            return;
        }
        class_243 pos = vehicle.method_19538();
        for (int i = 0; i < 4; ++i) {
            vehicle.getWorld().method_8406((class_2394)class_2398.field_20537, pos.field_1352, pos.field_1351, pos.field_1350, random.nextGaussian() * 0.02, -0.1, random.nextGaussian() * 0.02);
        }
    }

    public static void engineFireSmoke(EntityVehicle vehicle) {
        if (!vehicle.isEngineFire()) {
            return;
        }
        for (class_243 pos : vehicle.getEngineFirePos()) {
            int i;
            for (i = 0; i < 2; ++i) {
                UtilParticles.flame(vehicle.getWorld(), pos);
            }
            for (i = 0; i < 10; ++i) {
                UtilParticles.smoke(vehicle.getWorld(), pos);
            }
            for (i = 0; i < 2; ++i) {
                UtilParticles.bigSmoke(vehicle.getWorld(), pos);
            }
        }
    }

    public static void vehicleDamageSmoke(EntityVehicle vehicle) {
        int i;
        float r = vehicle.getHealth() / vehicle.getMaxHealth();
        if (r < 0.5f) {
            UtilParticles.smoke(vehicle.getWorld(), vehicle.method_19538());
        }
        if (r < 0.3f) {
            for (i = 0; i < 2; ++i) {
                UtilParticles.smoke(vehicle.getWorld(), vehicle.method_19538());
            }
            UtilParticles.bigSmoke(vehicle.getWorld(), vehicle.method_19538());
        }
        if (r < 0.1f) {
            for (i = 0; i < 4; ++i) {
                UtilParticles.smoke(vehicle.getWorld(), vehicle.method_19538());
            }
            for (i = 0; i < 3; ++i) {
                UtilParticles.bigSmoke(vehicle.getWorld(), vehicle.method_19538());
            }
        }
    }

    public static void smoke(class_1937 level, class_243 pos) {
        if (Math.random() > 0.65) {
            return;
        }
        level.method_8406((class_2394)class_2398.field_11237, pos.field_1352, pos.field_1351, pos.field_1350, random.nextGaussian() * 0.01, 0.1, random.nextGaussian() * 0.01);
    }

    public static void bigSmoke(class_1937 level, class_243 pos) {
        if (Math.random() > 0.4) {
            return;
        }
        level.method_8406((class_2394)ModParticles.LARGE_SMOKE_CLOUD.get(), pos.field_1352, pos.field_1351, pos.field_1350, random.nextGaussian() * 0.5, random.nextGaussian() * 0.5, random.nextGaussian() * 0.5);
    }

    public static void flame(class_1937 level, class_243 pos) {
        if (Math.random() > 0.8) {
            return;
        }
        level.method_8406((class_2394)class_2398.field_11240, pos.field_1352, pos.field_1351, pos.field_1350, random.nextGaussian() * 0.005, 0.1, random.nextGaussian() * 0.005);
    }

    public static void missileTrail(class_1937 level, class_243 pos, class_243 move, double size, boolean inWater) {
        level.method_8406((class_2394)ModParticles.CONTRAIL.get(), pos.field_1352, pos.field_1351, pos.field_1350, -move.field_1352 * 0.5, -move.field_1351 * 0.5, -move.field_1350 * 0.5);
        level.method_8406((class_2394)ModParticles.CONTRAIL.get(), pos.field_1352, pos.field_1351, pos.field_1350, -move.field_1352 * 0.25, -move.field_1351 * 0.25, -move.field_1350 * 0.25);
    }

    public static void missileAfterBurner(class_1937 level, class_243 pos, class_243 dir) {
        level.method_8406((class_2394)ModParticles.AFTER_BURNER.get(), pos.field_1352, pos.field_1351, pos.field_1350, dir.field_1352, dir.field_1351, dir.field_1350);
    }

    public static void bulletImpact(class_1937 level, class_243 pos, double damage) {
        for (int i = 0; i < 360; i += 30) {
            for (int j = 0; j <= 90; j += 30) {
                level.method_17452((class_2394)class_2398.field_11237, true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, Math.cos(i) * 0.05, Math.sin(j) * 0.05, Math.sin(i) * 0.05);
            }
        }
    }

    public static void bulletExplode(class_1937 level, class_243 pos, double radius, boolean fire) {
        radius *= 0.5;
        for (double d = 1.0; d <= radius; d += 1.0) {
            for (int i = 0; i < 360; i += 30) {
                for (int j = -90; j <= 90; j += 30) {
                    level.method_17452((class_2394)ModParticles.LARGE_SMOKE_CLOUD.get(), true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, Math.cos(i) * d, Math.sin(j) * d, Math.sin(i) * d);
                }
            }
        }
        if (fire) {
            for (int i = 0; i < 24; ++i) {
                level.method_17452((class_2394)ModParticles.BIG_FLAME.get(), true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, UtilParticles.randomSpeed(0.3, 0.2), UtilParticles.randomSpeedUp(0.45, 0.3), UtilParticles.randomSpeed(0.3, 0.2));
            }
        }
    }

    public static void bombExplode(class_1937 level, class_243 pos, double radius, boolean fire) {
        radius *= 0.9;
        for (double d = 1.0; d <= radius; d += 1.0) {
            for (int i = 0; i < 360; i += 20) {
                for (int j = -90; j <= 90; j += 30) {
                    level.method_17452((class_2394)ModParticles.LARGE_SMOKE_CLOUD.get(), true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, Math.cos(i) * d, Math.sin(j) * d, Math.sin(i) * d);
                }
            }
        }
        if (fire) {
            for (int i = 0; i < 24; ++i) {
                level.method_17452((class_2394)ModParticles.BIG_FLAME.get(), true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, UtilParticles.randomSpeed(0.3, 0.2), UtilParticles.randomSpeedUp(0.45, 0.3), UtilParticles.randomSpeed(0.3, 0.2));
            }
        }
    }

    public static void missileExplode(class_1937 level, class_243 pos, double radius, boolean fire) {
        radius *= 0.8;
        for (double d = 1.0; d <= radius; d += 1.0) {
            for (int i = 0; i < 360; i += 20) {
                for (int j = -90; j <= 90; j += 30) {
                    level.method_17452((class_2394)ModParticles.LARGE_SMOKE_CLOUD.get(), true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, Math.cos(i) * d, Math.sin(j) * d, Math.sin(i) * d);
                }
            }
        }
        if (fire) {
            for (int i = 0; i < 24; ++i) {
                level.method_17452((class_2394)ModParticles.BIG_FLAME.get(), true, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, UtilParticles.randomSpeed(0.3, 0.2), UtilParticles.randomSpeedUp(0.45, 0.3), UtilParticles.randomSpeed(0.3, 0.2));
            }
        }
    }
}

