/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientVehicleChainUpdate;
import com.onewhohears.dscombat.entity.parts.EntityChainHook;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class UtilServerPacket {
    public static void sendChainAddPlayer(EntityChainHook hook, class_1657 player) {
        UtilServerPacket.sendChainUpdateToClient(null, hook, player, EntityChainHook.ChainUpdateType.CHAIN_ADD_PLAYER);
    }

    public static void sendChainAddVehicle(EntityVehicle vehicle, EntityChainHook hook, @Nullable class_1657 player) {
        UtilServerPacket.sendChainUpdateToClient(vehicle, hook, player, EntityChainHook.ChainUpdateType.CHAIN_ADD_VEHICLE);
    }

    public static void sendChainDisconnectPlayer(EntityChainHook hook, class_1657 player) {
        UtilServerPacket.sendChainUpdateToClient(null, hook, player, EntityChainHook.ChainUpdateType.CHAIN_DISCONNECT_PLAYER);
    }

    public static void sendChainDisconnectVehicle(EntityVehicle vehicle, EntityChainHook hook) {
        UtilServerPacket.sendChainUpdateToClient(vehicle, hook, null, EntityChainHook.ChainUpdateType.CHAIN_DISCONNECT_VEHICLE);
    }

    public static void sendVehicleAddPlayer(EntityVehicle vehicle, class_1657 player) {
        UtilServerPacket.sendChainUpdateToClient(vehicle, null, player, EntityChainHook.ChainUpdateType.VEHICLE_ADD_PLAYER);
    }

    private static void sendChainUpdateToClient(EntityVehicle vehicle, EntityChainHook hook, class_1657 player, EntityChainHook.ChainUpdateType type) {
        EntityVehicle entity;
        Object object = vehicle != null ? vehicle : (hook != null ? hook : (entity = player != null ? player : null));
        if (entity == null) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientVehicleChainUpdate(vehicle, hook, player, type), (class_1297)entity);
    }

    public static void sendChainAddVehicleTo(EntityVehicle vehicle, EntityChainHook hook, class_3222 reciever) {
        if (vehicle == null || hook == null || reciever == null) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientVehicleChainUpdate(vehicle, hook, null, EntityChainHook.ChainUpdateType.CHAIN_ADD_VEHICLE), (class_1297)reciever);
    }

    public static List<class_3222> getPlayersWithinRadius(MinecraftServer server, class_5321<class_1937> dimension, class_243 center, double radius) {
        class_3218 level = server.method_3847(dimension);
        if (level == null) {
            return List.of();
        }
        return UtilServerPacket.getPlayersWithinRadius(level, center, radius);
    }

    public static List<class_3222> getPlayersWithinRadius(class_3218 level, class_243 center, double radius) {
        double radiusSq = radius * radius;
        return level.method_18766(player -> player.method_19538().method_1025(center) <= radiusSq);
    }
}

