/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.onewhohears.onewholibs.util.math.Mat4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_777;

public class ObjBakedModel {
    private final List<Component> components = new ArrayList<Component>();

    public static Builder builder() {
        return new Builder();
    }

    protected ObjBakedModel() {
    }

    public void render(class_4587 poseStack, class_4597 bufferSource, Function<class_2960, class_1921> renderType, int lightmap, int overlay, float partialTicks, Map<String, Mat4f> transforms) {
        for (Component component : this.components) {
            component.render(poseStack, bufferSource, renderType, lightmap, overlay, transforms);
        }
    }

    public Component getCreateComponent(String name) {
        for (Component component : this.components) {
            if (!component.name.equals(name)) continue;
            return component;
        }
        Component c = new Component(name);
        this.components.add(c);
        return c;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public static class Builder {
        private final ObjBakedModel renderable = new ObjBakedModel();

        private Builder() {
        }

        public PartBuilder<?> child(String name) {
            String[] split = name.split("/");
            if (split.length == 1) {
                Component child = new Component(name);
                this.renderable.components.add(child);
                return new PartBuilder<Builder>(this, child);
            }
            Component parent = this.renderable.getCreateComponent(split[0]);
            PartBuilder<Builder> parentBuilder = new PartBuilder<Builder>(this, parent);
            PartBuilder<Object> childBuilder = null;
            for (int i = 1; i < split.length; ++i) {
                parentBuilder = childBuilder = parentBuilder.child(split[i]);
            }
            return childBuilder != null ? childBuilder : parentBuilder;
        }

        public ObjBakedModel get() {
            return this.renderable;
        }
    }

    public static class Component {
        private final String name;
        private final List<Component> children = new ArrayList<Component>();
        private final List<Mesh> meshes = new ArrayList<Mesh>();

        public Component(String name) {
            this.name = name;
        }

        public void render(class_4587 poseStack, class_4597 bufferSource, Function<class_2960, class_1921> renderType, int lightmap, int overlay, Map<String, Mat4f> context) {
            Mat4f matrix = context.get(this.name);
            if (matrix != null) {
                poseStack.method_22903();
                poseStack.method_34425(matrix.convert());
            }
            for (Component part : this.children) {
                part.render(poseStack, bufferSource, renderType, lightmap, overlay, context);
            }
            for (Mesh mesh : this.meshes) {
                mesh.render(poseStack, bufferSource, renderType, lightmap, overlay);
            }
            if (matrix != null) {
                poseStack.method_22909();
            }
        }

        public Component getCreateChild(String name) {
            for (Component component : this.children) {
                if (!component.name.equals(name)) continue;
                return component;
            }
            Component c = new Component(name);
            this.children.add(c);
            return c;
        }

        public String getName() {
            return this.name;
        }

        public List<Component> getChildren() {
            return this.children;
        }

        public List<Mesh> getMeshes() {
            return this.meshes;
        }
    }

    public static class PartBuilder<T> {
        private final T parent;
        private final Component component;

        private PartBuilder(T parent, Component component) {
            this.parent = parent;
            this.component = component;
        }

        public PartBuilder<PartBuilder<T>> child(String name) {
            Component child = this.component.getCreateChild(name);
            return new PartBuilder<PartBuilder<T>>(this, child);
        }

        public PartBuilder<T> addMesh(class_2960 texture, List<class_777> quads) {
            Mesh mesh = new Mesh(texture);
            mesh.quads.addAll(quads);
            this.component.meshes.add(mesh);
            return this;
        }

        public T end() {
            return this.parent;
        }
    }

    public static class Mesh {
        private static final float[] ONES = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private final class_2960 texture;
        private final List<class_777> quads = new ArrayList<class_777>();

        public Mesh(class_2960 texture) {
            this.texture = texture;
        }

        public void render(class_4587 poseStack, class_4597 bufferSource, Function<class_2960, class_1921> renderType, int lightmap, int overlay) {
            class_4588 consumer = bufferSource.getBuffer(renderType.apply(this.texture));
            for (class_777 quad : this.quads) {
                consumer.method_22920(poseStack.method_23760(), quad, ONES, 1.0f, 1.0f, 1.0f, new int[]{lightmap, lightmap, lightmap, lightmap}, overlay, true);
            }
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public List<class_777> getQuads() {
            return this.quads;
        }
    }
}

