/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.jsonpreset;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloader;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.data.jsonpreset.PresetStatsHolder;
import com.onewhohears.onewholibs.util.UtilParse;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4013;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class JsonPresetAssetReader<T extends JsonPresetStats>
implements class_4013,
JsonPresetReloader<T> {
    protected final Logger LOGGER = LogUtils.getLogger();
    protected final Map<String, T> presetMap = new HashMap<String, T>();
    protected final Map<String, JsonPresetType> typeMap = new HashMap<String, JsonPresetType>();
    protected boolean setup = false;
    private int reloads = 0;
    private T[] allPresets;
    protected final String directory;

    public JsonPresetAssetReader(String directory) {
        this.directory = directory;
    }

    public void method_14491(class_3300 manager) {
        this.LOGGER.info("RELOAD ASSETS: {}", (Object)this.directory);
        this.presetMap.clear();
        this.registerPresetTypes();
        manager.method_14488(this.directory, key -> key.method_12832().endsWith(".json")).forEach((key, resource) -> {
            try {
                this.LOGGER.info("ADD: {}", (Object)key.toString());
                JsonObject json = (JsonObject)UtilParse.GSON.fromJson((Reader)resource.method_43039(), JsonObject.class);
                this.applyJson((class_2960)key, json);
            }
            catch (Exception e) {
                this.LOGGER.error("ERROR: SKIPPING {} because {}", (Object)key.toString(), (Object)e.getMessage());
                e.printStackTrace();
            }
        });
        this.mergeCopyWithParentPresets();
        this.resetCache();
        this.allPresets = null;
        ++this.reloads;
    }

    protected abstract void registerPresetTypes();

    @Override
    @Nullable
    public T get(String id) {
        return JsonPresetReloader.super.get(id);
    }

    @Override
    @Nullable
    public PresetStatsHolder<T> getHolder(String id) {
        return JsonPresetReloader.super.getHolder(id);
    }

    @Override
    public boolean has(String id) {
        return JsonPresetReloader.super.has(id);
    }

    @Override
    public T[] getAll() {
        if (this.allPresets == null) {
            this.allPresets = this.getNewArray(this.getNum());
            AtomicInteger i = new AtomicInteger(0);
            this.presetMap.forEach((id, preset) -> {
                this.allPresets[i.getAndIncrement()] = preset;
            });
            this.sort((JsonPresetStats[])this.allPresets);
        }
        return this.allPresets;
    }

    @Override
    public abstract T[] getNewArray(int var1);

    @Override
    public String[] getAllIds() {
        return JsonPresetReloader.super.getAllIds();
    }

    @Override
    public int getReloads() {
        return this.reloads;
    }

    @Override
    public int getNum() {
        return JsonPresetReloader.super.getNum();
    }

    @Override
    public Map<String, T> getPresetMap() {
        return this.presetMap;
    }

    @Override
    public Map<String, JsonPresetType> getTypeMap() {
        return this.typeMap;
    }

    @Override
    @Nullable
    public T getFromJson(class_2960 key, JsonObject json) {
        return JsonPresetReloader.super.getFromJson(key, json);
    }

    @Override
    public void addPresetType(JsonPresetType type) {
        JsonPresetReloader.super.addPresetType(type);
    }

    @Override
    public Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    public void mergeCopyWithParentPresets() {
        JsonPresetReloader.super.mergeCopyWithParentPresets();
    }

    @Override
    public void mergeWithParent(String id, T preset) {
        JsonPresetReloader.super.mergeWithParent(id, preset);
    }

    @Override
    public <K extends T> List<K> getPresetsOfType(JsonPresetType type) {
        return JsonPresetReloader.super.getPresetsOfType(type);
    }

    @Override
    public void applyJson(class_2960 key, JsonObject json) {
        JsonPresetReloader.super.applyJson(key, json);
    }

    @Override
    public void sort(List<T> presets) {
        JsonPresetReloader.super.sort(presets);
    }

    @Override
    public void sort(T[] presets) {
        JsonPresetReloader.super.sort(presets);
    }

    protected abstract void resetCache();

    @NotNull
    public CompletableFuture<Void> method_25931(class_3302.class_4045 pStage, class_3300 pResourceManager, class_3695 pPreparationsProfiler, class_3695 pReloadProfiler, Executor pBackgroundExecutor, Executor pGameExecutor) {
        return super.method_25931(pStage, pResourceManager, pPreparationsProfiler, pReloadProfiler, pBackgroundExecutor, pGameExecutor);
    }

    @Override
    @NotNull
    public String method_22322() {
        return super.method_22322();
    }
}

