/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.jsonpreset;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloader;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.data.jsonpreset.PresetStatsHolder;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class JsonPresetReloadListener<T extends JsonPresetStats>
extends class_4309
implements JsonPresetReloader<T> {
    protected final Logger LOGGER = LogUtils.getLogger();
    protected final Map<String, T> presetMap = new HashMap<String, T>();
    protected final Map<String, JsonPresetType> typeMap = new HashMap<String, JsonPresetType>();
    protected boolean setup = false;
    private T[] allPresets;
    private int reloads = 0;

    public JsonPresetReloadListener(String directory) {
        super(UtilParse.GSON, directory);
    }

    @Nullable
    public T getFromNbt(class_2487 nbt) {
        if (nbt == null) {
            return null;
        }
        if (!nbt.method_10545("presetId")) {
            return null;
        }
        String presetId = nbt.method_10558("presetId");
        return this.get(presetId);
    }

    @Nullable
    public JsonPresetInstance<?> createInstanceFromNbt(class_2487 nbt) {
        T stats = this.getFromNbt(nbt);
        if (stats == null) {
            return null;
        }
        return ((JsonPresetStats)stats).createPresetInstance(nbt);
    }

    @Override
    public T[] getAll() {
        if (this.allPresets == null) {
            this.allPresets = this.getNewArray(this.getNum());
            AtomicInteger i = new AtomicInteger(0);
            this.presetMap.forEach((id, preset) -> {
                this.allPresets[i.getAndIncrement()] = preset;
            });
            this.sort((JsonPresetStats[])this.allPresets);
        }
        return this.allPresets;
    }

    @Override
    public abstract T[] getNewArray(int var1);

    @Override
    public String[] getAllIds() {
        return JsonPresetReloader.super.getAllIds();
    }

    protected abstract void resetCache();

    public boolean isSetup() {
        return this.setup;
    }

    protected void apply(Map<class_2960, JsonElement> map, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        this.getLogger().info("APPLYING PRESETS TO COMMON CACHE {}", (Object)this.method_22322());
        this.setup = false;
        this.presetMap.clear();
        map.forEach((key, je) -> {
            try {
                JsonObject json = (JsonObject)UtilParse.GSON.fromJson(je, JsonObject.class);
                this.applyJson((class_2960)key, json);
                this.getLogger().info("ADD: {}", (Object)key.toString());
            }
            catch (Exception e) {
                this.getLogger().error("ERROR: SKIPPING {} because {}", (Object)key.toString(), (Object)e.getMessage());
                e.printStackTrace();
            }
        });
        this.mergeCopyWithParentPresets();
        this.allPresets = null;
        this.resetCache();
        ++this.reloads;
        this.setup = true;
        this.getLogger().info("FINISHED {}", (Object)this.getNum());
    }

    public abstract void registerDefaultPresetTypes();

    public void writeToBuffer(class_2540 buffer) {
        this.getLogger().info("WRITING PRESETS TO BUFFER {} {}", (Object)this.method_22322(), (Object)this.getNum());
        buffer.writeInt(this.getNum());
        this.presetMap.forEach((id, preset) -> {
            buffer.method_10814(preset.getKey().toString());
            buffer.method_10814(preset.getJsonData().toString());
            this.getLogger().info("WROTE {}", id);
        });
    }

    public void readBuffer(class_2540 buffer) {
        this.getLogger().info("RECEIVING DATA FROM SERVER {}", (Object)this.method_22322());
        this.setup = false;
        int length = buffer.readInt();
        for (int i = 0; i < length; ++i) {
            String json_string;
            JsonObject json;
            String key_string = buffer.method_19772();
            class_2960 key = new class_2960(key_string);
            T data = this.getFromJson(key, json = (JsonObject)UtilParse.GSON.fromJson(json_string = buffer.method_19772(), JsonObject.class));
            if (data == null) continue;
            this.getLogger().info("RECEIVED: {}", (Object)key.toString());
            this.presetMap.put(((JsonPresetStats)data).getId(), data);
        }
        this.allPresets = null;
        this.resetCache();
        ++this.reloads;
        this.setup = true;
    }

    @Override
    public int getReloads() {
        return this.reloads;
    }

    @Override
    public int getNum() {
        return JsonPresetReloader.super.getNum();
    }

    @Override
    public Map<String, T> getPresetMap() {
        return this.presetMap;
    }

    @Override
    public Map<String, JsonPresetType> getTypeMap() {
        return this.typeMap;
    }

    @Override
    @Nullable
    public T getFromJson(class_2960 key, JsonObject json) {
        return JsonPresetReloader.super.getFromJson(key, json);
    }

    @Override
    public void addPresetType(JsonPresetType type) {
        JsonPresetReloader.super.addPresetType(type);
    }

    @Override
    public Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    public void mergeCopyWithParentPresets() {
        JsonPresetReloader.super.mergeCopyWithParentPresets();
    }

    @Override
    public void mergeWithParent(String id, T preset) {
        JsonPresetReloader.super.mergeWithParent(id, preset);
    }

    @Override
    public <K extends T> List<K> getPresetsOfType(JsonPresetType type) {
        return JsonPresetReloader.super.getPresetsOfType(type);
    }

    @Override
    public void applyJson(class_2960 key, JsonObject json) {
        JsonPresetReloader.super.applyJson(key, json);
    }

    @Override
    public void sort(List<T> presets) {
        JsonPresetReloader.super.sort(presets);
    }

    @Override
    public void sort(T[] presets) {
        JsonPresetReloader.super.sort(presets);
    }

    @Override
    @Nullable
    public T get(String id) {
        return JsonPresetReloader.super.get(id);
    }

    @Override
    @Nullable
    public PresetStatsHolder<T> getHolder(String id) {
        return JsonPresetReloader.super.getHolder(id);
    }

    @Override
    public boolean has(String id) {
        return JsonPresetReloader.super.has(id);
    }

    @Override
    @NotNull
    public String method_22322() {
        return super.method_22322();
    }
}

