/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.intellij.lang.annotations.Language;

public class JsonToNBTUtil {
    protected static final Map<Class<?>, Function<Number, class_2514>> numericConstructors = (Map)class_156.method_654(new HashMap(), m -> {
        m.put(class_2481.class, n -> class_2481.method_23233((byte)n.byteValue()));
        m.put(class_2516.class, n -> class_2516.method_23254((short)n.shortValue()));
        m.put(class_2497.class, n -> class_2497.method_23247((int)n.intValue()));
        m.put(class_2503.class, n -> class_2503.method_23251((long)n.longValue()));
        m.put(class_2494.class, n -> class_2494.method_23244((float)n.floatValue()));
        m.put(class_2489.class, n -> class_2489.method_23241((double)n.doubleValue()));
    });
    private static final Map<Pattern, Function<String, class_2520>> PATTERN_MAP = new LinkedHashMap<Pattern, Function<String, class_2520>>();

    public static class_2487 getTagFromJson(JsonElement element) {
        if (!element.isJsonObject()) {
            throw new JsonSyntaxException("Tag must be an object");
        }
        return JsonToNBTUtil.readObject(element.getAsJsonObject());
    }

    public static class_2487 getTagFromJson(String json) {
        return JsonToNBTUtil.getTagFromJson(json, false);
    }

    public static class_2487 getTagFromJson(String json, boolean lenient) {
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        reader.setLenient(lenient);
        return JsonToNBTUtil.getTagFromJson(new JsonParser().parse(reader));
    }

    public static class_2487 getTagFromJson(Reader json) {
        return JsonToNBTUtil.getTagFromJson(new JsonParser().parse(json));
    }

    public static class_2487 getTagFromJson(JsonReader json) {
        return JsonToNBTUtil.getTagFromJson(new JsonParser().parse(json));
    }

    private static class_2520 readElement(JsonElement elem) {
        if (elem.isJsonNull()) {
            throw new JsonSyntaxException("Null value is not allowed in NBT JSON");
        }
        if (elem.isJsonObject()) {
            return JsonToNBTUtil.readObject(elem.getAsJsonObject());
        }
        if (elem.isJsonArray()) {
            return JsonToNBTUtil.readArray(elem.getAsJsonArray());
        }
        if (elem.isJsonPrimitive()) {
            return JsonToNBTUtil.readValue(elem.getAsJsonPrimitive());
        }
        throw new IllegalArgumentException("Unknown JSON type: " + String.valueOf(elem));
    }

    private static class_2487 readObject(JsonObject obj) {
        class_2487 nbt = new class_2487();
        for (Map.Entry child : obj.entrySet()) {
            nbt.method_10566((String)child.getKey(), JsonToNBTUtil.readElement((JsonElement)child.getValue()));
        }
        return nbt;
    }

    private static class_2520 readArray(JsonArray array) {
        String type;
        JsonPrimitive prim;
        int n = array.size();
        if (n < 1) {
            return new class_2499();
        }
        JsonElement first = array.get(0);
        String differentTypes = "All elements in array must be of the same type";
        if (first.isJsonPrimitive() && (prim = first.getAsJsonPrimitive()).isString() && ("B".equals(type = prim.getAsString()) || "I".equals(type) || "L".equals(type))) {
            ArrayList<Number> list = new ArrayList<Number>();
            for (int i = 1; i < n; ++i) {
                try {
                    JsonPrimitive p = array.get(i).getAsJsonPrimitive();
                    if (p.isBoolean()) {
                        list.add(p.getAsBoolean() ? 1 : 0);
                        continue;
                    }
                    if (p.isNumber()) {
                        list.add(p.getAsNumber());
                        continue;
                    }
                    throw new JsonSyntaxException("All elements in array must be of the same type");
                }
                catch (IllegalStateException e) {
                    throw new JsonSyntaxException("All elements in array must be of the same type");
                }
            }
            return switch (type) {
                case "B" -> new class_2479(list.stream().map(Number::byteValue).collect(Collectors.toList()));
                case "I" -> new class_2495(list.stream().map(Number::intValue).collect(Collectors.toList()));
                case "L" -> new class_2501(list.stream().map(Number::longValue).collect(Collectors.toList()));
                default -> throw new IllegalStateException();
            };
        }
        ArrayList<class_2520> ls = new ArrayList<class_2520>();
        class_2499 list = new class_2499();
        for (Object elem : array) {
            ls.add(JsonToNBTUtil.readElement((JsonElement)elem));
        }
        try {
            if (ls.isEmpty()) {
                return list;
            }
            if (ls.get(0) instanceof class_2514) {
                Class<?> cls = null;
                for (class_2520 elem : ls) {
                    if (!(elem instanceof class_2514)) {
                        throw new JsonSyntaxException("All elements in array must be of the same type");
                    }
                    cls = JsonToNBTUtil.combineNumericTypes(cls, elem.getClass());
                }
                Function<Number, class_2514> con = numericConstructors.get(cls);
                for (class_2520 elem : ls) {
                    list.add((Object)((class_2520)con.apply(((class_2514)elem).method_10702())));
                }
            } else {
                list.addAll(ls);
            }
        }
        catch (UnsupportedOperationException e) {
            throw new JsonSyntaxException("All elements in array must be of the same type");
        }
        return list;
    }

    protected static Class<?> combineNumericTypes(Class<?> a, Class<?> b) {
        if (a == class_2494.class || a == class_2489.class || b == class_2494.class || b == class_2489.class) {
            if (a == class_2503.class || a == class_2489.class || b == class_2503.class || b == class_2489.class) {
                return class_2489.class;
            }
            return class_2494.class;
        }
        if (a == class_2503.class || b == class_2503.class) {
            return class_2503.class;
        }
        if (a == class_2497.class || b == class_2497.class) {
            return class_2497.class;
        }
        if (a == class_2516.class || b == class_2516.class) {
            return class_2516.class;
        }
        return class_2481.class;
    }

    private static <T> void pat(@Language(value="RegExp") String pattern, Function<String, T> parser, Function<T, class_2520> caster) {
        JsonToNBTUtil.pat(pattern, parser.andThen(caster));
    }

    private static void pat(@Language(value="RegExp") String pattern, Function<String, class_2520> parser) {
        PATTERN_MAP.put(Pattern.compile(pattern, 2), parser);
    }

    private static class_2520 readValue(JsonPrimitive elem) {
        if (elem.isBoolean()) {
            return class_2481.method_23234((boolean)elem.getAsBoolean());
        }
        if (elem.isNumber()) {
            if (!elem.getAsString().contains(".")) {
                return class_2497.method_23247((int)elem.getAsInt());
            }
            return class_2489.method_23241((double)elem.getAsDouble());
        }
        if (elem.isString()) {
            String str = elem.getAsString();
            try {
                for (Pattern pattern : PATTERN_MAP.keySet()) {
                    Matcher m = pattern.matcher(str);
                    if (!m.matches()) continue;
                    return PATTERN_MAP.get(pattern).apply(m.group(1));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"' ? class_2519.method_23256((String)str.substring(1, str.length() - 1)) : class_2519.method_23256((String)str);
        }
        throw new IllegalStateException("Unknown JSON primitive: " + String.valueOf(elem));
    }

    static {
        JsonToNBTUtil.pat("([-+]?(?:\\d+[.]?|\\d*[.]\\d+)(?:e[-+]?\\d+)?)d", Double::parseDouble, class_2489::method_23241);
        JsonToNBTUtil.pat("([-+]?(?:\\d+[.]?|\\d*[.]\\d+)(?:e[-+]?\\d+)?)f", Float::parseFloat, class_2494::method_23244);
        JsonToNBTUtil.pat("([-+]?(?:0|[1-9]\\d*))b", Byte::parseByte, class_2481::method_23233);
        JsonToNBTUtil.pat("([-+]?(?:0|[1-9]\\d*))l", Long::parseLong, class_2503::method_23251);
        JsonToNBTUtil.pat("([-+]?(?:0|[1-9]\\d*))s", Short::parseShort, class_2516::method_23254);
        JsonToNBTUtil.pat("([-+]?(?:0|[1-9]\\d*))i", Integer::parseInt, class_2497::method_23247);
        JsonToNBTUtil.pat("(false|true)", str -> "true".equalsIgnoreCase((String)str) ? class_2481.field_21027 : class_2481.field_21026);
    }
}

