/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.util.JsonToNBTUtil;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.Vec3f;
import com.onewhohears.onewholibs.util.math.Vec4f;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import org.slf4j.Logger;

public class UtilParse {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new Gson();

    public static class_2487 getComoundFromResource(String path) {
        class_2487 compound;
        try {
            DataInputStream dis = new DataInputStream(new GZIPInputStream(UtilParse.getResourceAsStream(path)));
            compound = class_2507.method_10627((DataInput)dis);
            dis.close();
        }
        catch (Exception e) {
            LOGGER.error("ERROR: COULD NOT PARSE COMPOUNDTAG " + path);
            e.printStackTrace();
            return new class_2487();
        }
        return compound;
    }

    public static class_2487 getCompoundFromJson(JsonObject json) {
        return JsonToNBTUtil.getTagFromJson((JsonElement)json);
    }

    public static class_2487 getCompoundFromJsonResource(String path) {
        return UtilParse.getCompoundFromJson(UtilParse.getJsonFromResource(path));
    }

    public static JsonObject getJsonFromResource(class_3298 resource) {
        JsonObject json;
        try {
            BufferedReader br = resource.method_43039();
            json = (JsonObject)GSON.fromJson((Reader)br, JsonObject.class);
            br.close();
        }
        catch (Exception e) {
            LOGGER.error("ERROR: COULD NOT PARSE JSON " + resource.method_14480());
            e.printStackTrace();
            return new JsonObject();
        }
        return json;
    }

    public static JsonObject getJsonFromResource(String path) {
        JsonObject json;
        try {
            InputStreamReader isr = new InputStreamReader(UtilParse.getResourceAsStream(path));
            json = (JsonObject)GSON.fromJson((Reader)isr, JsonObject.class);
            isr.close();
        }
        catch (Exception e) {
            LOGGER.error("ERROR: COULD NOT PARSE JSON " + path);
            e.printStackTrace();
            return new JsonObject();
        }
        return json;
    }

    private static InputStream getResourceAsStream(String resource) {
        return UtilParse.class.getResourceAsStream(resource);
    }

    public static void writeVec3(class_2487 tag, class_243 v, String name) {
        class_2487 vec3 = new class_2487();
        vec3.method_10549("x", v.field_1352);
        vec3.method_10549("y", v.field_1351);
        vec3.method_10549("z", v.field_1350);
        tag.method_10566(name, (class_2520)vec3);
    }

    public static class_243 readVec3(class_2487 tag, String name) {
        double z;
        double y;
        double x;
        if (tag.method_10573(name, 10)) {
            class_2487 vec3 = tag.method_10562(name);
            x = vec3.method_10574("x");
            y = vec3.method_10574("y");
            z = vec3.method_10574("z");
        } else {
            x = tag.method_10574(name + "x");
            y = tag.method_10574(name + "y");
            z = tag.method_10574(name + "z");
        }
        return new class_243(x, y, z);
    }

    public static float fixFloatNbt(class_2487 nbt, String tag, class_2487 presetNbt, float min) {
        float f;
        if (nbt.method_10545(tag) && (f = nbt.method_10583(tag)) > min) {
            return f;
        }
        float nbtf = presetNbt.method_10583(tag);
        nbt.method_10548(tag, nbtf);
        return nbtf;
    }

    public static float fixFloatNbt(class_2487 nbt, String tag, float alt) {
        if (!nbt.method_10545(tag)) {
            nbt.method_10548(tag, alt);
            return alt;
        }
        return nbt.method_10583(tag);
    }

    public static String prettyVec3(class_243 v) {
        return UtilParse.prettyVec3(v, 1);
    }

    public static String prettyVec3(class_243 v, int decimals) {
        String f = "%3." + decimals + "f";
        return String.format("[" + f + "," + f + "," + f + "]", v.field_1352, v.field_1351, v.field_1350);
    }

    public static String prettyVec2(class_241 v) {
        return UtilParse.prettyVec2(v, 1);
    }

    public static String prettyVec2(class_241 v, int decimals) {
        String f = "%3." + decimals + "f";
        return String.format("[" + f + "," + f + "]", Float.valueOf(v.field_1343), Float.valueOf(v.field_1342));
    }

    public static String prettyQ(QuaternionF q, int decimals) {
        String f = "%1." + decimals + "f";
        return String.format("[" + f + "," + f + "i," + f + "j," + f + "k]", Float.valueOf(q.r()), Float.valueOf(q.i()), Float.valueOf(q.j()), Float.valueOf(q.k()));
    }

    public static String getRandomString(String[] ... arrays) {
        int size = 0;
        for (int i = 0; i < arrays.length; ++i) {
            size += arrays[i].length;
        }
        int k = 0;
        int r = (int)(Math.random() * (double)size);
        for (int i = 0; i < arrays.length; ++i) {
            for (int j = 0; j < arrays[i].length; ++j) {
                if (k++ != r) continue;
                return arrays[i][j];
            }
        }
        return "";
    }

    public static String getRandomString(int[] weights, String[] ... arrays) {
        if (weights.length != arrays.length) {
            return "";
        }
        int size = 0;
        for (int i = 0; i < arrays.length; ++i) {
            size += arrays[i].length * weights[i];
        }
        int k = 0;
        int r = (int)(Math.random() * (double)size);
        for (int i = 0; i < arrays.length; ++i) {
            for (int w = 0; w < weights[i]; ++w) {
                for (int j = 0; j < arrays[i].length; ++j) {
                    if (k++ != r) continue;
                    return arrays[i][j];
                }
            }
        }
        return "";
    }

    public static boolean getBooleanSafe(JsonObject json, String name, boolean alt) {
        if (!json.has(name)) {
            return alt;
        }
        return json.get(name).getAsBoolean();
    }

    public static int getIntSafe(JsonObject json, String name, int alt) {
        if (!json.has(name)) {
            return alt;
        }
        return json.get(name).getAsInt();
    }

    public static float getFloatSafe(JsonObject json, String name, float alt) {
        if (!json.has(name)) {
            return alt;
        }
        return json.get(name).getAsFloat();
    }

    public static String getStringSafe(JsonObject json, String name, String alt) {
        if (!json.has(name)) {
            return alt;
        }
        return json.get(name).getAsString();
    }

    public static JsonObject getJsonSafe(JsonObject json, String name) {
        if (!json.has(name)) {
            return new JsonObject();
        }
        return json.getAsJsonObject(name);
    }

    public static <E extends Enum<E>> E getEnumSafe(JsonObject json, String name, Class<E> enumClass) {
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        if (enums.length == 0) {
            return null;
        }
        if (!json.has(name)) {
            return (E)enums[0];
        }
        String enumName = json.get(name).getAsString();
        for (int i = 0; i < enums.length; ++i) {
            if (!enums[i].name().equals(enumName)) continue;
            return (E)enums[i];
        }
        return (E)enums[0];
    }

    public static void writeEnum(JsonObject json, String name, Enum<?> value) {
        json.addProperty(name, value.name());
    }

    public static String[] getStringArraySafe(JsonObject json, String name) {
        if (!json.has(name)) {
            return new String[0];
        }
        JsonArray ja = json.get(name).getAsJsonArray();
        String[] sa = new String[ja.size()];
        for (int i = 0; i < ja.size(); ++i) {
            sa[i] = ja.get(i).getAsString();
        }
        return sa;
    }

    public static JsonArray stringArrayToJsonArray(String ... strings) {
        JsonArray ja = new JsonArray();
        for (int i = 0; i < strings.length; ++i) {
            ja.add(strings[i]);
        }
        return ja;
    }

    public static JsonArray resLocArrayToJsonArray(class_2960 ... locs) {
        JsonArray ja = new JsonArray();
        for (int i = 0; i < locs.length; ++i) {
            ja.add(locs[i].toString());
        }
        return ja;
    }

    public static String toColorString(Color color) {
        return Integer.toHexString(0xFF000000 | color.getRGB()).substring(2);
    }

    public static class_243 readVec3(JsonObject json, String name) {
        if (!json.has(name)) {
            return class_243.field_1353;
        }
        JsonObject vec = json.get(name).getAsJsonObject();
        return UtilParse.readVec3Direct(vec);
    }

    public static class_243 readVec3Direct(JsonObject vec) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (vec.has("x")) {
            x = vec.get("x").getAsDouble();
        }
        if (vec.has("y")) {
            y = vec.get("y").getAsDouble();
        }
        if (vec.has("z")) {
            z = vec.get("z").getAsDouble();
        }
        return new class_243(x, y, z);
    }

    public static void writeVec3(JsonObject json, String name, class_243 vec) {
        json.add(name, (JsonElement)UtilParse.writeVec3Direct(vec));
    }

    public static JsonObject writeVec3Direct(class_243 vec) {
        JsonObject v = new JsonObject();
        v.addProperty("x", (Number)vec.field_1352);
        v.addProperty("y", (Number)vec.field_1351);
        v.addProperty("z", (Number)vec.field_1350);
        return v;
    }

    public static class_243[] readVec3Array(JsonObject json, String name) {
        if (!json.has(name)) {
            return new class_243[0];
        }
        JsonArray a = json.get(name).getAsJsonArray();
        class_243[] va = new class_243[a.size()];
        for (int i = 0; i < va.length; ++i) {
            JsonObject vec = a.get(i).getAsJsonObject();
            va[i] = UtilParse.readVec3Direct(vec);
        }
        return va;
    }

    public static void writeVec3Array(JsonObject json, String name, class_243 ... va) {
        JsonArray ja = new JsonArray();
        for (class_243 vec3 : va) {
            ja.add((JsonElement)UtilParse.writeVec3Direct(vec3));
        }
        json.add(name, (JsonElement)ja);
    }

    public static String vec2ToString(class_241 ... v) {
        Object r = "";
        for (int i = 0; i < v.length; ++i) {
            r = (String)r + "[" + v[i].field_1343 + "," + v[i].field_1342 + "]";
        }
        return r;
    }

    public static Vec3f readVec3f(JsonObject json, String name) {
        if (!json.has(name)) {
            return Vec3f.ZERO;
        }
        JsonObject vec = json.get(name).getAsJsonObject();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (vec.has("x")) {
            x = vec.get("x").getAsFloat();
        }
        if (vec.has("y")) {
            y = vec.get("y").getAsFloat();
        }
        if (vec.has("z")) {
            z = vec.get("z").getAsFloat();
        }
        return new Vec3f(x, y, z);
    }

    public static void writeVec3f(JsonObject json, String name, Vec3f vec) {
        JsonObject v = new JsonObject();
        v.addProperty("x", (Number)Float.valueOf(vec.x()));
        v.addProperty("y", (Number)Float.valueOf(vec.y()));
        v.addProperty("z", (Number)Float.valueOf(vec.z()));
        json.add(name, (JsonElement)v);
    }

    public static Vec3f parseVector4To3(String[] line) {
        Vec4f vec4 = UtilParse.parseVector4(line);
        return new Vec3f(vec4.x() / vec4.w(), vec4.y() / vec4.w(), vec4.z() / vec4.w());
    }

    public static class_241 parseVector2(String[] line) {
        return switch (line.length) {
            case 1 -> new class_241(0.0f, 0.0f);
            case 2 -> new class_241(Float.parseFloat(line[1]), 0.0f);
            default -> new class_241(Float.parseFloat(line[1]), Float.parseFloat(line[2]));
        };
    }

    public static Vec3f parseVector3(String[] line) {
        return switch (line.length) {
            case 1 -> new Vec3f(0.0f, 0.0f, 0.0f);
            case 2 -> new Vec3f(Float.parseFloat(line[1]), 0.0f, 0.0f);
            case 3 -> new Vec3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f);
            default -> new Vec3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]));
        };
    }

    public static Vec4f parseVector4(String[] line) {
        return switch (line.length) {
            case 1 -> new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
            case 2 -> new Vec4f(Float.parseFloat(line[1]), 0.0f, 0.0f, 1.0f);
            case 3 -> new Vec4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f, 1.0f);
            case 4 -> new Vec4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), 1.0f);
            default -> new Vec4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), Float.parseFloat(line[4]));
        };
    }

    public static void writeStrings(class_2487 nbt, String name, Collection<String> strings) {
        class_2499 list = new class_2499();
        for (String s : strings) {
            list.add((Object)class_2519.method_23256((String)s));
        }
        nbt.method_10566(name, (class_2520)list);
    }

    public static Collection<String> readStrings(class_2487 nbt, String name) {
        class_2499 list = nbt.method_10554(name, 8);
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            strings.add(list.method_10608(i));
        }
        return strings;
    }

    public static Set<String> readStringSet(class_2487 nbt, String name) {
        class_2499 list = nbt.method_10554(name, 8);
        HashSet<String> strings = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            strings.add(list.method_10608(i));
        }
        return strings;
    }

    public static String getCleanFileName(class_2960 rl) {
        String name = rl.method_12832().replace(".json", "");
        String[] paths = name.split("/");
        return paths[paths.length - 1];
    }
}

